/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integrated.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.enumerate.IntegratedBusinessTypeEnum;
import com.els.modules.bidding.api.dto.PurchaseBiddingHeadDTO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.delivery.api.dto.PurchaseDeliveryHeadDTO;
import com.els.modules.delivery.api.dto.PurchaseDeliveryNoticeDTO;
import com.els.modules.delivery.api.dto.PurchaseRefundsDeliveryHeadDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherHeadDTO;
import com.els.modules.demand.api.dto.PurchaseRequestHeadDTO;
import com.els.modules.ebidding.api.dto.PurchaseEbiddingHeadDTO;
import com.els.modules.finance.api.dto.PurchaseAddCostDTO;
import com.els.modules.finance.api.dto.PurchaseDeductCostDTO;
import com.els.modules.finance.api.dto.PurchasePaymentApplyHeadDTO;
import com.els.modules.inquiry.api.dto.PurchaseEnquiryHeadDTO;
import com.els.modules.integrated.api.dto.IntegratedDocumentDTO;
import com.els.modules.integrated.entity.IntegratedBusinessData;
import com.els.modules.integrated.entity.IntegratedBusinessDataLinks;
import com.els.modules.integrated.entity.IntegratedDocument;
import com.els.modules.integrated.entity.IntegratedDocumentOutDTO;
import com.els.modules.integrated.enumerate.IntegratedDocumentEnum;
import com.els.modules.integrated.mapper.IntegratedBusinessDataLinksMapper;
import com.els.modules.integrated.mapper.IntegratedBusinessDataMapper;
import com.els.modules.integrated.mapper.IntegratedDocumentMapper;
import com.els.modules.integrated.rpc.service.IntegratedInvokeContractRpcService;
import com.els.modules.integrated.rpc.service.IntegratedInvokeFinanceRpcService;
import com.els.modules.integrated.rpc.service.IntegratedInvokeInquiryRpcService;
import com.els.modules.integrated.rpc.service.IntegratedInvokeOrderRpcService;
import com.els.modules.integrated.service.IntegratedDocumentService;
import com.els.modules.integrated.service.IntegratedNodesService;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.reconciliation.api.dto.PurchaseInvoiceDTO;
import com.els.modules.reconciliation.api.dto.PurchaseReconciliationDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IntegratedDocumentServiceImpl
extends BaseServiceImpl<IntegratedDocumentMapper, IntegratedDocument>
implements IntegratedDocumentService {
    @Resource
    private IntegratedDocumentMapper integratedDocumentMapper;
    @Resource
    @Lazy
    private IntegratedInvokeInquiryRpcService integratedInvokeInquiryRpcService;
    @Resource
    @Lazy
    private IntegratedInvokeContractRpcService integratedInvokeContractRpcService;
    @Resource
    @Lazy
    private IntegratedInvokeOrderRpcService integratedInvokeOrderRpcService;
    @Resource
    @Lazy
    private IntegratedInvokeFinanceRpcService integratedInvokeFinanceRpcService;
    @Resource
    private IntegratedBusinessDataMapper integratedBusinessDataMapper;
    private static Object rootId = null;
    @Autowired
    private IntegratedBusinessDataLinksMapper integratedBusinessDataLinksMapper;
    @Resource
    private IntegratedNodesService integratedNodesService;

    @Override
    public Map<String, Object> getDetail(IntegratedDocumentDTO integratedDocumentDTO) {
        IntegratedDocument integratedDocument = new IntegratedDocument();
        BeanUtils.copyProperties((Object)integratedDocumentDTO, (Object)integratedDocument);
        IntegratedDocument document = this.integratedDocumentMapper.selectById(integratedDocument.getId());
        Assert.isNotNull((Object)document, (String)I18nUtil.translate((String)"i18n_alert_PSqmAjtFKmVH_adbc0cc5", (String)"\u6682\u65e0\u53ef\u67e5\u770b\u7684\u5355\u636e\u8054\u67e5\u4fe1\u606f"));
        Assert.isNotNull((Object)document.getLinks(), (String)I18nUtil.translate((String)"i18n_alert_PSqmAjtFKmVH_adbc0cc5", (String)"\u6682\u65e0\u53ef\u67e5\u770b\u7684\u5355\u636e\u8054\u67e5\u4fe1\u606f"));
        ArrayList<Map<String, Object>> nodeList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>();
        JSONArray jsonLinks = new JSONArray();
        this.log.error("\u8fdb\u5165\u8282\u70b9\u4fe1\u606f\u67e5\u8be2\u7ec4\u88c5");
        if (StringUtils.isNotBlank((CharSequence)document.getBetweenId())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(IntegratedDocument::getBetweenId, (Object)document.getBetweenId());
            List integratedDocumentList = this.integratedDocumentMapper.selectList((Wrapper)queryWrapper);
            integratedDocumentList.forEach(tempDocument -> {
                IntegratedDocumentOutDTO outDTO = new IntegratedDocumentOutDTO();
                BeanUtils.copyProperties((Object)tempDocument, (Object)outDTO);
                Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)outDTO), Map.class);
                this.getNodes(map, integratedDocument, nodeList, tempList);
                jsonLinks.addAll((Collection)JSONObject.parseArray((String)tempDocument.getLinks().toString()));
                rootId = map.get(IntegratedDocumentEnum.PAYMENT_APPLY_HEAD_ID.getValue());
            });
        } else {
            IntegratedDocumentOutDTO outDTO = new IntegratedDocumentOutDTO();
            BeanUtils.copyProperties((Object)document, (Object)outDTO);
            Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)outDTO), Map.class);
            this.log.error("\u8fdb\u5165\u8282\u70b9\u4fe1\u606f\u67e5\u8be2\u7ec4\u88c5-------->map:" + map.toString());
            this.getNodes(map, integratedDocument, nodeList, tempList);
            this.log.error("\u8fdb\u5165\u8282\u70b9\u4fe1\u606f\u67e5\u8be2\u7ec4\u88c5-------->links:" + document.getLinks().toString());
            jsonLinks.addAll((Collection)JSONObject.parseArray((String)document.getLinks().toString()));
            rootId = map.containsKey(IntegratedDocumentEnum.REQUEST_HEAD_ID.getValue()) ? map.get(IntegratedDocumentEnum.REQUEST_HEAD_ID.getValue()) : map.get(IntegratedDocumentEnum.ORDER_HEAD_ID.getValue());
        }
        nodeList.addAll(tempList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("rootId", rootId);
        data.put("nodes", nodeList);
        data.put("links", jsonLinks);
        return data;
    }

    @Override
    public void updateMain(String type, String id, String parentId, String childId) {
        if (id.contains(",")) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(id.split(",")));
            if (parentId.contains(",")) {
                ArrayList<String> listParent = new ArrayList<String>(Arrays.asList(parentId.split(",")));
                for (String s : list) {
                    for (String parentIdNew : listParent) {
                        this.genBusType(type, s, parentIdNew, childId);
                    }
                }
            } else {
                for (String s : list) {
                    this.genBusType(type, s, parentId, childId);
                }
            }
        } else if (parentId.contains(",")) {
            ArrayList<String> listParent = new ArrayList<String>(Arrays.asList(parentId.split(",")));
            for (String s : listParent) {
                this.genBusType(type, id, s, childId);
            }
        } else {
            this.genBusType(type, id, parentId, childId);
        }
    }

    private void genBusType(String type, String id, String parentId, String childId) {
        JSONArray array = new JSONArray();
        JSONObject json = new JSONObject();
        IntegratedDocument documentPage = new IntegratedDocument();
        IntegratedDocument dbDocument = this.integratedDocumentMapper.selectById(id);
        if (dbDocument == null) {
            String uuid = id;
            documentPage.setId(uuid);
            this.setSourceId(type, childId, documentPage);
            this.integratedDocumentMapper.insert(documentPage);
            this.setIntergratedDocumentId(type, uuid, childId);
        } else {
            documentPage.setId(id);
            this.setSourceId(type, childId, documentPage);
            json.put("from", (Object)parentId);
            json.put("to", (Object)childId);
            if (dbDocument.getLinks() != null) {
                array = JSONObject.parseArray((String)dbDocument.getLinks().toString());
            }
            array.add((Object)json);
            documentPage.setLinks(array.toString());
            this.checkDatas(dbDocument, documentPage);
            this.integratedDocumentMapper.updateById(documentPage);
        }
    }

    private void insertBusinessData(String type, String id, String childId) {
        LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(IntegratedBusinessData::getIntegratedId, (Object)id)).eq(IntegratedBusinessData::getBusinessId, (Object)childId)).eq(IntegratedBusinessData::getBusinessType, (Object)IntegratedBusinessTypeEnum.getBusinessType((String)type));
        IntegratedBusinessData integratedBusinessData = (IntegratedBusinessData)((Object)this.integratedBusinessDataMapper.selectOne((Wrapper)eq));
        if (integratedBusinessData == null && id != null && childId != null) {
            IntegratedBusinessData integratedBusinessData1 = new IntegratedBusinessData().setBusinessId(childId).setIntegratedId(id).setBusinessType(IntegratedBusinessTypeEnum.getBusinessType((String)type));
            this.integratedBusinessDataMapper.insert((Object)integratedBusinessData1);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String type, String ids, String parentId, String childId) {
        String[] idsArr;
        if (ids == null) {
            return;
        }
        for (String id : idsArr = ids.split(",")) {
            IntegratedDocument document = this.integratedDocumentMapper.selectById(id);
            if (document == null) continue;
            this.delNode(type, childId, document);
            if (document.getLinks() == null) continue;
            JSONArray array = JSONObject.parseArray((String)document.getLinks().toString());
            Iterator it = array.iterator();
            while (it.hasNext()) {
                JSONObject jsonLink = JSONObject.parseObject((String)it.next().toString());
                if (!parentId.contains(String.valueOf(jsonLink.get((Object)"from"))) || !jsonLink.get((Object)"to").equals(childId)) continue;
                it.remove();
            }
            document.setLinks(array.size() > 0 ? array.toString() : null);
            this.integratedDocumentMapper.updateById(document);
        }
    }

    @Override
    public JSONObject getLinkData(JSONObject params) {
        String businessId = params.getString("rootId");
        if (StringUtils.isBlank((CharSequence)businessId)) {
            businessId = params.getString("id");
        }
        if (StringUtils.isBlank((CharSequence)businessId)) {
            throw new ELSBootException("rootId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        JSONObject result = new JSONObject();
        JSONArray nodeArray = new JSONArray();
        JSONArray linkArray = new JSONArray();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_data_type", (Object)"head");
        String finalBusinessId = businessId;
        queryWrapper.and(i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.eq((Object)"business_id", (Object)finalBusinessId)).or()).eq((Object)"doc_no", (Object)finalBusinessId);
        });
        List dataLinksList = this.integratedBusinessDataLinksMapper.selectList((Wrapper)queryWrapper);
        if (dataLinksList.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"business_data_type", (Object)"item");
            queryWrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.eq((Object)"business_id", (Object)finalBusinessId)).or()).eq((Object)"doc_no", (Object)finalBusinessId);
            });
            dataLinksList = this.integratedBusinessDataLinksMapper.selectList((Wrapper)queryWrapper);
        }
        if (dataLinksList.isEmpty()) {
            return result;
        }
        IntegratedBusinessDataLinks firstLink = (IntegratedBusinessDataLinks)((Object)dataLinksList.get(0));
        if ("head".equals(firstLink.getBusinessDataType())) {
            List integratedHeadIdList = dataLinksList.stream().map(IntegratedBusinessDataLinks::getIntegratedHeadId).distinct().collect(Collectors.toList());
            queryWrapper.clear();
            queryWrapper.in((Object)"integrated_head_id", integratedHeadIdList);
            queryWrapper.eq((Object)"business_data_type", (Object)"head");
            dataLinksList = this.integratedBusinessDataLinksMapper.selectList((Wrapper)queryWrapper);
        } else {
            List integratedIdList = dataLinksList.stream().map(IntegratedBusinessDataLinks::getIntegratedId).distinct().collect(Collectors.toList());
            queryWrapper.clear();
            queryWrapper.in((Object)"integrated_id", integratedIdList);
            queryWrapper.eq((Object)"business_data_type", (Object)"item");
            dataLinksList = this.integratedBusinessDataLinksMapper.selectList((Wrapper)queryWrapper);
        }
        HashMap<String, JSONObject> linksMap = new HashMap<String, JSONObject>();
        String rootNodeId = IdWorker.getIdStr();
        JSONObject rootNode = new JSONObject();
        rootNode.put("id", (Object)rootNodeId);
        rootNode.put("text", (Object)"\u8d77\u59cb\u8282\u70b9");
        rootNode.put("businessDataType", (Object)"root");
        nodeArray.add((Object)rootNode);
        for (IntegratedBusinessDataLinks dataLinks : dataLinksList) {
            JSONArray dataJson;
            JSONObject srcData;
            JSONObject jsonData = new JSONObject();
            if (businessId.equals(dataLinks.getBusinessId())) {
                jsonData.put("styleClass", (Object)"my-node-style");
            }
            if (linksMap.containsKey(dataLinks.getBusinessType() + "_" + dataLinks.getBusinessId())) continue;
            jsonData.put("businessId", (Object)dataLinks.getBusinessId());
            jsonData.put("businessNumber", (Object)dataLinks.getDocNo());
            jsonData.put("businessDataType", (Object)dataLinks.getBusinessDataType());
            jsonData.put("businessType", (Object)dataLinks.getBusinessType());
            jsonData.put("businessTypeName", (Object)this.integratedNodesService.getBusinessTypeName(dataLinks.getBusinessType()));
            jsonData.put("integratedId", (Object)dataLinks.getIntegratedId());
            jsonData.put("integratedHeadId", (Object)dataLinks.getIntegratedHeadId());
            jsonData.put("url", (Object)IntegratedDocumentEnum.getUrl((String)dataLinks.getBusinessType()));
            jsonData.put("apiPath", (Object)IntegratedDocumentEnum.getApiPath((String)dataLinks.getBusinessType()));
            jsonData.put("id", (Object)dataLinks.getBusinessId());
            jsonData.put("text", (Object)(jsonData.getString("businessTypeName") + "\n" + dataLinks.getDocNo()));
            linksMap.put(dataLinks.getBusinessType() + "_" + dataLinks.getBusinessId(), jsonData);
            linksMap.put(dataLinks.getBusinessId(), jsonData);
            nodeArray.add((Object)jsonData);
            if ("head".equals(dataLinks.getBusinessDataType())) {
                jsonData.put("businessHeadId", (Object)dataLinks.getBusinessId());
                srcData = this.getData(dataLinks.getBusinessType(), dataLinks.getBusinessDataType(), dataLinks.getBusinessId());
                dataJson = this.integratedNodesService.getPrimaryContentByConfig(dataLinks.getBusinessType(), "head", srcData);
                jsonData.put("dataJson", (Object)dataJson);
            } else {
                jsonData.put("businessHeadId", (Object)dataLinks.getBusinessHeadId());
                srcData = JSONObject.parseObject((String)dataLinks.getDataJson());
                dataJson = this.integratedNodesService.getPrimaryContentByConfig(dataLinks.getBusinessType(), "item", srcData);
                jsonData.put("dataJson", (Object)dataJson);
            }
            if (StringUtils.isNotBlank((CharSequence)dataLinks.getBusinessParentId())) {
                String[] parentIds;
                for (String parentId : parentIds = dataLinks.getBusinessParentId().split(",")) {
                    if (!linksMap.containsKey(parentId)) continue;
                    JSONObject link = new JSONObject();
                    link.put("from", (Object)parentId);
                    link.put("to", (Object)dataLinks.getBusinessId());
                    linkArray.add((Object)link);
                }
                continue;
            }
            JSONObject link = new JSONObject();
            link.put("from", (Object)rootNodeId);
            link.put("to", (Object)dataLinks.getBusinessId());
            linkArray.add((Object)link);
        }
        result.put("rootId", (Object)rootNodeId);
        result.put("nodes", (Object)nodeArray);
        result.put("links", (Object)linkArray);
        return result;
    }

    private void checkDatas(IntegratedDocument document, IntegratedDocument documentPage) {
        if (StringUtils.isNotBlank((CharSequence)document.getInqueryHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getInqueryHeadId())) {
            if (!document.getInqueryHeadId().contains(documentPage.getInqueryHeadId())) {
                documentPage.setInqueryHeadId(document.getInqueryHeadId() + "," + documentPage.getInqueryHeadId());
            } else {
                documentPage.setInqueryHeadId(document.getInqueryHeadId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)document.getEbiddingHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getEbiddingHeadId())) {
            if (!document.getEbiddingHeadId().contains(documentPage.getEbiddingHeadId())) {
                documentPage.setEbiddingHeadId(document.getEbiddingHeadId() + "," + documentPage.getEbiddingHeadId());
            } else {
                documentPage.setEbiddingHeadId(document.getEbiddingHeadId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)document.getBiddingHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getBiddingHeadId())) {
            if (!document.getBiddingHeadId().contains(documentPage.getBiddingHeadId())) {
                documentPage.setBiddingHeadId(document.getBiddingHeadId() + "," + documentPage.getBiddingHeadId());
            } else {
                documentPage.setBiddingHeadId(document.getBiddingHeadId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)document.getOrderHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getOrderHeadId())) {
            if (!document.getOrderHeadId().contains(documentPage.getOrderHeadId())) {
                documentPage.setOrderHeadId(document.getOrderHeadId() + "," + documentPage.getOrderHeadId());
            } else {
                documentPage.setOrderHeadId(document.getOrderHeadId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)document.getContractHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getContractHeadId())) {
            if (!document.getContractHeadId().contains(documentPage.getContractHeadId())) {
                documentPage.setContractHeadId(document.getContractHeadId() + "," + documentPage.getContractHeadId());
            } else {
                documentPage.setContractHeadId(document.getContractHeadId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)document.getSaleDeliveryHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getSaleDeliveryHeadId())) {
            if (!document.getSaleDeliveryHeadId().contains(documentPage.getSaleDeliveryHeadId())) {
                documentPage.setSaleDeliveryHeadId(document.getSaleDeliveryHeadId() + "," + documentPage.getSaleDeliveryHeadId());
            } else {
                documentPage.setSaleDeliveryHeadId(document.getSaleDeliveryHeadId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)document.getPurchaseDeliveryHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getPurchaseDeliveryHeadId())) {
            if (!document.getPurchaseDeliveryHeadId().contains(documentPage.getPurchaseDeliveryHeadId())) {
                documentPage.setPurchaseDeliveryHeadId(document.getPurchaseDeliveryHeadId() + "," + documentPage.getPurchaseDeliveryHeadId());
            } else {
                documentPage.setPurchaseDeliveryHeadId(document.getPurchaseDeliveryHeadId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)document.getRefundsDeliveryHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getRefundsDeliveryHeadId())) {
            if (!document.getRefundsDeliveryHeadId().contains(documentPage.getRefundsDeliveryHeadId())) {
                documentPage.setRefundsDeliveryHeadId(document.getRefundsDeliveryHeadId() + "," + documentPage.getRefundsDeliveryHeadId());
            } else {
                documentPage.setRefundsDeliveryHeadId(document.getRefundsDeliveryHeadId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)document.getVoucherHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getVoucherHeadId())) {
            if (!document.getVoucherHeadId().contains(documentPage.getVoucherHeadId())) {
                documentPage.setVoucherHeadId(document.getVoucherHeadId() + "," + documentPage.getVoucherHeadId());
            } else {
                documentPage.setVoucherHeadId(document.getVoucherHeadId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)document.getReconciliationId()) && StringUtils.isNotBlank((CharSequence)documentPage.getReconciliationId())) {
            if (!document.getReconciliationId().contains(documentPage.getReconciliationId())) {
                documentPage.setReconciliationId(document.getReconciliationId() + "," + documentPage.getReconciliationId());
            } else {
                documentPage.setReconciliationId(document.getReconciliationId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)document.getAddCostId()) && StringUtils.isNotBlank((CharSequence)documentPage.getAddCostId())) {
            if (!document.getAddCostId().contains(documentPage.getAddCostId())) {
                documentPage.setAddCostId(document.getAddCostId() + "," + documentPage.getAddCostId());
            } else {
                documentPage.setAddCostId(document.getAddCostId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)document.getDeductCostId()) && StringUtils.isNotBlank((CharSequence)documentPage.getDeductCostId())) {
            if (!document.getDeductCostId().contains(documentPage.getDeductCostId())) {
                documentPage.setDeductCostId(document.getDeductCostId() + "," + documentPage.getDeductCostId());
            } else {
                documentPage.setDeductCostId(document.getDeductCostId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)document.getInvoiceId()) && StringUtils.isNotBlank((CharSequence)documentPage.getInvoiceId())) {
            if (!document.getInvoiceId().contains(documentPage.getInvoiceId())) {
                documentPage.setInvoiceId(document.getInvoiceId() + "," + documentPage.getInvoiceId());
            } else {
                documentPage.setInvoiceId(document.getInvoiceId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)document.getPaymentApplyHeadId()) && StringUtils.isNotBlank((CharSequence)documentPage.getPaymentApplyHeadId())) {
            if (!document.getPaymentApplyHeadId().contains(documentPage.getPaymentApplyHeadId())) {
                documentPage.setPaymentApplyHeadId(document.getPaymentApplyHeadId() + "," + documentPage.getPaymentApplyHeadId());
            } else {
                documentPage.setPaymentApplyHeadId(document.getPaymentApplyHeadId());
            }
        }
    }

    private JSONObject getData(String businessType, String businessDataType, String businessId) {
        switch (businessType) {
            case "purchaseRequest": {
                PurchaseRequestHeadDTO purchaseRequestHead = this.integratedInvokeInquiryRpcService.getRequestHeadById(businessId);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseRequestHead));
            }
            case "enquiry": {
                PurchaseEnquiryHeadDTO purchaseEnquiryHead = this.integratedInvokeInquiryRpcService.getEnquiryHeadById(businessId);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseEnquiryHead));
            }
            case "ebidding": {
                PurchaseEbiddingHeadDTO purchaseEbiddingHead = this.integratedInvokeInquiryRpcService.getEbinddingHeadById(businessId);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseEbiddingHead));
            }
            case "bidding": {
                PurchaseBiddingHeadDTO purchaseBiddingHead = this.integratedInvokeInquiryRpcService.getBiddingHeadById(businessId);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseBiddingHead));
            }
            case "contract": {
                PurchaseContractHeadDTO purchaseContractHeadDTO = this.integratedInvokeContractRpcService.getContractHeadHeadById(businessId);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseContractHeadDTO));
            }
            case "order": {
                PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.integratedInvokeOrderRpcService.getOrderHeadById(businessId);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseOrderHeadDTO));
            }
            case "deliveryNotice": {
                PurchaseDeliveryNoticeDTO purchaseDeliveryNotice = this.integratedInvokeOrderRpcService.getDeliveryNoticeById(businessId);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseDeliveryNotice));
            }
            case "delivery": {
                PurchaseDeliveryHeadDTO purchaseDeliveryHead = this.integratedInvokeOrderRpcService.getDeliveryHeadById(businessId);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseDeliveryHead));
            }
            case "refundsDelivery": {
                PurchaseRefundsDeliveryHeadDTO purchaseRefundsDeliveryHead = this.integratedInvokeOrderRpcService.getRefundsDeliveryHeadById(businessId);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseRefundsDeliveryHead));
            }
            case "voucher": {
                PurchaseVoucherHeadDTO purchaseVoucherHead = this.integratedInvokeOrderRpcService.getVoucherHeadById(businessId);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseVoucherHead));
            }
            case "reconciliation": {
                PurchaseReconciliationDTO purchaseReconciliation = this.integratedInvokeFinanceRpcService.getReconciliationHeadById(businessId);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseReconciliation));
            }
            case "addCost": {
                PurchaseAddCostDTO purchaseAddCostDTO = this.integratedInvokeFinanceRpcService.getAddCostHeadById(businessId);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseAddCostDTO));
            }
            case "deductCost": {
                PurchaseDeductCostDTO purchaseDeductCostDTO = this.integratedInvokeFinanceRpcService.getDeductCostHeadById(businessId);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseDeductCostDTO));
            }
            case "invoice": {
                PurchaseInvoiceDTO purchaseInvoiceDTO = this.integratedInvokeFinanceRpcService.getInvoiceById(businessId);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchaseInvoiceDTO));
            }
            case "paymentApply": 
            case "advancePayment": {
                PurchasePaymentApplyHeadDTO purchasePaymentApplyHeadDTO = this.integratedInvokeFinanceRpcService.getPaymentApplyHeadById(businessId);
                return JSONObject.parseObject((String)JSONObject.toJSONString((Object)purchasePaymentApplyHeadDTO));
            }
        }
        return null;
    }

    private String getSourceNumber(String key, String value) {
        String sourceNumber = null;
        switch (key) {
            case "requestHeadId": {
                PurchaseRequestHeadDTO purchaseRequestHead = this.integratedInvokeInquiryRpcService.getRequestHeadById(value);
                sourceNumber = purchaseRequestHead.getRequestNumber();
                break;
            }
            case "inqueryHeadId": {
                PurchaseEnquiryHeadDTO purchaseEnquiryHead = this.integratedInvokeInquiryRpcService.getEnquiryHeadById(value);
                sourceNumber = purchaseEnquiryHead.getEnquiryNumber();
                break;
            }
            case "ebiddingHeadId": {
                PurchaseEbiddingHeadDTO purchaseEbiddingHead = this.integratedInvokeInquiryRpcService.getEbinddingHeadById(value);
                sourceNumber = purchaseEbiddingHead.getEbiddingNumber();
                break;
            }
            case "biddingHeadId": {
                PurchaseBiddingHeadDTO purchaseBiddingHead = this.integratedInvokeInquiryRpcService.getBiddingHeadById(value);
                sourceNumber = purchaseBiddingHead.getBiddingNumber();
                break;
            }
            case "contractHeadId": {
                PurchaseContractHeadDTO purchaseContractHeadDTO = this.integratedInvokeContractRpcService.getContractHeadHeadById(value);
                sourceNumber = purchaseContractHeadDTO.getContractNumber();
                break;
            }
            case "orderHeadId": {
                PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.integratedInvokeOrderRpcService.getOrderHeadById(value);
                sourceNumber = purchaseOrderHeadDTO.getOrderNumber();
                break;
            }
            case "deliveryNoticeId": {
                PurchaseDeliveryNoticeDTO purchaseDeliveryNotice = this.integratedInvokeOrderRpcService.getDeliveryNoticeById(value);
                sourceNumber = purchaseDeliveryNotice.getNoticeNumber();
                break;
            }
            case "purchaseDeliveryHeadId": {
                PurchaseDeliveryHeadDTO purchaseDeliveryHead = this.integratedInvokeOrderRpcService.getDeliveryHeadById(value);
                sourceNumber = purchaseDeliveryHead.getDeliveryNumber();
                break;
            }
            case "refundsDeliveryHeadId": {
                PurchaseRefundsDeliveryHeadDTO purchaseRefundsDeliveryHead = this.integratedInvokeOrderRpcService.getRefundsDeliveryHeadById(value);
                sourceNumber = purchaseRefundsDeliveryHead.getRefundsDeliveryNumber();
                break;
            }
            case "voucherHeadId": {
                PurchaseVoucherHeadDTO purchaseVoucherHead = this.integratedInvokeOrderRpcService.getVoucherHeadById(value);
                sourceNumber = purchaseVoucherHead.getVoucherNumber();
                break;
            }
            case "reconciliationId": {
                PurchaseReconciliationDTO purchaseReconciliation = this.integratedInvokeFinanceRpcService.getReconciliationHeadById(value);
                sourceNumber = purchaseReconciliation.getReconciliationNumber();
                break;
            }
            case "addCostId": {
                PurchaseAddCostDTO purchaseAddCostDTO = this.integratedInvokeFinanceRpcService.getAddCostHeadById(value);
                sourceNumber = purchaseAddCostDTO.getCostNumber();
                break;
            }
            case "deductCostId": {
                PurchaseDeductCostDTO purchaseDeductCostDTO = this.integratedInvokeFinanceRpcService.getDeductCostHeadById(value);
                sourceNumber = purchaseDeductCostDTO.getDeductNumber();
                break;
            }
            case "invoiceId": {
                PurchaseInvoiceDTO purchaseInvoiceDTO = this.integratedInvokeFinanceRpcService.getInvoiceById(value);
                sourceNumber = purchaseInvoiceDTO.getInvoiceNumber();
                break;
            }
            case "paymentApplyHeadId": {
                PurchasePaymentApplyHeadDTO purchasePaymentApplyHeadDTO = this.integratedInvokeFinanceRpcService.getPaymentApplyHeadById(value);
                sourceNumber = purchasePaymentApplyHeadDTO.getPaymentApplyNumber();
            }
        }
        return sourceNumber;
    }

    private void delNode(String type, String childId, IntegratedDocument document) {
        List<String> nodes = null;
        switch (type) {
            case "inqueryHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getInqueryHeadId())) break;
                nodes = Arrays.stream(document.getInqueryHeadId().split(",")).collect(Collectors.toList());
                document.setInqueryHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case "ebiddingHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getEbiddingHeadId())) break;
                nodes = Arrays.stream(document.getEbiddingHeadId().split(",")).collect(Collectors.toList());
                document.setEbiddingHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case "biddingHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getBiddingHeadId())) break;
                nodes = Arrays.stream(document.getBiddingHeadId().split(",")).collect(Collectors.toList());
                document.setBiddingHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case "contractHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getContractHeadId())) break;
                nodes = Arrays.stream(document.getContractHeadId().split(",")).collect(Collectors.toList());
                document.setContractHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case "orderHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getOrderHeadId())) break;
                nodes = Arrays.stream(document.getOrderHeadId().split(",")).collect(Collectors.toList());
                document.setOrderHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case "deliveryNoticeId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getDeliveryNoticeId())) break;
                nodes = Arrays.stream(document.getDeliveryNoticeId().split(",")).collect(Collectors.toList());
                document.setDeliveryNoticeId(this.removeBusinessId(nodes, childId));
                break;
            }
            case "purchaseDeliveryHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getPurchaseDeliveryHeadId())) break;
                nodes = Arrays.stream(document.getPurchaseDeliveryHeadId().split(",")).collect(Collectors.toList());
                document.setPurchaseDeliveryHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case "refundsDeliveryHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getRefundsDeliveryHeadId())) break;
                nodes = Arrays.stream(document.getRefundsDeliveryHeadId().split(",")).collect(Collectors.toList());
                document.setRefundsDeliveryHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case "voucherHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getVoucherHeadId())) break;
                nodes = Arrays.stream(document.getVoucherHeadId().split(",")).collect(Collectors.toList());
                document.setVoucherHeadId(this.removeBusinessId(nodes, childId));
                break;
            }
            case "reconciliationId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getReconciliationId())) break;
                nodes = Arrays.stream(document.getReconciliationId().split(",")).collect(Collectors.toList());
                document.setReconciliationId(this.removeBusinessId(nodes, childId));
                break;
            }
            case "addCostId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getAddCostId())) break;
                nodes = Arrays.stream(document.getAddCostId().split(",")).collect(Collectors.toList());
                document.setAddCostId(this.removeBusinessId(nodes, childId));
                break;
            }
            case "deductCostId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getDeductCostId())) break;
                nodes = Arrays.stream(document.getDeductCostId().split(",")).collect(Collectors.toList());
                document.setDeductCostId(this.removeBusinessId(nodes, childId));
                break;
            }
            case "invoiceId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getInvoiceId())) break;
                nodes = Arrays.stream(document.getInvoiceId().split(",")).collect(Collectors.toList());
                document.setInvoiceId(this.removeBusinessId(nodes, childId));
                break;
            }
            case "paymentApplyHeadId": {
                if (!StringUtils.isNotBlank((CharSequence)document.getPaymentApplyHeadId())) break;
                nodes = Arrays.stream(document.getPaymentApplyHeadId().split(",")).collect(Collectors.toList());
                document.setPaymentApplyHeadId(this.removeBusinessId(nodes, childId));
            }
        }
    }

    private String removeBusinessId(List<String> stringList, String childId) {
        Iterator<String> iterator = stringList.iterator();
        while (iterator.hasNext()) {
            if (!childId.equals(iterator.next())) continue;
            iterator.remove();
        }
        return StringUtils.join(stringList, (String)",");
    }

    private void setSourceId(String type, String childId, IntegratedDocument document) {
        switch (type) {
            case "inqueryHeadId": {
                document.setInqueryHeadId(childId);
                break;
            }
            case "ebiddingHeadId": {
                document.setEbiddingHeadId(childId);
                break;
            }
            case "biddingHeadId": {
                document.setBiddingHeadId(childId);
                break;
            }
            case "contractHeadId": {
                document.setContractHeadId(childId);
                break;
            }
            case "orderHeadId": {
                document.setOrderHeadId(childId);
                break;
            }
            case "deliveryNoticeId": {
                document.setDeliveryNoticeId(childId);
                break;
            }
            case "purchaseDeliveryHeadId": {
                document.setPurchaseDeliveryHeadId(childId);
                break;
            }
            case "refundsDeliveryHeadId": {
                document.setRefundsDeliveryHeadId(childId);
                break;
            }
            case "voucherHeadId": {
                document.setVoucherHeadId(childId);
                break;
            }
            case "reconciliationId": {
                document.setReconciliationId(childId);
                break;
            }
            case "addCostId": {
                document.setAddCostId(childId);
                break;
            }
            case "deductCostId": {
                document.setDeductCostId(childId);
                break;
            }
            case "invoiceId": {
                document.setInvoiceId(childId);
                break;
            }
            case "paymentApplyHeadId": {
                document.setPaymentApplyHeadId(childId);
            }
        }
    }

    private void setIntergratedDocumentId(String type, String documentId, String childId) {
        switch (type) {
            case "inqueryHeadId": {
                PurchaseEnquiryHeadDTO purchaseEnquiryHead = this.integratedInvokeInquiryRpcService.getEnquiryHeadById(childId);
                purchaseEnquiryHead.setDocumentId(documentId);
                this.integratedInvokeInquiryRpcService.updateEnquiryHeadById(purchaseEnquiryHead);
                break;
            }
            case "ebiddingHeadId": {
                PurchaseEbiddingHeadDTO purchaseEbiddingHead = this.integratedInvokeInquiryRpcService.getEbinddingHeadById(childId);
                purchaseEbiddingHead.setDocumentId(documentId);
                this.integratedInvokeInquiryRpcService.updateEbinddingHeadById(purchaseEbiddingHead);
                break;
            }
            case "biddingHeadId": {
                PurchaseBiddingHeadDTO purchaseBiddingHead = this.integratedInvokeInquiryRpcService.getBiddingHeadById(childId);
                purchaseBiddingHead.setDocumentId(documentId);
                this.integratedInvokeInquiryRpcService.updateBiddingHeadById(purchaseBiddingHead);
                break;
            }
            case "contractHeadId": {
                PurchaseContractHeadDTO purchaseContractHeadDTO = this.integratedInvokeContractRpcService.getContractHeadHeadById(childId);
                purchaseContractHeadDTO.setDocumentId(documentId);
                this.integratedInvokeContractRpcService.updateContractHeadHeadById(purchaseContractHeadDTO);
                break;
            }
            case "orderHeadId": {
                PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.integratedInvokeOrderRpcService.getOrderHeadById(childId);
                purchaseOrderHeadDTO.setDocumentId(documentId);
                this.integratedInvokeOrderRpcService.updateOrderHeadById(purchaseOrderHeadDTO);
                List<PurchaseOrderItemDTO> orderItemDTOList = this.integratedInvokeOrderRpcService.selectOrderItemDTOByMainId(purchaseOrderHeadDTO.getId());
                orderItemDTOList.forEach(item -> item.setDocumentId(documentId));
                this.integratedInvokeOrderRpcService.batchUpdate(orderItemDTOList);
                break;
            }
            case "deliveryNoticeId": {
                PurchaseDeliveryNoticeDTO deliveryNoticeById = this.integratedInvokeOrderRpcService.getDeliveryNoticeById(childId);
                deliveryNoticeById.setDocumentId(documentId);
                this.integratedInvokeOrderRpcService.updateDeliveryNoticeById(deliveryNoticeById);
                break;
            }
            case "purchaseDeliveryHeadId": {
                PurchaseDeliveryHeadDTO deliveryHeadById = this.integratedInvokeOrderRpcService.getDeliveryHeadById(childId);
                deliveryHeadById.setDocumentId(documentId);
                this.integratedInvokeOrderRpcService.updateDeliveryHeadById(deliveryHeadById);
                break;
            }
            case "refundsDeliveryHeadId": {
                PurchaseRefundsDeliveryHeadDTO refundsDeliveryHeadById = this.integratedInvokeOrderRpcService.getRefundsDeliveryHeadById(childId);
                refundsDeliveryHeadById.setDocumentId(documentId);
                this.integratedInvokeOrderRpcService.updateRefundsDeliveryHeadById(refundsDeliveryHeadById);
                break;
            }
            case "voucherHeadId": {
                PurchaseVoucherHeadDTO voucherHeadById = this.integratedInvokeOrderRpcService.getVoucherHeadById(childId);
                voucherHeadById.setDocumentId(documentId);
                this.integratedInvokeOrderRpcService.updateVoucherHeadById(voucherHeadById);
                break;
            }
            case "reconciliationId": {
                PurchaseReconciliationDTO reconciliationHeadById = this.integratedInvokeFinanceRpcService.getReconciliationHeadById(childId);
                reconciliationHeadById.setDocumentId(documentId);
                this.integratedInvokeFinanceRpcService.updateReconciliationHeadById(reconciliationHeadById);
                break;
            }
            case "addCostId": {
                PurchaseAddCostDTO addCostHeadById = this.integratedInvokeFinanceRpcService.getAddCostHeadById(childId);
                addCostHeadById.setDocumentId(documentId);
                this.integratedInvokeFinanceRpcService.updateAddCostHeadById(addCostHeadById);
                break;
            }
            case "deductCostId": {
                PurchaseDeductCostDTO deductCostHeadById = this.integratedInvokeFinanceRpcService.getDeductCostHeadById(childId);
                deductCostHeadById.setDocumentId(documentId);
                this.integratedInvokeFinanceRpcService.updateDeductCostHeadById(deductCostHeadById);
                break;
            }
            case "invoiceId": {
                PurchaseInvoiceDTO invoiceById = this.integratedInvokeFinanceRpcService.getInvoiceById(childId);
                invoiceById.setDocumentId(documentId);
                this.integratedInvokeFinanceRpcService.updateInvoiceById(invoiceById);
                break;
            }
            case "paymentApplyHeadId": {
                PurchasePaymentApplyHeadDTO paymentApplyHeadById = this.integratedInvokeFinanceRpcService.getPaymentApplyHeadById(childId);
                paymentApplyHeadById.setDocumentId(documentId);
                this.integratedInvokeFinanceRpcService.updatePaymentApplyHeadById(paymentApplyHeadById);
            }
        }
    }

    private void getNodes(Map<String, Object> map, IntegratedDocument integratedDocument, List<Map<String, Object>> nodeList, List<Map<String, Object>> tempList) {
        for (String k : map.keySet()) {
            HashMap<String, Object> node;
            Object v = map.get(k);
            if (v.equals("") || v.equals("null")) continue;
            this.log.error("\u8fdb\u5165\u8282\u70b9\u4fe1\u606fgetNodes:" + k + ":" + v);
            if (k.equals(IntegratedDocumentEnum.REQUEST_HEAD_ID.getValue()) && !v.toString().contains(",")) {
                node = new HashMap<String, Object>();
                node.put("id", v);
                node.put("businesType", IntegratedDocumentEnum.getBusinesType((String)k));
                node.put("text", IntegratedDocumentEnum.getDesc((String)k) + "\n" + this.getSourceNumber(k, v.toString()));
                node.put("url", IntegratedDocumentEnum.getUrl((String)k));
                node.put("apiPath", IntegratedDocumentEnum.getApiPath((String)k));
                nodeList.add(node);
                continue;
            }
            if (k.equals(IntegratedDocumentEnum.ORDER_HEAD_ID.getValue()) && !v.toString().contains(",")) {
                node = new HashMap();
                node.put("id", v);
                node.put("businesType", IntegratedDocumentEnum.getBusinesType((String)k));
                node.put("text", IntegratedDocumentEnum.getDesc((String)k) + "\n" + this.getSourceNumber(k, v.toString()));
                node.put("url", IntegratedDocumentEnum.getUrl((String)k));
                node.put("apiPath", IntegratedDocumentEnum.getApiPath((String)k));
                nodeList.add(node);
                continue;
            }
            List<Object> values = new ArrayList<String>();
            if (v.toString().contains(",")) {
                values = Arrays.asList(v.toString().split(","));
            } else {
                values.add(v.toString());
            }
            values.forEach(value -> {
                HashMap<String, String> tempNode = new HashMap<String, String>();
                if (value.equals(integratedDocument.getRootId())) {
                    tempNode.put("styleClass", "my-node-style");
                }
                tempNode.put("id", (String)value);
                tempNode.put("businesType", IntegratedDocumentEnum.getBusinesType((String)k));
                tempNode.put("text", IntegratedDocumentEnum.getDesc((String)k) + "\n" + this.getSourceNumber(k, (String)value));
                tempNode.put("url", IntegratedDocumentEnum.getUrl((String)k));
                tempNode.put("apiPath", IntegratedDocumentEnum.getApiPath((String)k));
                tempList.add(tempNode);
            });
        }
    }
}

