/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.entity.ElsCompanySet;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.ElsCompanySetService;
import com.els.modules.system.vo.ElsCompanySetVO;
import com.els.modules.system.vo.ElsSetVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a\u53c2\u6570\u8bbe\u7f6e"})
@RestController
@RequestMapping(value={"/base/companySet"})
public class ElsCompanySetController
extends BaseController<ElsCompanySet, ElsCompanySetService> {
    @Autowired
    private ElsCompanySetService elsCompanySetService;
    @Autowired
    private DictService dictService;
    @Autowired
    private DictItemService dictItemService;

    @AutoLog(value="\u4f01\u4e1a\u53c2\u6570\u8bbe\u7f6e-\u67e5\u8be2\u53c2\u6570\u8bbe\u7f6e\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u53c2\u6570\u8bbe\u7f6e\u5217\u8868", notes="\u67e5\u8be2\u53c2\u6570\u8bbe\u7f6e\u5217\u8868")
    @GetMapping(value={"/findList"})
    public Result<?> findList() {
        ElsSetVO setVO = new ElsSetVO();
        List<ElsCompanySetVO> list = this.elsCompanySetService.findList(this.getTenantId());
        list.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getItemDescI18nKey()) && StringUtils.isNotBlank((CharSequence)item.getItemDesc())) {
                item.setItemDesc(I18nUtil.translate((String)item.getItemDescI18nKey(), (String)item.getItemDesc()));
            }
            if (StringUtils.isNotBlank((CharSequence)item.getItemNameI18nKey()) && StringUtils.isNotBlank((CharSequence)item.getItemName())) {
                item.setItemName(I18nUtil.translate((String)item.getItemNameI18nKey(), (String)item.getItemName()));
            }
        });
        setVO.setCompanySetList(list);
        return Result.ok((Object)setVO);
    }

    @AutoLog(value="\u4f01\u4e1a\u53c2\u6570\u8bbe\u7f6e-\u4fdd\u5b58")
    @ApiOperation(value="\u4fdd\u5b58", notes="\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    public Result<?> save(@RequestBody ElsSetVO setVO) {
        String message = this.elsCompanySetService.save(setVO.getCompanySetList());
        return Result.ok((String)(message == null ? "\u64cd\u4f5c\u6210\u529f" : message));
    }

    @ApiOperation(value="\u4f01\u4e1a\u53c2\u6570\u8bbe\u7f6e-\u83b7\u53d6\u4f01\u4e1a\u5f00\u542f\u6743\u9650\u7684\u6a21\u5757\u5217\u8868")
    @GetMapping(value={"/findOpenbusinessType"})
    public Result<?> findOpenbusinessType() {
        JSONObject companySet;
        LoginUser user = SysUtil.getLoginUser();
        String permissionScope = null;
        if (user != null && (companySet = user.getCompanySet()) != null) {
            permissionScope = companySet.getString("permissionScope");
        }
        ArrayList<DictItem> dictItems = new ArrayList<DictItem>();
        DictItem dictItem = new DictItem();
        dictItem.setItemValue("all");
        dictItem.setItemText(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"));
        dictItems.add(dictItem);
        if (StrUtil.isNotBlank((CharSequence)permissionScope)) {
            LambdaQueryWrapper dictQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)dictQueryWrapper.eq(Dict::getElsAccount, (Object)"100000")).eq(Dict::getDictCode, (Object)"permissionScope");
            Dict dict = (Dict)this.dictService.getOne((Wrapper)dictQueryWrapper);
            if (dict != null) {
                List<DictItem> items = this.dictItemService.selectItemsByMainId(dict.getId());
                List scopeList = StrUtil.split((CharSequence)permissionScope, (CharSequence)",");
                for (DictItem item : items) {
                    if (!scopeList.contains(item.getItemValue())) continue;
                    dictItems.add(item);
                }
            }
        }
        return Result.ok(dictItems);
    }
}

