/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.service.CommonService;
import com.els.common.util.RedisUtil;
import com.els.common.util.SqlInjectionUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.common.mapper.CommonMapper;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CommonServiceImpl
implements CommonService {
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private CommonMapper commonMapper;
    private static final String CATALOGUE = "sys:cache:dict";
    private static final String COLON = ":";

    public String queryTableDictTextByFilterSql(String elsAccount, String key, String table, String text, String value, String filterSql) {
        List<DictDTO> resultList = this.queryTableDictListByFilterSql(elsAccount, table, text, value, filterSql);
        String result = "";
        if (CollectionUtil.isNotEmpty(resultList)) {
            for (DictDTO model : resultList) {
                if (model == null || !StrUtil.isNotBlank((CharSequence)model.getValue()) || !model.getValue().equals(key)) continue;
                result = model.getValue() + "_" + model.getText();
                break;
            }
            if (resultList.size() == 1 && StrUtil.isBlank((CharSequence)result)) {
                result = resultList.get(0).getText();
            }
        }
        return result;
    }

    public List<DictDTO> queryTableDictListByFilterSql(String elsAccount, String table, String text, String value, String filterSql) {
        StringBuilder redisKey = new StringBuilder(CATALOGUE);
        redisKey.append(COLON).append(elsAccount).append(COLON).append(table).append(COLON).append(text).append(COLON).append(value).append(COLON).append(filterSql);
        List result = (List)this.redisUtil.get(redisKey.toString());
        if (CollectionUtil.isEmpty((Collection)result)) {
            StringBuilder adminSql;
            SqlInjectionUtil.filterContent((String)table);
            SqlInjectionUtil.filterContent((String)text);
            SqlInjectionUtil.filterContent((String)value);
            SqlInjectionUtil.filterContent((String)filterSql);
            filterSql = StrUtil.isBlank((CharSequence)filterSql) ? " 1 = 1" : filterSql;
            StringBuilder currentSql = new StringBuilder(filterSql);
            currentSql.append(" and is_deleted = '0'");
            if (!filterSql.contains("els_account")) {
                currentSql.append(" and els_account='").append(elsAccount).append("' ");
            }
            if (CollectionUtil.isEmpty((Collection)(result = this.commonMapper.queryTableDictTextByFilterSql(table, text, value, currentSql.toString()))) && "local".equals(SysUtil.getDeployWay())) {
                adminSql = new StringBuilder(filterSql);
                adminSql.append(" and is_deleted = '0'").append(" and els_account='").append(SysUtil.getPurchaseAccount()).append("' ");
                result = this.commonMapper.queryTableDictTextByFilterSql(table, text, value, adminSql.toString());
            }
            if (CollectionUtil.isEmpty((Collection)result)) {
                adminSql = new StringBuilder(filterSql);
                adminSql.append(" and is_deleted = '0'").append(" and els_account='").append("100000").append("' ");
                result = this.commonMapper.queryTableDictTextByFilterSql(table, text, value, adminSql.toString());
            }
            this.redisUtil.set(redisKey.toString(), (Object)result, 1800L);
        }
        return SysUtil.copyProperties((List)result, DictDTO.class);
    }

    public Boolean checkExist(String dataId, String tableName, String fieldName, String fieldValue) {
        Long num;
        if (StrUtil.isNotBlank((CharSequence)dataId)) {
            if (fieldName.contains(",")) {
                fieldName = "CONCAT(" + fieldName + ")";
            }
            num = this.commonMapper.duplicateCheckCountSql(tableName, fieldName, fieldValue, dataId);
        } else {
            if (fieldName.contains(",")) {
                fieldName = "CONCAT(" + fieldName + ")";
            }
            num = this.commonMapper.duplicateCheckCountSqlNoDataId(tableName, fieldName, fieldValue, TenantContext.getTenant());
        }
        return num != null && num != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryTableDictItemsByValue(String table, String text, String code, String filterSql, String val, String elsAccountParam) {
        try {
            String elsAccount = StrUtil.isBlank((CharSequence)elsAccountParam) ? TenantContext.getTenant() : elsAccountParam;
            TenantContext.setTenant((String)elsAccount);
            StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(table).append(code).append(filterSql);
            String value = (String)this.redisUtil.get(redisKey.toString());
            if (StrUtil.isBlank((CharSequence)value)) {
                if (StrUtil.isBlank((CharSequence)filterSql)) {
                    filterSql = "1 = 1";
                }
                StringBuilder sql = new StringBuilder(filterSql);
                sql.append(" and is_deleted = '0'");
                if (!filterSql.contains("els_account")) {
                    sql.append(" and els_account='").append(elsAccount).append("' ");
                }
                if (StrUtil.isBlank((CharSequence)(value = this.commonMapper.queryTableDictItemsByValue(table, code, sql.toString()))) && "local".equals(SysUtil.getDeployWay())) {
                    sql = new StringBuilder(filterSql);
                    sql.append(" and is_deleted = '0'");
                    if (!filterSql.contains("els_account")) {
                        sql.append(" and els_account='").append(SysUtil.getPurchaseAccount()).append("' ");
                    }
                    value = this.commonMapper.queryTableDictItemsByValue(table, code, sql.toString());
                }
                if (StrUtil.isBlank((CharSequence)value)) {
                    sql = new StringBuilder(filterSql);
                    sql.append(" and is_deleted = '0'");
                    if (!filterSql.contains("els_account")) {
                        sql.append(" and els_account='").append("100000").append("' ");
                    }
                    value = this.commonMapper.queryTableDictItemsByValue(table, code, sql.toString());
                }
                this.redisUtil.set(redisKey.toString(), (Object)value, 1800L);
            }
            String string = value;
            return string;
        }
        finally {
            TenantContext.clear();
        }
    }

    public String queryTableDictTextByFilterSqlForExcel(String table, String text, String filterSql, String elsAccount) {
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(table).append(text).append(filterSql);
        String value = (String)this.redisUtil.get(redisKey.toString());
        if (StrUtil.isBlank((CharSequence)value)) {
            if (StrUtil.isBlank((CharSequence)filterSql)) {
                filterSql = "1 = 1";
            }
            StringBuilder sql = new StringBuilder(filterSql);
            sql.append(" and is_deleted = '0'");
            if (!filterSql.contains("els_account")) {
                sql.append(" and els_account='").append(elsAccount).append("' ");
            }
            if (StrUtil.isBlank((CharSequence)(value = this.commonMapper.queryTableDictItemsByValue(table, text, sql.toString()))) && "local".equals(SysUtil.getDeployWay())) {
                sql = new StringBuilder(filterSql);
                sql.append(" and is_deleted = '0'");
                if (!filterSql.contains("els_account")) {
                    sql.append(" and els_account='").append(SysUtil.getPurchaseAccount()).append("' ");
                }
                value = this.commonMapper.queryTableDictItemsByValue(table, text, sql.toString());
            }
            if (StrUtil.isBlank((CharSequence)value)) {
                sql = new StringBuilder(filterSql);
                sql.append(" and is_deleted = '0'");
                if (!filterSql.contains("els_account")) {
                    sql.append(" and els_account='").append("100000").append("' ");
                }
                value = this.commonMapper.queryTableDictItemsByValue(table, text, sql.toString());
            }
            this.redisUtil.set(redisKey.toString(), (Object)value, 1800L);
        }
        return value;
    }
}

