/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.storage.spi.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.config.StorageProperties;
import com.els.modules.attachment.storage.enumerate.FileStorageTypeEnum;
import com.els.modules.attachment.storage.spi.AbstractStorageSpi;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.exception.MultiObjectDeleteException;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.DeleteObjectsRequest;
import com.qcloud.cos.model.GeneratePresignedUrlRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.ResponseHeaderOverrides;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.utils.DateUtils;
import com.qcloud.cos.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cosStorageSpi")
public class CosStorageClient
extends AbstractStorageSpi {
    private static final Logger log = LoggerFactory.getLogger(CosStorageClient.class);

    public COSClient loadStorageClient() {
        return (COSClient)SpringContextUtils.getBean((String)"defaultCosClient");
    }

    @Override
    public String type() {
        return FileStorageTypeEnum.COS.getCode();
    }

    @Override
    public String loadDownloadPath(String objectPath) {
        if (objectPath.startsWith(File.separator)) {
            objectPath = objectPath.substring(1);
        }
        return this.getBaseUrl() + objectPath;
    }

    @Override
    public boolean store(StorageFileInfo fileInfo) {
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength(fileInfo.getSize().longValue());
            objectMetadata.setContentType(this.contentType(fileInfo.getFilename()));
            objectMetadata.setHeader("x-cos-acl", (Object)"public-read");
            StorageProperties.CosProperties cosProperties = this.getStoreProperties().getCos();
            PutObjectRequest putObjectRequest = new PutObjectRequest(cosProperties.getBucketName(), fileInfo.getPath(), fileInfo.getInputStream(), objectMetadata);
            putObjectRequest.setStorageClass(StorageClass.Standard);
            PutObjectResult putObjectResult = this.loadStorageClient().putObject(putObjectRequest);
            String etag = putObjectResult.getETag();
            log.info(":::CosStorageClient\u4e0a\u4f20\u6587\u4ef6:{},\u7ed3\u679c:{}", (Object)fileInfo.getPath(), (Object)etag);
            return true;
        }
        catch (Exception ex) {
            log.info(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u4e0a\u4f20\u6587\u4ef6:{}\u5931\u8d25:{}", new Object[]{this.type(), fileInfo.getPath(), ex.getMessage()});
            return false;
        }
    }

    @Override
    public String getBaseUrl() {
        StorageProperties.CosProperties cosProperties = this.getStoreProperties().getCos();
        String bucketName = this.getStoreProperties().getCos().getBucketName();
        if (bucketName.startsWith("https://")) {
            bucketName = bucketName.replaceAll("https://", "");
        } else if (bucketName.startsWith("http://")) {
            bucketName = bucketName.replaceAll("http://", "");
        }
        return "https://" + bucketName + ".cos." + cosProperties.getRegionId() + ".myqcloud.com/";
    }

    @Override
    public boolean delete(String filePath) {
        try {
            this.loadStorageClient().deleteObject(this.getStoreProperties().getCos().getBucketName(), filePath);
            return true;
        }
        catch (Exception e) {
            log.error(":::\u5f53\u524d\u7c7b\u578b[{}]\u5220\u9664\u6587\u4ef6{}\u5931\u8d25{}", new Object[]{this.type(), filePath, e.getMessage()});
            return false;
        }
    }

    @Override
    public boolean deleteFileBatch(List<String> remotePaths) {
        if (CollUtil.isEmpty(remotePaths)) {
            return false;
        }
        List keyList = remotePaths.stream().map(DeleteObjectsRequest.KeyVersion::new).collect(Collectors.toList());
        DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this.getStoreProperties().getCos().getBucketName());
        deleteObjectsRequest.setKeys(keyList);
        try {
            this.loadStorageClient().deleteObjects(deleteObjectsRequest);
        }
        catch (MultiObjectDeleteException e) {
            List deleteObjects = e.getDeletedObjects();
            List deleteErrors = e.getErrors();
            log.error(":::{}==>\u6587\u4ef6\u5220\u9664\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)deleteObjects), (Object)JSON.toJSONString((Object)deleteErrors));
        }
        catch (Exception e) {
            log.error(":::\u6587\u4ef6\u5220\u9664\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return false;
    }

    @Override
    public void downloadFileWithOutput(OutputStream outputStream, String filePath) {
        COSClient cosClient = this.loadStorageClient();
        StorageProperties.CosProperties cos = this.getStoreProperties().getCos();
        GetObjectRequest getObjectRequest = new GetObjectRequest(cos.getBucketName(), filePath);
        COSObject cosObject = cosClient.getObject(getObjectRequest);
        COSObjectInputStream cosObjectInput = cosObject.getObjectContent();
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)cosObjectInput);
            outputStream.write(bytes, 0, bytes.length);
            outputStream.flush();
        }
        catch (Exception e) {
            log.error(":::\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38"));
        }
        finally {
            if (null != cosObjectInput) {
                try {
                    cosObjectInput.close();
                }
                catch (IOException iOException) {}
            }
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public boolean supportSign() {
        return true;
    }

    @Override
    public JSONObject getPolicy(JSONObject policyParam, HttpServletResponse response) {
        JSONObject respMap = new JSONObject();
        StorageProperties.CosProperties cos = this.getStoreProperties().getCos();
        String key = policyParam.getString("dir") + policyParam.get((Object)"key");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dir", policyParam.getString("dir"));
        params.put("filename", policyParam.getString("key"));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("host", this.loadStorageClient().getClientConfig().getEndpointBuilder().buildGeneralApiEndpoint(cos.getBucketName()));
        HttpMethodName postType = (HttpMethodName)policyParam.getObject("postType", HttpMethodName.class);
        if (null == postType) {
            postType = HttpMethodName.PUT;
        }
        Date expirationDate = new Date(System.currentTimeMillis() + 1800000L);
        URL url = this.loadStorageClient().generatePresignedUrl(cos.getBucketName(), key, expirationDate, postType, headers, params);
        log.info(":::cos\u6587\u4ef6\u4e0a\u4f20\u7b7e\u540d\u6210\u529f:{}", (Object)url.toString());
        respMap.put("signature", (Object)url.toString());
        return respMap;
    }

    @Override
    public String loadDownloadSafePath(StorageFileInfo fileInfo) {
        COSClient cosClient = this.loadStorageClient();
        StorageProperties.CosProperties cos = this.getStoreProperties().getCos();
        GeneratePresignedUrlRequest req = new GeneratePresignedUrlRequest(cos.getBucketName(), fileInfo.getPath(), HttpMethodName.GET);
        ResponseHeaderOverrides responseHeaders = new ResponseHeaderOverrides();
        String responseContentLanguage = "zh-CN";
        String responseContentDispositon = "filename=" + fileInfo.getFilename() + "";
        String responseCacheControl = "no-cache";
        String cacheExpireStr = DateUtils.formatRFC822Date((Date)new Date(System.currentTimeMillis() + 86400000L));
        responseHeaders.setContentLanguage(responseContentLanguage);
        responseHeaders.setContentDisposition(responseContentDispositon);
        responseHeaders.setCacheControl(responseCacheControl);
        responseHeaders.setExpires(cacheExpireStr);
        req.setResponseHeaders(responseHeaders);
        Date expirationDate = new Date(System.currentTimeMillis() + 1800000L);
        req.setExpiration(expirationDate);
        req.addRequestParameter("filename", fileInfo.getFilename());
        req.putCustomRequestHeader("Host", cosClient.getClientConfig().getEndpointBuilder().buildGeneralApiEndpoint(cos.getBucketName()));
        URL url = cosClient.generatePresignedUrl(req);
        return url.toString();
    }
}

