/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.els.modules.system.entity.CommentModel;
import com.els.modules.system.util.EqualsUtil;
import com.els.modules.system.util.POIExcelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class CommentWriteHandler
implements RowWriteHandler {
    private List<String> sheetNameList;
    List<CommentModel> commentList = new ArrayList<CommentModel>();
    private String extension;

    public CommentWriteHandler(List<CommentModel> commentList, String extension) {
        if (CollUtil.isEmpty(commentList)) {
            return;
        }
        if (!StrUtil.equals((CharSequence)extension, (CharSequence)"xlsx") && !StrUtil.equals((CharSequence)extension, (CharSequence)"xls")) {
            extension = "xlsx";
        }
        this.commentList = commentList.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getSheetName()) && x.getColIndex() >= 0 && x.getRowIndex() >= 0 && StrUtil.isNotBlank((CharSequence)x.getCommentContent())).collect(Collectors.toList());
        this.sheetNameList = this.commentList.stream().map(x -> x.getSheetName()).distinct().collect(Collectors.toList());
        this.extension = extension;
    }

    public void afterRowDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Integer relativeRowIndex, Boolean isHead) {
        Sheet sheet = writeSheetHolder.getSheet();
        if (CollUtil.isEmpty(this.commentList) || !this.sheetNameList.contains(sheet.getSheetName())) {
            return;
        }
        List rowCommentList = this.commentList.stream().filter(x -> StrUtil.equals((CharSequence)x.getSheetName(), (CharSequence)sheet.getSheetName()) && EqualsUtil.equals(relativeRowIndex, x.getRowIndex())).collect(Collectors.toList());
        if (CollUtil.isEmpty(rowCommentList)) {
            return;
        }
        List colIndexList = rowCommentList.stream().map(x -> x.getColIndex()).distinct().collect(Collectors.toList());
        for (Integer colIndex : colIndexList) {
            List cellCommentList = rowCommentList.stream().filter(x -> EqualsUtil.equals(colIndex, x.getColIndex())).collect(Collectors.toList());
            if (CollUtil.isEmpty(cellCommentList)) continue;
            String commentContent = cellCommentList.stream().map(x -> x.getCommentContent()).collect(Collectors.joining());
            Cell cell = row.getCell(colIndex.intValue());
            POIExcelUtil.addComment(cell, commentContent, this.extension);
        }
        this.commentList.remove(rowCommentList);
        this.sheetNameList = this.commentList.stream().map(x -> x.getSheetName()).distinct().collect(Collectors.toList());
    }

    public void beforeRowCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Integer integer, Integer integer1, Boolean aBoolean) {
    }

    public void afterRowCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Integer integer, Boolean aBoolean) {
    }
}

