/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.els.common.constant.CommonConstant;
import com.els.modules.system.entity.CommentModel;
import com.els.modules.system.entity.ExcelDetail;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ExcelHeaderUtil {
    public static List<List<String>> getHeaderList(List<ExcelDetail> detailList) {
        ArrayList<List<String>> list = new ArrayList<List<String>>(16);
        for (ExcelDetail detail : detailList) {
            ArrayList<String> head = new ArrayList<String>(16);
            head.add(detail.getColumnCode());
            if (CommonConstant.STATUS_YES.equals(detail.getRequired())) {
                head.add(detail.getColumnName() + "<\u5fc5\u586b>");
            } else {
                head.add(detail.getColumnName() + "<\u975e\u5fc5\u586b>");
            }
            list.add(head);
        }
        return list;
    }

    public static List<List<String>> getApplyHeaderList(List<ExcelDetail> detailList) {
        ArrayList<List<String>> list = new ArrayList<List<String>>(16);
        for (ExcelDetail detail : detailList) {
            ArrayList<String> head = new ArrayList<String>(16);
            head.add(detail.getColumnCode());
            if (CommonConstant.STATUS_YES.equals(detail.getRequired()) || "cateName".equals(detail.getColumnCode())) {
                head.add(detail.getColumnName() + "<\u5fc5\u586b>");
            } else {
                head.add(detail.getColumnName() + "<\u975e\u5fc5\u586b>");
            }
            list.add(head);
        }
        return list;
    }

    public static List<List<String>> getHeaderNameList(List<ExcelDetail> detailList) {
        ArrayList<List<String>> list = new ArrayList<List<String>>(16);
        for (ExcelDetail detail : detailList) {
            ArrayList<String> head = new ArrayList<String>(16);
            head.add(detail.getColumnCode());
            head.add(detail.getColumnName());
            list.add(head);
        }
        return list;
    }

    public static List<CommentModel> getCommentList(List<ExcelDetail> detailList, String sheetName) {
        ArrayList<CommentModel> commentList = new ArrayList<CommentModel>();
        for (int i = 0; i < detailList.size(); ++i) {
            if (StringUtils.isNotBlank((CharSequence)detailList.get(i).getExample())) {
                commentList.add(CommentModel.createCommentModel(sheetName, 1, i, detailList.get(i).getExample()));
                continue;
            }
            commentList.add(CommentModel.createCommentModel(sheetName, 1, i, "\u672a\u8bbe\u7f6e\u793a\u4f8b"));
        }
        return commentList;
    }
}

