/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.entity.SaleAttachment;
import com.els.modules.attachment.service.SaleAttachmentService;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.attachment.vo.AttachmentSendVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"\u9500\u552e\u9644\u4ef6"})
@RestController
@RequestMapping(value={"/attachment/saleAttachment"})
public class SaleAttachmentController
extends BaseController<SaleAttachment, SaleAttachmentService> {
    private static final Logger log = LoggerFactory.getLogger(SaleAttachmentController.class);
    @Autowired
    private SaleAttachmentService attachmentSaleService;
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SaleAttachment attachmentSale, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)attachmentSale), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.attachmentSaleService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u4e0a\u4f20", operateType=2)
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6", notes="\u4e0a\u4f20\u6587\u4ef6")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public Result<?> upload(HttpServletRequest request) {
        String businessType = request.getParameter("businessType");
        String headId = request.getParameter("headId");
        String itemNumber = request.getParameter("itemNumber");
        String fileType = request.getParameter("fileType");
        String materialNumber = request.getParameter("materialNumber");
        if (StrUtil.isBlank((CharSequence)businessType)) {
            return Result.error((String)"\u7f3a\u5c11\u4e1a\u52a1\u7c7b\u578b");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        try {
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile uploadFile = (MultipartFile)entity.getValue();
                String documentName = uploadFile.getOriginalFilename();
                StorageFileInfo fileInfo = this.fileStoreSignServiceImpl.storeFile(uploadFile, null, null);
                SaleAttachment attachment = new SaleAttachment();
                attachment.setBusinessType(businessType);
                attachment.setHeadId(headId);
                attachment.setItemNumber(itemNumber);
                attachment.setFileType(fileType);
                attachment.setUploadSubAccount(this.getCurrentUser().getSubAccount());
                attachment.setUploadElsAccount(TenantContext.getTenant());
                attachment.setFileName(documentName);
                attachment.setFileSize(String.valueOf(uploadFile.getSize()));
                attachment.setFilePath(fileInfo.getPath());
                attachment.setSaveType(fileInfo.getSaveType());
                attachment.setSendStatus("0");
                attachment.setReceiveStatus("0");
                attachment.setUploadTime(new Date());
                attachment.setMaterialNumber(materialNumber);
                boolean result = this.attachmentSaleService.save((Object)attachment);
                if (!result) continue;
                attachment.setAbsoluteFilePath(this.fileStoreSignServiceImpl.getDownloadPath(attachment.getFilePath(), attachment.getSaveType()));
                return Result.ok((Object)((Object)attachment));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return Result.error((String)"\u4e0a\u4f20\u5931\u8d25");
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u8bb0\u5f55", operateType=2)
    @ApiOperation(value="\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u8bb0\u5f55", notes="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/uploadLog"})
    public Result<?> uploadLog(@RequestBody List<SaleAttachment> attachmentList) {
        for (SaleAttachment attachment : attachmentList) {
            attachment.setUploadSubAccount(this.getCurrentUser().getSubAccount());
            attachment.setUploadElsAccount(TenantContext.getTenant());
            attachment.setSendStatus("0");
            attachment.setReceiveStatus("0");
            attachment.setUploadTime(new Date());
            attachment.setSourceType("1");
        }
        this.attachmentSaleService.saveBatch(attachmentList);
        return Result.ok(attachmentList);
    }

    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u4e0b\u8f7d", operateType=1)
    @GetMapping(value={"/download"})
    public void download(@RequestParam(name="id") String id, HttpServletResponse response) {
        SaleAttachment attachment = (SaleAttachment)((Object)this.attachmentSaleService.getById((Serializable)((Object)id)));
        try {
            this.fileStoreSignServiceImpl.downloadFileWithOutput((OutputStream)response.getOutputStream(), attachment.getFilePath(), attachment.getSaveType());
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
    }

    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u5220\u9664", operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        SaleAttachment attachment = (SaleAttachment)((Object)this.attachmentSaleService.getById((Serializable)((Object)id)));
        String elsAccount = this.getTenantId();
        Assert.isTrue((boolean)elsAccount.equals(attachment.getUploadElsAccount()), (String)I18nUtil.translate((String)"", (String)"\u975e\u672c\u65b9\u4e0a\u4f20\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664"));
        Assert.isTrue((boolean)"0".equals(attachment.getSendStatus()), (String)I18nUtil.translate((String)"", (String)"\u5df2\u53d1\u9001\u7684\u6587\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664"));
        this.fileStoreSignServiceImpl.delete(attachment.getFilePath(), attachment.getSaveType());
        this.attachmentSaleService.delAttachmentSale(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u6279\u91cf\u5220\u9664", operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List saleAttachmentList;
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList<String> filePaths = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(idList) && CollectionUtil.isNotEmpty((Collection)(saleAttachmentList = this.attachmentSaleService.listByIds(idList)))) {
            for (SaleAttachment saleAttachment : saleAttachmentList) {
                filePaths.add(saleAttachment.getFilePath());
            }
        }
        this.fileStoreSignServiceImpl.deleteFileBatch(filePaths, null);
        this.attachmentSaleService.delBatchAttachmentSale(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleAttachment attachmentSale = (SaleAttachment)((Object)this.attachmentSaleService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)attachmentSale));
    }

    @AutoLog(value="\u9500\u552e\u9644\u4ef6-\u9644\u4ef6\u53d1\u9001", operateType=3)
    @ApiOperation(value="\u9644\u4ef6\u53d1\u9001", notes="\u9644\u4ef6\u53d1\u9001")
    @PostMapping(value={"/send"})
    public Result<?> send(@RequestBody AttachmentSendVO sendVO) {
        this.attachmentSaleService.sendFile(sendVO);
        return this.commonSuccessResult(4);
    }
}

