/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.language.init;

import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.language.entity.I18n;
import com.els.modules.language.service.I18nService;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class I18nInit
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(I18nInit.class);
    private static String I18_CACHE_KEY = "srm:i18:cache";
    private static String I18_CACHE_FALG_KEY = "srm:i18:flag:cache";

    public void afterPropertiesSet() throws Exception {
        RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        redisUtil.set(I18_CACHE_FALG_KEY, null, 86400L);
        long startTime = System.currentTimeMillis();
        I18nService i18nService = (I18nService)SpringContextUtils.getBean(I18nService.class);
        List<I18n> list = i18nService.initI18Key();
        List listList = Lists.partition(list, (int)1000);
        for (List dtoList : listList) {
            HashMap<String, String> keys = new HashMap<String, String>();
            for (I18n dto : dtoList) {
                String key = I18_CACHE_KEY + ":" + dto.getElsAccount() + ":" + dto.getI18nKey() + ":" + dto.getLanguage();
                keys.put(key, dto.getI18nValue());
            }
            if (keys.size() <= 0) continue;
            redisUtil.executePipelined(keys);
        }
        long endTime = System.currentTimeMillis();
        log.info("\u56fd\u9645\u5316\u7f13\u5b58\u521d\u59cb\u5316\u8017\u65f6:{}\u79d2", (Object)((endTime - startTime) / 1000L));
    }
}

