/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.modules.system.entity.ElsSystemBusinessRule;
import com.els.modules.system.service.ElsSystemBusinessRuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"\u7cfb\u7edf\u53c2\u6570\u8bbe\u7f6e"})
@RestController
@RequestMapping(value={"/base/businessRule"})
public class ElsSystemBusinessRuleController
extends BaseController<ElsSystemBusinessRule, ElsSystemBusinessRuleService> {
    @Autowired
    private ElsSystemBusinessRuleService elsSystemBusinessRuleService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsSystemBusinessRule elsSystemBusinessRule, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsSystemBusinessRule), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsSystemBusinessRuleService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u7cfb\u7edf\u4e1a\u52a1\u89c4\u5219\u8bbe\u7f6e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsSystemBusinessRule elsSystemBusinessRule) {
        this.elsSystemBusinessRuleService.saveElsSystemBusinessRule(elsSystemBusinessRule);
        return Result.ok((Object)((Object)elsSystemBusinessRule));
    }

    @AutoLog(value="\u7cfb\u7edf\u4e1a\u52a1\u89c4\u5219\u8bbe\u7f6e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsSystemBusinessRule elsSystemBusinessRule) {
        this.elsSystemBusinessRuleService.updateElsSystemBusinessRule(elsSystemBusinessRule);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7cfb\u7edf\u4e1a\u52a1\u89c4\u5219\u8bbe\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.elsSystemBusinessRuleService.delElsSystemBusinessRule(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ElsSystemBusinessRule elsSystemBusinessRule = (ElsSystemBusinessRule)((Object)this.elsSystemBusinessRuleService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)elsSystemBusinessRule));
    }

    @GetMapping(value={"/exportJson"})
    public Result<?> exportJson(ElsSystemBusinessRule elsSystemBusinessRule, HttpServletRequest req, HttpServletResponse res) throws Exception {
        this.elsSystemBusinessRuleService.exportJson(elsSystemBusinessRule, req, res);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_uGLR_2b10408d", (String)"\u5bfc\u51fa\u6210\u529f"));
    }

    @PostMapping(value={"/importJson"})
    public Result<?> importJson(HttpServletRequest req, HttpServletResponse res) {
        try {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)req;
            Map fileMap = multipartRequest.getFileMap();
            MultipartFile file = (MultipartFile)fileMap.get("file");
            InputStream inputStream = file.getInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream, "utf-8");
            int ch = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((ch = ((Reader)reader).read()) != -1) {
                stringBuffer.append((char)ch);
            }
            ((Reader)reader).close();
            int length = stringBuffer.length();
            if (length == 0) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!"));
            }
            String jsonString = stringBuffer.toString();
            List businessRuleList = JSON.parseArray((String)jsonString, ElsSystemBusinessRule.class);
            if (businessRuleList.isEmpty()) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!"));
            }
            if (StringUtils.isEmpty((CharSequence)((ElsSystemBusinessRule)((Object)businessRuleList.get(0))).getBusinessType()) || StringUtils.isEmpty((CharSequence)((ElsSystemBusinessRule)((Object)businessRuleList.get(0))).getItemCode()) || StringUtils.isEmpty((CharSequence)((ElsSystemBusinessRule)((Object)businessRuleList.get(0))).getItemName())) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_jsonStructure_error", (String)"\u5bfc\u5165\u6570\u636e\u7ed3\u6784\u6709\u8bef\uff01"));
            }
            this.elsSystemBusinessRuleService.importJson(businessRuleList);
        }
        catch (Exception e) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_importJson_errorText", (String)"\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\u6216\u8005\u6587\u4ef6\u7684json\u6570\u636e\u538b\u7f29\u6709\u8bef\uff0cjson\u8f6c\u4e49\u5931\u8d25!"));
        }
        return Result.ok();
    }
}

