/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.storage.spi.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.enumerate.FileStorageTypeEnum;
import com.els.modules.attachment.storage.spi.AbstractStorageSpi;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service(value="localStorageSpi")
public class LocalStorageClient
extends AbstractStorageSpi {
    private static final Logger log = LoggerFactory.getLogger(LocalStorageClient.class);
    private static final String NGINX_PATH = "/opt/upFiles/";
    private static Path rootLocation;
    private static final String UPLOAD_PATH;
    private static final String SERVICE_ADDRESS;

    @Override
    public Object loadStorageClient() {
        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APQIMGCKxTPqDO_d3760f73", (String)"\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u6a21\u5f0f\u4e0d\u9700\u8981\u5ba2\u6237\u7aef"));
    }

    @Override
    public String type() {
        return FileStorageTypeEnum.LOCAL.getCode();
    }

    @Override
    public String loadDownloadPath(String objectPath) {
        String url = SERVICE_ADDRESS + NGINX_PATH + objectPath;
        return url.replace("\\", "/");
    }

    @Override
    public boolean store(StorageFileInfo fileInfo) {
        try {
            Path resolve = rootLocation.resolve(UPLOAD_PATH + fileInfo.getPath());
            File file = new File(resolve.getParent().toUri());
            if (!file.exists()) {
                file.mkdirs();
            }
            Files.copy(fileInfo.getInputStream(), resolve, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            log.error(":::\u5f53\u524d\u7c7b\u578b[{}]\u5b58\u50a8\u6587\u4ef6\u5931\u8d25:{}", (Object)this.type(), (Object)e);
            return false;
        }
    }

    public Path load(String filePath) {
        return rootLocation.resolve(UPLOAD_PATH + filePath);
    }

    @Override
    public boolean delete(String filePath) {
        Path file = this.load(filePath);
        try {
            Files.deleteIfExists(file);
            return true;
        }
        catch (IOException e) {
            log.error(":::\u5f53\u524d\u7c7b\u578b[{}]\u5220\u9664\u6587\u4ef6{}\u5931\u8d25{}", new Object[]{this.type(), filePath, e.getMessage()});
            return false;
        }
    }

    @Override
    public boolean deleteFileBatch(List<String> remotePaths) {
        remotePaths.forEach(this::delete);
        return false;
    }

    @Override
    public String getBaseUrl() {
        return SERVICE_ADDRESS + NGINX_PATH;
    }

    @Override
    public JSONObject getPolicy(JSONObject policyParam, HttpServletResponse response) {
        return null;
    }

    static {
        UPLOAD_PATH = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.path.upload");
        SERVICE_ADDRESS = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.config.service.address");
        try {
            rootLocation = Paths.get(UPLOAD_PATH, new String[0]);
            if (!Files.exists(rootLocation, new LinkOption[0])) {
                Files.createDirectories(rootLocation, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            log.error(":::\u7cfb\u7edf\u4e0d\u5b58\u5728\u672c\u5730\u6587\u4ef6\u6839\u76ee\u5f55:{}", (Object)UPLOAD_PATH);
        }
    }
}

