/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.controller;

import com.els.common.api.vo.Result;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public enum FileTypeEnum {
    JPEG("JPG", "FFD8FFE0"),
    JPEG1("JPEG", "FFD8FFE0"),
    PNG("PNG", "89504E47"),
    GIF("GIF", "47494638"),
    TIFF("TIF", "49492A00"),
    BMP("BMP", "424D"),
    BMP_16("BMP", "424D228C010000000000"),
    BMP_24("BMP", "424D8240090000000000"),
    BMP_256("BMP", "424D8E1B030000000000"),
    DWG("DWG", "41433130"),
    PSD("PSD", "38425053"),
    RTF("RTF", "7B5C727466"),
    XML("XML", "3C3F786D6C"),
    HTML("HTML", "68746D6C3E"),
    EML("EML", "44656C69766572792D646174653A"),
    DBX("DBX", "CFAD12FEC5FD746F "),
    PST("", "2142444E"),
    OLE2("OLE2", "0xD0CF11E0A1B11AE1"),
    XLS("XLS", "D0CF11E0"),
    DOC("DOC", "D0CF11E0"),
    DOCX("DOCX", "504B0304"),
    XLSX("XLSX", "504B0304"),
    MDB("MDB", "5374616E64617264204A"),
    WPB("WPB", "FF575043"),
    EPS("EPS", "252150532D41646F6265"),
    PS("PS", "252150532D41646F6265"),
    PDF("PDF", "255044462D312E"),
    QDF("qdf", "AC9EBD8F"),
    QDB("qbb", "458600000600"),
    PWL("PWL", "E3828596"),
    ZIP("", "504B0304"),
    RAR("", "52617221"),
    WAV("WAV", "57415645"),
    AVI("AVI", "41564920"),
    RAM("RAM", "2E7261FD"),
    RM("RM", "2E524D46"),
    RMVB("RMVB", "2E524D46000000120001"),
    MPG("MPG", "000001BA"),
    MOV("MOV", "6D6F6F76"),
    ASF("ASF", "3026B2758E66CF11"),
    ARJ("ARJ", "60EA"),
    MID("MID", "4D546864"),
    MP4("MP4", "00000020667479706D70"),
    MP3("MP3", "49443303000000002176"),
    FLV("FLV", "464C5601050000000900"),
    GZ("GZ", "1F8B08"),
    CSS("CSS", "48544D4C207B0D0A0942"),
    JS("JS", "696B2E71623D696B2E71"),
    VSD("VSD", "d0cf11e0a1b11ae10000"),
    WPS("WPS", "d0cf11e0a1b11ae10000"),
    TORRENT("TORRENT", "6431303A637265617465"),
    JSP("JSP", "3C2540207061676520"),
    JAVA("JAVA", "7061636B61676520"),
    CLASS("CLASS", "CAFEBABE0000002E00"),
    JAR("JAR", "504B03040A000000"),
    MF("MF", "4D616E69666573742D56"),
    EXE("EXE", "4D5A9000030000000400"),
    ELF("ELF", "7F454C4601010100"),
    WK1("WK1", "2000604060"),
    WK3("WK3", "00001A0000100400"),
    WK4("WK4", "00001A0002100400"),
    LWP("LWP", "576F726450726F"),
    SLY("SLY", "53520100"),
    NOT_EXITS_ENUM("", "");

    private static final List<String> specialFileSuffixs;
    private String fileTypeName;
    private String magicNumberCode;

    private FileTypeEnum(String fileTypeName, String magicNumberCode) {
        this.fileTypeName = fileTypeName;
        this.magicNumberCode = magicNumberCode;
    }

    public String getFileTypeName() {
        return this.fileTypeName;
    }

    public String getMagicNumberCode() {
        return this.magicNumberCode;
    }

    public static Result<Object> validatorFile(MultipartFile uploadFile) {
        String typeSuffix = uploadFile.getOriginalFilename().substring(uploadFile.getOriginalFilename().lastIndexOf(".") + 1);
        for (String specialSuffix : specialFileSuffixs) {
            if (!uploadFile.getOriginalFilename().contains(specialSuffix)) continue;
            return Result.error((String)"\u6587\u4ef6\u5305\u542b\u7279\u6b8a\u6587\u4ef6\uff0ceg.exe\u3001sh\u3001bat\u3001dll\u3001jsp");
        }
        String fielHeadType = FileTypeEnum.getfileheader(uploadFile);
        if (StringUtils.hasText((String)fielHeadType)) {
            FileTypeEnum typeEnum = FileTypeEnum.getByMagicNumberCode(typeSuffix.toUpperCase());
            if (typeEnum != null) {
                if (!typeEnum.getMagicNumberCode().startsWith(fielHeadType.toUpperCase())) {
                    return Result.error((String)("\u6587\u4ef6\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42! " + fielHeadType + " " + typeSuffix.toUpperCase()));
                }
                return null;
            }
            return Result.error((String)("\u6587\u4ef6\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42!!! " + fielHeadType + " " + typeSuffix.toUpperCase()));
        }
        return Result.error((String)("\u6587\u4ef6\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42!!!! " + fielHeadType + " " + typeSuffix.toUpperCase()));
    }

    public static FileTypeEnum getByMagicNumberCode(String magicNumberName) {
        if (StringUtils.hasText((String)magicNumberName)) {
            for (FileTypeEnum type : FileTypeEnum.values()) {
                if (!type.getFileTypeName().equals(magicNumberName.toUpperCase())) continue;
                return type;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getfileheader(MultipartFile file) {
        InputStream is = null;
        String value = null;
        try {
            is = file.getInputStream();
            byte[] b = new byte[4];
            is.read(b, 0, b.length);
            value = FileTypeEnum.bytestohexstring(b);
        }
        catch (Exception exception) {
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return value;
    }

    private static String bytestohexstring(byte[] src) {
        StringBuilder builder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            String hv = Integer.toHexString(src[i] & 0xFF).toUpperCase();
            if (hv.length() < 2) {
                builder.append(0);
            }
            builder.append(hv);
        }
        return builder.toString();
    }

    static {
        specialFileSuffixs = Lists.newArrayList((Object[])new String[]{".exe", ".sh", ".bat", ".dll", ".jsp"});
    }
}

