/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.storage.config;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.els.modules.attachment.storage.config.StorageProperties;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.region.Region;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class StoreAutoConfig {
    @Autowired
    private StorageProperties storeProperties;

    @Bean
    public OSSClient defaultOssClient() {
        ClientConfiguration configuration = new ClientConfiguration();
        configuration.setMaxErrorRetry(this.storeProperties.getOss().getMaxErrorRetry().intValue());
        configuration.setConnectionTimeout(this.storeProperties.getOss().getConnectionTimeout().intValue());
        configuration.setMaxErrorRetry(this.storeProperties.getOss().getMaxErrorRetry().intValue());
        configuration.setSocketTimeout(this.storeProperties.getOss().getSocketTimeout().intValue());
        configuration.setMaxConnections(this.storeProperties.getOss().getMaxConnections().intValue());
        DefaultCredentialProvider credentialsProvider = new DefaultCredentialProvider(this.storeProperties.getOss().getAccessKeyId(), this.storeProperties.getOss().getAccessKeySecret());
        return new OSSClient(this.storeProperties.getOss().getEndpointNet(), (CredentialsProvider)credentialsProvider, configuration);
    }

    @Bean
    @ConditionalOnProperty(prefix="els.storage", name={"type"}, havingValue="cos", matchIfMissing=false)
    public COSClient defaultCosClient() {
        BasicCOSCredentials cred = new BasicCOSCredentials(this.storeProperties.getCos().getSecretId(), this.storeProperties.getCos().getSecretKey());
        ClientConfig clientConfig = new ClientConfig(new Region(this.storeProperties.getCos().getRegionId()));
        return new COSClient((COSCredentials)cred, clientConfig);
    }
}

