/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FieldDescribe;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.enumerate.ElsBarcodeBusinessEnum;
import com.els.modules.barcode.api.ElsTableRpcService;
import com.els.modules.barcode.entity.ElsBarcodeAttribute;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.rpc.service.ElsTableSelectService;
import com.els.modules.barcode.service.ElsBarcodeAttributeService;
import com.els.modules.barcode.vo.ElsBarcodeAttributeVO;
import com.els.modules.barcode.vo.ElsBarcodeFiledVO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6761\u7801\u5c5e\u6027\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/base/barcode/elsBarcodeAttribute"})
public class ElsBarcodeAttributeController
extends BaseController<ElsBarcodeAttribute, ElsBarcodeAttributeService> {
    private static final Logger log = LoggerFactory.getLogger(ElsBarcodeAttributeController.class);
    @Autowired
    private ElsBarcodeAttributeService elsBarcodeAttributeService;
    @Autowired
    private ElsTableSelectService elsTableSelectService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @RequiresPermissions(value={"barcode#elsBarcodeAttribute:list"})
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsBarcodeAttribute elsBarcodeAttribute, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarcodeAttribute), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsBarcodeAttributeService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    public Result<?> queryTabsCount(ElsBarcodeAttribute elsBarcodeAttribute, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarcodeAttribute), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"attribute_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"attribute_status");
        List list = ((ElsBarcodeAttributeService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(ElsBarcodeAttribute::getAttributeStatus, ElsBarcodeAttribute::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "attributeStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("sampleCheckProjectStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "attributeStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u542f\u52a8)", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u542f\u52a8)")
    @RequiresPermissions(value={"barcode#elsBarcodeAttribute:enableList"})
    @GetMapping(value={"/enableList"})
    public Result<?> queryPageEnableList(ElsBarcodeAttribute elsBarcodeAttribute, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarcodeAttribute), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"attribute_status", (Object)SrmEnabledStatusEnum.ENABLED);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsBarcodeAttributeService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u72b6\u6001\u53d8\u66f4")
    @ApiOperation(value="\u72b6\u6001\u53d8\u66f4", notes="\u72b6\u6001\u53d8\u66f4")
    @RequiresPermissions(value={"barcode#elsBarcodeAttribute:changeStatus"})
    @PostMapping(value={"/changeStatus"})
    public Result<?> changeStatus(@RequestBody ElsBarcodeAttributeVO elsBarcodeAttributeVO) {
        if ("1".equals(elsBarcodeAttributeVO.getStatusType())) {
            elsBarcodeAttributeVO.setAttributeStatus(SrmEnabledStatusEnum.ENABLED.getValue());
        } else if ("2".equals(elsBarcodeAttributeVO.getStatusType())) {
            elsBarcodeAttributeVO.setAttributeStatus(SrmEnabledStatusEnum.DISABLED.getValue());
        }
        ElsBarcodeAttribute elsBarcodeAttribute = new ElsBarcodeAttribute();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeAttributeVO), (Object)((Object)elsBarcodeAttribute));
        this.elsBarcodeAttributeService.updateById((Object)elsBarcodeAttribute);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6761\u7801\u5c5e\u6027\u914d\u7f6e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @RequiresPermissions(value={"barcode#elsBarcodeAttribute:add"})
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsBarcodeAttribute elsBarcodeAttribute) {
        this.elsBarcodeAttributeService.saveElsBarcodeAttribute(elsBarcodeAttribute);
        return Result.ok((Object)((Object)elsBarcodeAttribute));
    }

    @AutoLog(value="\u6761\u7801\u5c5e\u6027\u914d\u7f6e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @RequiresPermissions(value={"barcode#elsBarcodeAttribute:edit"})
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsBarcodeAttribute elsBarcodeAttribute) {
        this.elsBarcodeAttributeService.updateElsBarcodeAttribute(elsBarcodeAttribute);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6761\u7801\u5c5e\u6027\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @RequiresPermissions(value={"barcode#elsBarcodeAttribute:delete"})
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsBarcodeAttributeService.delElsBarcodeAttribute(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6761\u7801\u5c5e\u6027\u914d\u7f6e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @RequiresPermissions(value={"barcode#elsBarcodeAttribute:deleteBatch"})
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.elsBarcodeAttributeService.delBatchElsBarcodeAttribute(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @RequiresPermissions(value={"barcode#elsBarcodeAttribute:queryById"})
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ElsBarcodeAttribute elsBarcodeAttribute = (ElsBarcodeAttribute)((Object)this.elsBarcodeAttributeService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)elsBarcodeAttribute));
    }

    @ApiOperation(value="\u8868\u5b57\u6bb5\u5217\u8868\u67e5\u8be2", notes="\u8868\u5b57\u6bb5\u5217\u8868\u67e5\u8be2")
    @RequiresPermissions(value={"barcode#elsBarcodeAttribute:queryPageFieldList"})
    @GetMapping(value={"/queryPageFieldList"})
    public Result<?> queryPageFieldList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        try {
            Field[] fields;
            String keyWord = req.getParameter("keyWord");
            String roleType = req.getParameter("roleType");
            ArrayList<ElsBarcodeFiledVO> filedList = new ArrayList<ElsBarcodeFiledVO>();
            String businessType = req.getParameter("businessType");
            String classPath = null;
            classPath = "sale".equals(roleType) ? (StringUtils.isBlank((CharSequence)ElsBarcodeBusinessEnum.getSalePathByValue((String)businessType)) ? ElsBarcodeBusinessEnum.getPathByValue((String)businessType) : ElsBarcodeBusinessEnum.getSalePathByValue((String)businessType)) : ElsBarcodeBusinessEnum.getPathByValue((String)businessType);
            if (StringUtils.isBlank((CharSequence)classPath)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_APEStFmhxuERdW_59629763", (String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u67e5\u8be2\u4e0d\u5230\u914d\u7f6e\u9879\uff01"));
            }
            Class<?> clazz = Class.forName(classPath);
            for (Field filed : fields = clazz.getDeclaredFields()) {
                boolean annotation;
                if (!filed.isAccessible()) {
                    filed.setAccessible(true);
                }
                if (!(annotation = filed.isAnnotationPresent(FieldDescribe.class))) continue;
                FieldDescribe methodAnno = filed.getAnnotation(FieldDescribe.class);
                ElsBarcodeFiledVO obj = new ElsBarcodeFiledVO();
                obj.setFiledName(methodAnno.name());
                obj.setFiled(filed.getName());
                obj.setFiledType(filed.getType().getName());
                if (StringUtils.isNotBlank((CharSequence)keyWord) && !methodAnno.name().contains(keyWord) && !filed.getName().contains(keyWord)) continue;
                filedList.add(obj);
            }
            Page filePage = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
            filePage.setRecords(filedList);
            return Result.ok((Object)filePage);
        }
        catch (ClassNotFoundException e) {
            log.error("queryPageFieldList_failed:", (Throwable)e);
            return Result.ok(null);
        }
    }

    @ApiOperation(value="\u8868\u5b57\u6bb5\u503c\u5217\u8868\u67e5\u8be2", notes="\u8868\u5b57\u6bb5\u5217\u8868\u67e5\u8be2")
    @RequiresPermissions(value={"barcode#elsBarcodeAttribute:queryPageFieldValueList"})
    @GetMapping(value={"/queryPageFieldValueList"})
    public Result<?> queryPageFieldValueList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        try {
            ArrayList filedList = new ArrayList();
            String businessType = req.getParameter("businessType");
            String documentType = req.getParameter("documentQueryType");
            String businessField = req.getParameter("businessField");
            if (StringUtils.isBlank((CharSequence)businessType)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_EStFxOLV_fe2610d0", (String)"\u4e1a\u52a1\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (StringUtils.isBlank((CharSequence)businessField)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_ESJOxOLV_1cf946d5", (String)"\u4e1a\u52a1\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            String serviceName = ElsBarcodeBusinessEnum.getPathByService((String)businessType);
            if (StringUtils.isBlank((CharSequence)serviceName)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_APEStFmhxuERdW_59629763", (String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u67e5\u8be2\u4e0d\u5230\u914d\u7f6e\u9879\uff01"));
            }
            ElsTableRpcService elsTableRpcService = this.elsTableSelectService.getTableService(serviceName);
            IPage list = elsTableRpcService.selectListByBusinessType(businessType, businessField, pageNo, pageSize, documentType, req.getParameterMap());
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error("queryPageFieldValueList_failed:", (Object)e.getMessage());
            return Result.ok(null);
        }
    }

    @ApiOperation(value="\u8868\u5b57\u6bb5\u503c\u5217\u8868\u67e5\u8be2", notes="\u8868\u5b57\u6bb5\u5217\u8868\u67e5\u8be2")
    @RequiresPermissions(value={"barcode#elsBarcodeAttribute:getPageFieldString"})
    @GetMapping(value={"/getPageFieldString"})
    public Result<?> getPageFieldString(HttpServletRequest req) {
        try {
            String businessType = req.getParameter("businessType");
            String documentType = req.getParameter("documentQueryType");
            String businessField = req.getParameter("businessField");
            if (StringUtils.isBlank((CharSequence)businessType)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_EStFxOLV_fe2610d0", (String)"\u4e1a\u52a1\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (StringUtils.isBlank((CharSequence)businessField)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_ESJOxOLV_1cf946d5", (String)"\u4e1a\u52a1\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            String serviceName = ElsBarcodeBusinessEnum.getPathByService((String)businessType);
            if (StringUtils.isBlank((CharSequence)serviceName)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_APEStFmhxuERdW_59629763", (String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u67e5\u8be2\u4e0d\u5230\u914d\u7f6e\u9879\uff01"));
            }
            ElsTableRpcService elsTableRpcService = this.elsTableSelectService.getTableService(serviceName);
            IPage list = elsTableRpcService.selectListByBusinessType(businessType, businessField, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE), documentType, req.getParameterMap());
            String result = null;
            if (ObjectUtil.isNotEmpty((Object)list) && CollUtil.isNotEmpty((Collection)list.getRecords())) {
                result = list.getRecords().stream().map(x -> x.getFieldValue()).collect(Collectors.joining(","));
            }
            return Result.ok(result);
        }
        catch (Exception e) {
            log.error("queryPageFieldValueList_failed:", (Object)e.getMessage());
            return Result.ok(null);
        }
    }
}

