/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.controller;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.BarcodeConstant;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.modules.barcode.entity.BarcodeTemplateSupplierList;
import com.els.modules.barcode.entity.PurchaseBarcodeTemplateHead;
import com.els.modules.barcode.entity.PurchaseBarcodeTemplateItem;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.service.BarcodeTemplateSupplierListService;
import com.els.modules.barcode.service.PurchaseBarcodeTemplateHeadService;
import com.els.modules.barcode.service.PurchaseBarcodeTemplateItemService;
import com.els.modules.barcode.vo.PurchaseBarcodeTemplateHeadVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/barcode/purchaseBarcodeTemplateHead"})
@Api(tags={"\u91c7\u8d2d\u6761\u7801\u6a21\u677f\u5934\u8868"})
public class PurchaseBarcodeTemplateHeadController
extends BaseController<PurchaseBarcodeTemplateHead, PurchaseBarcodeTemplateHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseBarcodeTemplateHeadController.class);
    @Autowired
    private PurchaseBarcodeTemplateHeadService purchaseBarcodeTemplateHeadService;
    @Autowired
    private PurchaseBarcodeTemplateItemService purchaseBarcodeTemplateItemService;
    @Autowired
    private BarcodeTemplateSupplierListService barcodeTemplateSupplierListService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @RequiresPermissions(value={"barcode#purchaseBarcodeTemplateHead:list"})
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseBarcodeTemplateHead purchaseBarcodeTemplateHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBarcodeTemplateHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBarcodeTemplateHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u6a21\u677f\u5934\u8868", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @RequiresPermissions(value={"barcode#purchaseBarcodeTemplateHead:add"})
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaseBarcodeTemplateHeadVO purchaseBarcodeTemplateHeadPage) {
        this.handleDuplicateItem(purchaseBarcodeTemplateHeadPage);
        PurchaseBarcodeTemplateHead purchaseBarcodeTemplateHead = new PurchaseBarcodeTemplateHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodeTemplateHeadPage), (Object)((Object)purchaseBarcodeTemplateHead));
        this.purchaseBarcodeTemplateHeadService.saveMain(purchaseBarcodeTemplateHead, purchaseBarcodeTemplateHeadPage.getTemplateList(), purchaseBarcodeTemplateHeadPage.getSupplierList());
        return Result.ok((Object)((Object)purchaseBarcodeTemplateHead));
    }

    private void handleDuplicateItem(PurchaseBarcodeTemplateHeadVO purchaseBarcodeTemplateHeadPage) {
        List<PurchaseBarcodeTemplateItem> templateList = purchaseBarcodeTemplateHeadPage.getTemplateList();
        List<PurchaseBarcodeTemplateItem> hideList = purchaseBarcodeTemplateHeadPage.getHideTemplateList();
        if (CollUtil.isNotEmpty(templateList)) {
            if (CollUtil.isNotEmpty(hideList)) {
                templateList.addAll(hideList);
            }
            ArrayList newList = Lists.newArrayList();
            HashSet flag = Sets.newHashSet();
            templateList.forEach(x -> {
                if (!flag.contains(x.getDesignContent())) {
                    newList.add(x);
                    flag.add(x.getDesignContent());
                }
            });
            purchaseBarcodeTemplateHeadPage.setTemplateList(newList);
        }
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u6a21\u677f\u5934\u8868", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @RequiresPermissions(value={"barcode#purchaseBarcodeTemplateHead:edit"})
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseBarcodeTemplateHeadVO purchaseBarcodeTemplateHeadPage) {
        this.handleDuplicateItem(purchaseBarcodeTemplateHeadPage);
        PurchaseBarcodeTemplateHead purchaseBarcodeTemplateHead = new PurchaseBarcodeTemplateHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodeTemplateHeadPage), (Object)((Object)purchaseBarcodeTemplateHead));
        this.purchaseBarcodeTemplateHeadService.updateMain(purchaseBarcodeTemplateHead, purchaseBarcodeTemplateHeadPage.getTemplateList(), purchaseBarcodeTemplateHeadPage.getSupplierList());
        return Result.ok((Object)((Object)purchaseBarcodeTemplateHead));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u6a21\u677f\u5934\u8868", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @RequiresPermissions(value={"barcode#purchaseBarcodeTemplateHead:publish"})
    @PostMapping(value={"/publish"})
    public Result<?> publish(@RequestBody PurchaseBarcodeTemplateHeadVO purchaseBarcodeTemplateHeadPage) {
        this.handleDuplicateItem(purchaseBarcodeTemplateHeadPage);
        PurchaseBarcodeTemplateHead purchaseBarcodeTemplateHead = new PurchaseBarcodeTemplateHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodeTemplateHeadPage), (Object)((Object)purchaseBarcodeTemplateHead));
        this.purchaseBarcodeTemplateHeadService.publish(purchaseBarcodeTemplateHead, purchaseBarcodeTemplateHeadPage.getTemplateList(), purchaseBarcodeTemplateHeadPage.getSupplierList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u6a21\u677f\u5934\u8868", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @RequiresPermissions(value={"barcode#purchaseBarcodeTemplateHead:delete"})
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseBarcodeTemplateHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u6a21\u677f\u5934\u8868", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @RequiresPermissions(value={"barcode#purchaseBarcodeTemplateHead:deleteBatch"})
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseBarcodeTemplateHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @RequiresPermissions(value={"barcode#purchaseBarcodeTemplateHead:queryById"})
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseBarcodeTemplateHead purchaseBarcodeTemplateHead = (PurchaseBarcodeTemplateHead)((Object)this.purchaseBarcodeTemplateHeadService.getById((Serializable)((Object)id)));
        PurchaseBarcodeTemplateHeadVO purchaseBarcodeTemplateHeadVO = new PurchaseBarcodeTemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodeTemplateHead), (Object)((Object)purchaseBarcodeTemplateHeadVO));
        List<PurchaseBarcodeTemplateItem> purchaseBarcodeTemplateItemList = this.purchaseBarcodeTemplateItemService.selectByMainId(id);
        purchaseBarcodeTemplateHeadVO.setHideTemplateList(purchaseBarcodeTemplateItemList.stream().filter(x -> BarcodeConstant.HIDE_ELEMENT_TYPE.contains(x.getElementType())).collect(Collectors.toList()));
        purchaseBarcodeTemplateItemList = purchaseBarcodeTemplateItemList.stream().filter(x -> !BarcodeConstant.HIDE_ELEMENT_TYPE.contains(x.getElementType())).sorted(Comparator.comparing(PurchaseBarcodeTemplateItem::getFiledType).reversed()).collect(Collectors.toList());
        purchaseBarcodeTemplateHeadVO.setTemplateList(purchaseBarcodeTemplateItemList);
        List<BarcodeTemplateSupplierList> barcodeTemplateSupplierListList = this.barcodeTemplateSupplierListService.selectByMainId(id);
        purchaseBarcodeTemplateHeadVO.setSupplierList(barcodeTemplateSupplierListList);
        return Result.ok((Object)((Object)purchaseBarcodeTemplateHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u6a21\u677f\u5934\u8868id\u67e5\u8be2\u91c7\u8d2d\u6761\u7801\u6a21\u677f\u884c\u8868", notes="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u6a21\u677f\u5934\u8868id\u67e5\u8be2\u91c7\u8d2d\u6761\u7801\u6a21\u677f\u884c\u8868")
    @RequiresPermissions(value={"barcode#purchaseBarcodeTemplateHead:queryPurchaseBarcodeTemplateItemByMainId"})
    @GetMapping(value={"/queryPurchaseBarcodeTemplateItemByMainId"})
    public Result<?> queryPurchaseBarcodeTemplateItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseBarcodeTemplateItem> purchaseBarcodeTemplateItemList = this.purchaseBarcodeTemplateItemService.selectByMainId(id);
        return Result.ok(purchaseBarcodeTemplateItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u6a21\u677f\u5934\u8868id\u67e5\u8be2\u6761\u7801\u6a21\u677f\u4f9b\u5e94\u5546\u5217\u8868", notes="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u6a21\u677f\u5934\u8868id\u67e5\u8be2\u6761\u7801\u6a21\u677f\u4f9b\u5e94\u5546\u5217\u8868")
    @RequiresPermissions(value={"barcode#purchaseBarcodeTemplateHead:queryBarcodeTemplateSupplierListByMainId"})
    @GetMapping(value={"/queryBarcodeTemplateSupplierListByMainId"})
    public Result<?> queryBarcodeTemplateSupplierListListByMainId(@RequestParam(name="id") String id) {
        List<BarcodeTemplateSupplierList> barcodeTemplateSupplierListList = this.barcodeTemplateSupplierListService.selectByMainId(id);
        return Result.ok(barcodeTemplateSupplierListList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u6a21\u677f\u5934\u8868", value="\u6a21\u677f\u89e3\u6790")
    @RequiresPermissions(value={"barcode#purchaseBarcodeTemplateHead:templateResolve"})
    @ApiOperation(value="\u6a21\u677f\u89e3\u6790", notes="\u6a21\u677f\u89e3\u6790")
    @PostMapping(value={"/templateResolve"})
    public Result<?> templateResolve(@RequestBody Map<String, String> map, HttpServletRequest httpServletRequest) {
        List<PurchaseBarcodeTemplateItem> itemList = this.purchaseBarcodeTemplateItemService.templateResolve(map);
        return Result.ok(itemList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u6a21\u677f\u5934\u8868", value="\u6a21\u677f\u9884\u89c8")
    @ApiOperation(value="\u6a21\u677f\u9884\u89c8", notes="\u6a21\u677f\u9884\u89c8")
    @RequiresPermissions(value={"barcode#purchaseBarcodeTemplateHead:templatePreview"})
    @GetMapping(value={"/templatePreview"})
    public Result<?> templatePreview(@RequestParam(name="id") String id) {
        PurchaseBarcodeTemplateHead purchaseBarcodeTemplateHead = (PurchaseBarcodeTemplateHead)((Object)this.purchaseBarcodeTemplateHeadService.getById((Serializable)((Object)id)));
        List<PurchaseBarcodeTemplateItem> purchaseBarcodeTemplateItemList = this.purchaseBarcodeTemplateItemService.selectByMainId(id);
        StringBuffer buffer = new StringBuffer("LODOP.PRINT_INIT(\" " + purchaseBarcodeTemplateHead.getName() + " \");");
        for (PurchaseBarcodeTemplateItem item : purchaseBarcodeTemplateItemList) {
            buffer.append(item.getDesignContent()).append(";");
        }
        return Result.ok((String)buffer.toString());
    }

    @AutoLog(value="\u72b6\u6001\u542f\u7528")
    @ApiOperation(value="\u72b6\u6001\u542f\u7528", notes="\u72b6\u6001\u542f\u7528")
    @RequiresPermissions(value={"barcode#purchaseBarcodeTemplateHead:enabled"})
    @PostMapping(value={"/enabled"})
    public Result<?> enabled(@RequestBody PurchaseBarcodeTemplateHead purchaseBarcodeTemplateHead) {
        purchaseBarcodeTemplateHead.setStatus(SrmEnabledStatusEnum.ENABLED.getValue());
        this.purchaseBarcodeTemplateHeadService.updateById((Object)purchaseBarcodeTemplateHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u72b6\u6001\u7981\u7528")
    @ApiOperation(value="\u72b6\u6001\u7981\u7528", notes="\u72b6\u6001\u7981\u7528")
    @RequiresPermissions(value={"barcode#purchaseBarcodeTemplateHead:disabled"})
    @PostMapping(value={"/disabled"})
    public Result<?> disabled(@RequestBody PurchaseBarcodeTemplateHead purchaseBarcodeTemplateHead) {
        purchaseBarcodeTemplateHead.setStatus(SrmEnabledStatusEnum.DISABLED.getValue());
        this.purchaseBarcodeTemplateHeadService.updateById((Object)purchaseBarcodeTemplateHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6a21\u677f\u590d\u5236")
    @ApiOperation(value="\u6a21\u677f\u590d\u5236", notes="\u6a21\u677f\u590d\u5236")
    @RequiresPermissions(value={"barcode#purchaseBarcodeTemplateHead:templateCopy"})
    @PostMapping(value={"/templateCopy"})
    public Result<?> templateCopy(@RequestBody PurchaseBarcodeTemplateHead purchaseBarcodeTemplateHead) {
        if (StringUtils.isBlank((CharSequence)purchaseBarcodeTemplateHead.getId())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_WWxOLV_de170bab", (String)"id\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        this.purchaseBarcodeTemplateHeadService.templateCopy(purchaseBarcodeTemplateHead.getId());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u660e\u7ec6\u6570\u636e", notes="\u901a\u8fc7id\u67e5\u8be2\u660e\u7ec6\u6570\u636e")
    @RequiresPermissions(value={"barcode#purchaseBarcodeTemplateHead:queryItemByHeadId"})
    @GetMapping(value={"/queryItemByHeadId"})
    public Result<?> queryItemByHeadId(@RequestParam(name="id") String id) {
        List<PurchaseBarcodeTemplateItem> purchaseBarcodeTemplateItemList = this.purchaseBarcodeTemplateItemService.selectByMainId(id);
        return Result.ok(purchaseBarcodeTemplateItemList);
    }
}

