/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ThirdAuthDTO;
import com.els.modules.system.entity.CompanyInterfaceConfig;
import com.els.modules.system.entity.CompanyInterfaceConfigItem;
import com.els.modules.system.mapper.CompanyInterfaceConfigMapper;
import com.els.modules.system.service.CompanyInterfaceConfigItemService;
import com.els.modules.system.service.CompanyInterfaceConfigService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CompanyInterfaceConfigServiceImpl
extends BaseServiceImpl<CompanyInterfaceConfigMapper, CompanyInterfaceConfig>
implements CompanyInterfaceConfigService {
    private static final String REDIS_KEY = "sys:company:interface:";
    private static final String INTERFACE_LOGIN_URL = "/user/login";
    private static final String INTERFACE_REDIRECT = "&redirect=%2finterface%2finterfaceLog%2finterfaceLogList";
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private InterfaceUtil interfaceUtil;

    private String getRedisKey(String elsAccount, String interfaceCode) {
        StringBuilder redisKey = new StringBuilder(REDIS_KEY);
        redisKey.append(elsAccount);
        redisKey.append(interfaceCode);
        return redisKey.toString();
    }

    @Override
    public void updateCompanyInterfaceConfig(CompanyInterfaceConfig config) {
        if (StrUtil.isBlank((CharSequence)config.getInterfaceCode())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n__yVUEyVAoxOLVW_b96702ad", (String)"\u63a5\u53e3\u5e73\u53f0\u63a5\u53e3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (StrUtil.isBlank((CharSequence)config.getInterfaceId())) {
            config.setElsAccount(TenantContext.getTenant());
            config.setInterfaceId(config.getId());
            config.setInterfaceName(config.getInterfaceName());
            config.setId(null);
            config.setUpdateBy(null);
            config.setUpdateTime(null);
            ((CompanyInterfaceConfigMapper)this.baseMapper).insert((Object)config);
        } else {
            String id = config.getId();
            config.setId(config.getInterfaceId());
            config.setInterfaceId(id);
            config.setUpdateBy(null);
            config.setUpdateTime(null);
            ((CompanyInterfaceConfigMapper)this.baseMapper).updateById((Object)config);
        }
        this.redisUtil.del(new String[]{this.getRedisKey(TenantContext.getTenant(), config.getSrmInterfaceCode())});
    }

    @Override
    public IPage<CompanyInterfaceConfig> findPageList(Page<CompanyInterfaceConfig> page, QueryWrapper<CompanyInterfaceConfig> wrapper) {
        return ((CompanyInterfaceConfigMapper)this.baseMapper).findPageList(page, TenantContext.getTenant(), SysUtil.getPurchaseAccount(), wrapper);
    }

    @Override
    public CompanyInterfaceConfig getOneConfig(String elsAccount, String srmInterfaceCode) {
        CompanyInterfaceConfig config = (CompanyInterfaceConfig)((Object)this.redisUtil.get(this.getRedisKey(elsAccount, srmInterfaceCode)));
        if (config != null) {
            return config;
        }
        config = ((CompanyInterfaceConfigMapper)this.baseMapper).getOneConfig(elsAccount, SysUtil.getPurchaseAccount(), srmInterfaceCode);
        if (config != null) {
            this.redisUtil.set(this.getRedisKey(elsAccount, srmInterfaceCode), (Object)config, 14400L);
        }
        return config;
    }

    @Override
    public String getSsoUrl(String elsAccount) {
        CompanyInterfaceConfigItemService companyInterfaceConfigItemService = (CompanyInterfaceConfigItemService)SpringContextUtils.getBean(CompanyInterfaceConfigItemService.class);
        List<CompanyInterfaceConfigItem> configItemList = companyInterfaceConfigItemService.getConfig(elsAccount, "getInterfaceSSOToken");
        if (configItemList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LYuIdjyVERWSMWFKm_dc343971", (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u63a5\u53e3\u914d\u7f6e\uff0c\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff01"));
        }
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)elsAccount);
        param.put("srm_interface_code", (Object)"getInterfaceSSOToken");
        JSONObject body = new JSONObject();
        body.put("elsAccount", (Object)elsAccount);
        body.put("subAccount", (Object)configItemList.get(0).getCustomParam());
        param.put("body", (Object)body);
        JSONObject resultObj = this.interfaceUtil.callInterface(elsAccount, null, param, null);
        if (resultObj.getIntValue("code") == 200) {
            String token = resultObj.getJSONObject("result").getString("token");
            InvokeAccountRpcService invokeAccountRpcService = (InvokeAccountRpcService)SpringContextUtils.getBean(InvokeAccountRpcService.class);
            ThirdAuthDTO authDTO = invokeAccountRpcService.getThirdAuthByType(elsAccount, "0");
            StringBuilder resultUrl = new StringBuilder(authDTO.getAppUrl());
            resultUrl.append(INTERFACE_LOGIN_URL).append("?token=").append(token).append(INTERFACE_REDIRECT);
            return resultUrl.toString();
        }
        throw new ELSBootException(resultObj.getString("message"));
    }
}

