/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootSignOutException;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.PermissionDataUtil;
import com.els.common.util.PermissionFlagUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.system.config.JWTUtilExtend;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.shiro.authc.JwtToken;
import com.els.shiro.authc.ShiroRealm;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class ShiroRealmExtend
extends ShiroRealm {
    private static final Logger log = LoggerFactory.getLogger(ShiroRealmExtend.class);
    @Resource(name="coreInvokeAccountServiceImpl")
    @Lazy
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    @Lazy
    private RedisUtil redisUtil;

    public boolean supports(AuthenticationToken token) {
        return token instanceof JwtToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        String flag;
        JSONObject companySet;
        log.info("===============Shiro\u6743\u9650\u8ba4\u8bc1\u5f00\u59cb============ [ roles\u3001permissions]==========");
        String elsAccount = null;
        String subAccount = null;
        if (principals != null) {
            LoginUser sysUser = (LoginUser)principals.getPrimaryPrincipal();
            elsAccount = sysUser.getElsAccount();
            subAccount = sysUser.getSubAccount();
        }
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        Set roleSet = this.invokeAccountRpcService.getUserRolesSet(elsAccount, subAccount);
        info.setRoles(roleSet);
        boolean optFlag = false;
        LoginUser user = SysUtil.getLoginUser();
        if (user != null && (companySet = user.getCompanySet()) != null && "1".equals(flag = companySet.getString("permissionOpt"))) {
            optFlag = true;
        }
        flag = AdminFlagUtil.getAdminFlag();
        Set permissionSet = optFlag && !"1".equals(flag) ? this.invokeAccountRpcService.getUserPermissionsSet(elsAccount, subAccount) : this.invokeAccountRpcService.getAllOptPermission();
        info.addStringPermissions((Collection)permissionSet);
        log.info("===============Shiro\u6743\u9650\u8ba4\u8bc1\u6210\u529f==============");
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken auth) throws AuthenticationException {
        String token = (String)auth.getCredentials();
        if (token == null) {
            log.info("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u8eab\u4efd\u8ba4\u8bc1\u5931\u8d25\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014IP\u5730\u5740:  " + ConvertUtils.getIpAddrByRequest((HttpServletRequest)SpringContextUtils.getHttpServletRequest()));
            throw new AuthenticationException(I18nUtil.translate((String)"i18n_alert_WWWWWLVW_bf685408", (String)"token\u4e3a\u7a7a!"));
        }
        LoginUser loginUser = this.checkUserTokenIsEffect(token);
        return new SimpleAuthenticationInfo((Object)loginUser, (Object)token, this.getName());
    }

    public LoginUser checkUserTokenIsEffect(String token) throws AuthenticationException {
        String account = JwtUtil.getAccount((String)token);
        if (account == null) {
            throw new AuthenticationException(I18nUtil.translate((String)"i18n_alert_WWWWWuhSXW_88a8eac9", (String)"token\u975e\u6cd5\u65e0\u6548!"));
        }
        LoginUserDTO loginUser = this.invokeAccountRpcService.getLoginUser(account);
        if (loginUser == null) {
            throw new AuthenticationException(I18nUtil.translate((String)"i18n_alert_jDxMKW_782540b3", (String)"\u7528\u6237\u4e0d\u5b58\u5728!"));
        }
        if (loginUser.getStatus() != 1) {
            throw new AuthenticationException(I18nUtil.translate((String)"i18n_alert_eyIqdIWVKHRvjW_42c9dc43", (String)"\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!"));
        }
        if (!this.jwtTokenRefresh(token, account, loginUser.getPassword())) {
            log.info("\u2014\u2014\u2014Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55!\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + token);
            throw new AuthenticationException(I18nUtil.translate((String)"i18n_alert_WWWWWKXWVVVEHW_8bdef769", (String)"Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55!"));
        }
        String adminFlag = (String)this.redisUtil.get("sys:token:role:" + token);
        AdminFlagUtil.setAdminFlag((String)adminFlag);
        PermissionFlagUtil.clear();
        PermissionDataUtil.clear();
        LoginUser user = new LoginUser();
        BeanUtils.copyProperties((Object)loginUser, (Object)user);
        return user;
    }

    private boolean jwtTokenRefresh(String token, String account, String passWord) {
        String repeatLoginToken = (String)this.redisUtil.get("sys:token:repeat:" + token);
        if (StrUtil.isNotBlank((CharSequence)repeatLoginToken)) {
            throw new ELSBootSignOutException(CommonConstant.SC_ELS_SIGN_OUT + "");
        }
        String cacheToken = String.valueOf(this.redisUtil.get("sys:token:" + token));
        if (ConvertUtils.isNotEmpty((Object)cacheToken)) {
            String elsAccount = JWTUtilExtend.sign(account, passWord);
            this.redisUtil.set("sys:token:" + token, (Object)elsAccount);
            this.redisUtil.expire("sys:token:" + token, 3600L);
            this.redisUtil.set("sys:token:" + account, (Object)elsAccount);
            this.redisUtil.expire("sys:token:" + account, 3600L);
            log.info("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u7528\u6237\u5728\u7ebf\u64cd\u4f5c\uff0c\u66f4\u65b0token\u4fdd\u8bc1\u4e0d\u6389\u7ebf\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014jwtTokenRefresh\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + token);
            elsAccount = account.split("_")[0];
            TenantContext.setTenant((String)elsAccount);
            return true;
        }
        if (JWTUtilExtend.verify(token, account, passWord)) {
            String elsAccount = account.split("_")[0];
            TenantContext.setTenant((String)elsAccount);
            return true;
        }
        return false;
    }

    public void clearCache(PrincipalCollection principals) {
        super.clearCache(principals);
    }
}

