/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.util.StyleUtil;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.AbstractCellStyleStrategy;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelCellStyleStrategy
extends AbstractCellStyleStrategy {
    private List<ExcelDetail> detailList;
    protected CellStyle commonCellStyle;
    protected CellStyle redCellStyle;

    public ExcelCellStyleStrategy(List<ExcelDetail> detailList) {
        this.detailList = detailList;
    }

    protected void initCellStyle(Workbook workbook) {
        WriteCellStyle writeCellStyle = new WriteCellStyle();
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        writeCellStyle.setWriteFont(headWriteFont);
        this.commonCellStyle = StyleUtil.buildHeadCellStyle((Workbook)workbook, (WriteCellStyle)writeCellStyle);
        WriteCellStyle redWriteCellStyle = new WriteCellStyle();
        WriteFont redWriteFont = new WriteFont();
        redWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        redWriteFont.setColor(Short.valueOf((short)10));
        redWriteCellStyle.setWriteFont(redWriteFont);
        this.redCellStyle = StyleUtil.buildHeadCellStyle((Workbook)workbook, (WriteCellStyle)redWriteCellStyle);
    }

    protected void setHeadCellStyle(Cell cell, Head head, Integer relativeRowIndex) {
        if (relativeRowIndex > 0) {
            if (cell.getStringCellValue().contains("\u975e\u5fc5\u586b")) {
                cell.setCellStyle(this.commonCellStyle);
            } else {
                cell.setCellStyle(this.redCellStyle);
            }
            cell.getSheet().setColumnWidth(head.getColumnIndex().intValue(), cell.getStringCellValue().length() * 600);
        } else {
            cell.setCellStyle(this.commonCellStyle);
        }
    }

    protected void setContentCellStyle(Cell cell, Head head, Integer relativeRowIndex) {
        cell.setCellStyle(this.commonCellStyle);
        ExcelDetail detail = this.detailList.get(head.getColumnIndex());
        if (ExcelDataTypeEnum.STRING.getCode().equals(detail.getDataType())) {
            cell.setCellType(CellType.STRING);
        } else if (ExcelDataTypeEnum.NUMBER.getCode().equals(detail.getDataType())) {
            cell.setCellType(CellType.NUMERIC);
        } else if (ExcelDataTypeEnum.DATE.getCode().equals(detail.getDataType())) {
            cell.setCellType(CellType.STRING);
        }
        if (StrUtil.isNotBlank((CharSequence)detail.getDataFormat())) {
            DataFormat format = cell.getSheet().getWorkbook().createDataFormat();
            cell.getCellStyle().setDataFormat(format.getFormat(detail.getDataFormat()));
        }
        if (ExcelDataTypeEnum.DATE.getCode().equals(detail.getDataType())) {
            CreationHelper createHelper = cell.getSheet().getWorkbook().getCreationHelper();
            cell.getCellStyle().setDataFormat(createHelper.createDataFormat().getFormat("yyyy-MM-dd"));
        }
    }
}

