/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.BackgroundFileTask;
import com.els.modules.system.enums.ExcelTaskTypeEnum;
import com.els.modules.system.service.BackgroundFileTaskService;
import com.els.modules.system.util.ExcelGenerateRunner;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/fileTask"})
@Api(tags={"Excel\u914d\u7f6e"})
public class BackgroundFileTaskController
extends BaseController<BackgroundFileTask, BackgroundFileTaskService> {
    private static final Logger log = LoggerFactory.getLogger(BackgroundFileTaskController.class);
    @Autowired
    private BackgroundFileTaskService backgroundFileTaskService;
    @Autowired(required=false)
    private ExcelGenerateRunner excelGenerateRunner;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(BackgroundFileTask backgroundFileTask, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)backgroundFileTask, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        return Result.ok((Object)this.backgroundFileTaskService.page((IPage)page, (Wrapper)queryWrapper));
    }

    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.backgroundFileTaskService.deleteFileTask(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u6267\u884c", notes="\u901a\u8fc7id\u6267\u884c")
    @GetMapping(value={"/runTask"})
    public Result<?> runTask(@RequestParam(name="id") String id) {
        BackgroundFileTask task = (BackgroundFileTask)this.backgroundFileTaskService.getById((Serializable)((Object)id));
        if (null == task) {
            return this.commonSuccessResult(4);
        }
        if (!"0".equals(task.getTaskStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u6267\u884c\u6587\u4ef6\u751f\u6210\u4efb\u52a1"));
        }
        if (ExcelTaskTypeEnum.IMPORT_ERROR.getCode().equals(task.getTaskType())) {
            this.excelGenerateRunner.immediateExec(id, null);
        }
        return this.commonSuccessResult(4);
    }
}

