/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.oss.enumerate.AttachmentTypeEnum;
import com.els.modules.attachment.oss.service.IAttachmnetService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"NLP\u9644\u4ef6"})
@RestController
@RequestMapping(value={"/attachment/nlp"})
public class NLPAttachmentAndExpainController {
    private static final Logger log = LoggerFactory.getLogger(NLPAttachmentAndExpainController.class);
    private static final String STR_FORMAT = "yyyyMMdd";
    private static final String STR_SPLIT = "_";
    private static final String STR_DOT = ".";
    private String fileServerType = "local";
    @Value(value="${els.path.upload}")
    private String uploadpath;
    @Value(value="${els.config.service.address}")
    private String address;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @AutoLog(value="NLP\u9644\u4ef6-\u4e0a\u4f20", operateType=2)
    @ApiOperation(value="NLP\u9644\u4ef6", notes="NLP\u9644\u4ef6")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public Result<?> upload(HttpServletRequest request) {
        String bizPath = "files";
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowday = dtf.format(time);
        File file = new File(this.uploadpath + File.separator + bizPath + File.separator + TenantContext.getTenant() + File.separator + nowday);
        if (!file.exists()) {
            file.mkdirs();
        }
        String service = "valueAddedApplication";
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        try {
            Iterator iterator = fileMap.entrySet().iterator();
            if (iterator.hasNext()) {
                String fileName;
                Map.Entry entity = iterator.next();
                MultipartFile uploadFile = (MultipartFile)entity.getValue();
                String documentName = uploadFile.getOriginalFilename();
                int suffixLocation = documentName.lastIndexOf(STR_DOT);
                if (suffixLocation > 0) {
                    String documentType = documentName.substring(suffixLocation + 1);
                    fileName = documentName.substring(0, documentName.lastIndexOf(STR_DOT)) + STR_SPLIT + System.currentTimeMillis() + STR_DOT + documentType;
                } else {
                    fileName = documentName + STR_SPLIT + System.currentTimeMillis();
                }
                String documentLocation = File.separator + bizPath + File.separator + TenantContext.getTenant() + File.separator + nowday + File.separator + fileName;
                if (documentLocation.contains("\\")) {
                    documentLocation = documentLocation.replace("\\", "/");
                }
                String savePath = file.getPath() + File.separator + fileName;
                IAttachmnetService iAttachmnetService = (IAttachmnetService)SpringContextUtils.getBean((String)AttachmentTypeEnum.getByType(this.fileServerType).getImplClass());
                String remotePath = iAttachmnetService.uploadFile(uploadFile, savePath);
                HashMap<String, String> param = new HashMap<String, String>();
                String filePath = this.address + "/opt/upFiles" + documentLocation;
                param.put("filePath", filePath);
                log.info("remotePath is:" + filePath);
                JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString(param)), service, this.invokeBaseRpcService.getIpaasInterfaceCode("delivery_note"));
                JSONObject resultData = this.getChildNode(object, "data");
                resultData = this.getChildNode(resultData, "data");
                List resultList = (List)resultData.get((Object)"results");
                HashMap result = new HashMap();
                if (resultList == null) {
                    return Result.ok(result);
                }
                for (Map map : resultList) {
                    List value = (List)map.get("results");
                    if (value != null && value.size() > 0) {
                        result.put(map.get("field_name"), value.get(0));
                        continue;
                    }
                    result.put(map.get("field_name"), "");
                }
                return Result.ok(result);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_field_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25"));
    }

    private JSONObject getChildNode(JSONObject object, String childNode) {
        JSONObject reslut = new JSONObject();
        if (object != null && !object.isEmpty()) {
            reslut = (JSONObject)object.get((Object)childNode);
        }
        return reslut;
    }
}

