/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.aspect;

import cn.hutool.crypto.SecureUtil;
import com.els.common.aspect.annotation.AvoidRepeatedSubmit;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
@Aspect
@Order(value=0)
public class AvoidRepeatedSubmitAspect {
    private static final Logger log = LoggerFactory.getLogger(AvoidRepeatedSubmitAspect.class);
    private static final String SEGMENT_SYMBOL = "#";
    @Autowired
    private RedisUtil redisUtil;

    @Pointcut(value="@annotation(com.els.common.aspect.annotation.AvoidRepeatedSubmit)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object[] pointArgs;
        Method method = ((MethodSignature)point.getSignature()).getMethod();
        AvoidRepeatedSubmit annotation = method.getAnnotation(AvoidRepeatedSubmit.class);
        if (annotation == null) {
            return point.proceed();
        }
        Class targetValue = annotation.value();
        Object targetObj = null;
        for (Object pointArg : pointArgs = point.getArgs()) {
            if (pointArg.getClass() != targetValue) continue;
            targetObj = pointArg;
            break;
        }
        String methodFullName = method.getDeclaringClass().getName() + SEGMENT_SYMBOL + method.getName();
        if (targetObj == null) {
            log.error("\u9a8c\u8bc1\u53c2\u6570\u5f02\u5e38\uff1a{}", (Object)methodFullName);
            throw new ELSBootException("\u9a8c\u8bc1\u53c2\u6570\u5f02\u5e38");
        }
        StringBuilder keyData = new StringBuilder();
        LoginUser loginUser = SysUtil.getLoginUser();
        keyData.append(loginUser.getElsAccount()).append(SEGMENT_SYMBOL).append(loginUser.getSubAccount()).append(SEGMENT_SYMBOL).append(methodFullName).append(SEGMENT_SYMBOL);
        Object finalTargetObj = targetObj;
        AtomicInteger fieldCounter = new AtomicInteger(0);
        ReflectionUtils.doWithFields(targetObj.getClass(), field -> {
            ReflectionUtils.makeAccessible((Field)field);
            Object value = ReflectionUtils.getField((Field)field, (Object)finalTargetObj);
            if (fieldCounter.get() <= 15 && value instanceof String) {
                keyData.append(value);
                fieldCounter.incrementAndGet();
            }
        });
        String lockKey = SecureUtil.md5((String)keyData.toString());
        try {
            if (this.redisUtil.tryGetDistributedLock(lockKey, lockKey, 10000L)) {
                Object object = point.proceed();
                return object;
            }
            log.error("\u91cd\u590d\u63d0\u4ea4\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            throw new ELSBootException("\u91cd\u590d\u63d0\u4ea4\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        finally {
            this.redisUtil.releaseDistributedLock(lockKey, lockKey);
        }
    }
}

