/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util;

import cn.hutool.core.convert.Convert;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.dto.ElsEmailConfigDTO;
import java.util.Map;
import java.util.Properties;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class EmailBuilder {
    private static final Logger log = LoggerFactory.getLogger(EmailBuilder.class);

    public static JavaMailSender buildJavaMailSender(ElsEmailConfigDTO config) {
        MailProperties mailProperties;
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        try {
            mailProperties = (MailProperties)SpringContextUtils.getBean(MailProperties.class);
        }
        catch (Exception var4) {
            log.warn(":::\u6ca1\u6709\u914d\u7f6espring.email\u914d\u7f6e");
            mailProperties = new MailProperties();
            sender.setDefaultEncoding("UTF-8");
        }
        MailProperties mailProperties2 = (MailProperties)Convert.convert(MailProperties.class, (Object)mailProperties);
        mailProperties2.setUsername(config.getEmailUsername());
        mailProperties2.setPassword(config.getEmailPassword());
        mailProperties2.setPort(Integer.valueOf(null == config.getEmailPort() ? 25 : config.getEmailPort()));
        mailProperties2.setHost(config.getEmailHost());
        EmailBuilder.applyProperties(mailProperties2, sender);
        log.info("EmailBuilder ==> create JavaMailSender over");
        return sender;
    }

    public static boolean sendEmail(ElsEmailConfigDTO config, String to, String subject, String content, String cc, boolean needCc) {
        JavaMailSender mailSender = EmailBuilder.buildJavaMailSender(config);
        MimeMessage message = mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content, true);
            helper.setFrom(config.getEmailUsername());
            if (needCc) {
                helper.setCc(cc.split(","));
            }
        }
        catch (Exception var11) {
            log.error("EmailBuilder==>sendEmail:{}", (Object)var11.getMessage());
            throw new ELSBootException(var11.getMessage());
        }
        try {
            mailSender.send(message);
            return true;
        }
        catch (Exception var10) {
            return false;
        }
    }

    public static void sendEmailWithEp(ElsEmailConfigDTO config, String to, String subject, String content, String cc, boolean needCc) {
        JavaMailSender mailSender = EmailBuilder.buildJavaMailSender(config);
        MimeMessage message = mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content, true);
            helper.setFrom(config.getEmailUsername());
            if (needCc) {
                helper.setCc(cc.split(","));
            }
            mailSender.send(message);
        }
        catch (Exception var10) {
            log.error("EmailBuilder==>sendEmail:{}", (Object)var10.getMessage());
            throw new ELSBootException(var10.getMessage());
        }
    }

    private static void applyProperties(MailProperties properties, JavaMailSenderImpl sender) {
        sender.setHost(properties.getHost());
        if (properties.getPort() != null) {
            sender.setPort(properties.getPort().intValue());
        }
        sender.setUsername(properties.getUsername());
        sender.setPassword(properties.getPassword());
        sender.setProtocol(465 == properties.getPort() ? "smtps" : properties.getProtocol());
        if (properties.getDefaultEncoding() != null) {
            sender.setDefaultEncoding(properties.getDefaultEncoding().name());
        }
        if (!properties.getProperties().isEmpty()) {
            sender.setJavaMailProperties(EmailBuilder.asProperties(properties.getProperties()));
        }
    }

    private static Properties asProperties(Map<String, String> source) {
        Properties properties = new Properties();
        properties.putAll(source);
        return properties;
    }
}

