/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.barcode.entity.PurchaseBarcodeLevelHead;
import com.els.modules.barcode.entity.PurchaseBarcodeLevelItem;
import com.els.modules.barcode.service.PurchaseBarcodeInfoDetailService;
import com.els.modules.barcode.service.PurchaseBarcodeLevelHeadService;
import com.els.modules.barcode.service.PurchaseBarcodeLevelItemService;
import com.els.modules.barcode.service.PurchaseBarcodePoolHeadService;
import com.els.modules.barcode.vo.BarcodeInfoVO;
import com.els.modules.barcode.vo.PurchaseBarcodeLevelHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/barcode/purchaseBarcodeLevelHead"})
@Api(tags={"\u91c7\u8d2d\u6761\u7801\u5c42\u7ea7\u5934\u8868"})
public class PurchaseBarcodeLevelHeadController
extends BaseController<PurchaseBarcodeLevelHead, PurchaseBarcodeLevelHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseBarcodeLevelHeadController.class);
    @Autowired
    private PurchaseBarcodeLevelHeadService purchaseBarcodeLevelHeadService;
    @Autowired
    private PurchaseBarcodeLevelItemService purchaseBarcodeLevelItemService;
    @Autowired
    private PurchaseBarcodePoolHeadService purchaseBarcodePoolHeadService;
    @Autowired
    private PurchaseBarcodeInfoDetailService purchaseBarcodeInfoDetailService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseBarcodeLevelHead purchaseBarcodeLevelHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<PurchaseBarcodeLevelHead> queryWrapper = QueryGenerator.initQueryWrapper(purchaseBarcodeLevelHead, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBarcodeLevelHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u5c42\u7ea7\u5934\u8868", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"barcode#level:add"})
    public Result<?> add(@RequestBody PurchaseBarcodeLevelHeadVO purchaseBarcodeLevelHeadPage) {
        PurchaseBarcodeLevelHead purchaseBarcodeLevelHead = new PurchaseBarcodeLevelHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodeLevelHeadPage), (Object)((Object)purchaseBarcodeLevelHead));
        this.purchaseBarcodeLevelHeadService.saveMain(purchaseBarcodeLevelHead, purchaseBarcodeLevelHeadPage.getBarcodeLevelItemList());
        return Result.ok((Object)((Object)purchaseBarcodeLevelHead));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u5c42\u7ea7\u5934\u8868", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"barcode#level:edit"})
    public Result<?> edit(@RequestBody PurchaseBarcodeLevelHeadVO purchaseBarcodeLevelHeadPage) {
        PurchaseBarcodeLevelHead purchaseBarcodeLevelHead = new PurchaseBarcodeLevelHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodeLevelHeadPage), (Object)((Object)purchaseBarcodeLevelHead));
        this.purchaseBarcodeLevelHeadService.updateMain(purchaseBarcodeLevelHead, purchaseBarcodeLevelHeadPage.getBarcodeLevelItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u5c42\u7ea7\u5934\u8868", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    public Result<?> publish(@RequestBody PurchaseBarcodeLevelHeadVO purchaseBarcodeLevelHeadPage) {
        PurchaseBarcodeLevelHead purchaseBarcodeLevelHead = new PurchaseBarcodeLevelHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodeLevelHeadPage), (Object)((Object)purchaseBarcodeLevelHead));
        this.purchaseBarcodeLevelHeadService.publish(purchaseBarcodeLevelHead, purchaseBarcodeLevelHeadPage.getBarcodeLevelItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u5c42\u7ea7\u5934\u8868", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"barcode#level:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseBarcodeLevelHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u5c42\u7ea7\u5934\u8868", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseBarcodeLevelHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"barcode#level:detail"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseBarcodeLevelHead purchaseBarcodeLevelHead = (PurchaseBarcodeLevelHead)((Object)this.purchaseBarcodeLevelHeadService.getById((Serializable)((Object)id)));
        PurchaseBarcodeLevelHeadVO purchaseBarcodeLevelHeadVO = new PurchaseBarcodeLevelHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodeLevelHead), (Object)((Object)purchaseBarcodeLevelHeadVO));
        List<PurchaseBarcodeLevelItem> purchaseBarcodeLevelItemList = this.purchaseBarcodeLevelItemService.selectByMainId(id);
        purchaseBarcodeLevelHeadVO.setBarcodeLevelItemList(purchaseBarcodeLevelItemList);
        return Result.ok((Object)((Object)purchaseBarcodeLevelHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u5c42\u7ea7\u5934\u8868id\u67e5\u8be2\u91c7\u8d2d\u6761\u7801\u5c42\u7ea7\u884c\u8868", notes="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u5c42\u7ea7\u5934\u8868id\u67e5\u8be2\u91c7\u8d2d\u6761\u7801\u5c42\u7ea7\u884c\u8868")
    @GetMapping(value={"/queryPurchaseBarcodeLevelItemByMainId"})
    public Result<?> queryPurchaseBarcodeLevelItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseBarcodeLevelItem> purchaseBarcodeLevelItemList = this.purchaseBarcodeLevelItemService.selectByMainId(id);
        return Result.ok(purchaseBarcodeLevelItemList);
    }

    @ApiOperation(value="\u83b7\u53d6\u6761\u7801\u4fe1\u606f", notes="\u83b7\u53d6\u6761\u7801\u4fe1\u606f")
    @GetMapping(value={"/getBarcodeInfo"})
    public Result<?> getBarcodeInfo(@RequestParam(name="barcode") String barcode) {
        BarcodeInfoVO poolBarcodeInfo = this.purchaseBarcodePoolHeadService.getBarcodeInfo(barcode);
        if (poolBarcodeInfo != null) {
            return Result.ok((Object)poolBarcodeInfo);
        }
        BarcodeInfoVO barcodeInfo = this.purchaseBarcodeInfoDetailService.getBarcodeInfo(barcode);
        return Result.ok((Object)barcodeInfo);
    }
}

