/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.execl;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.PurchaseBarcodePoolHead;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.service.PurchaseBarcodePoolHeadService;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="barcodePoolHeadExcelHandle")
public class BarcodePoolHeadExcelHandle
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private PurchaseBarcodePoolHeadService purchaseBarcodePoolHeadService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List<Map<String, Object>> dataList = excelImportDTO.getDataList();
        int totalCount = dataList.size();
        Assert.notEmpty(dataList, (String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        ArrayList<PurchaseBarcodePoolHead> entityList = new ArrayList<PurchaseBarcodePoolHead>();
        ArrayList<String> stringList = new ArrayList<String>();
        for (Map<String, Object> data : dataList) {
            PurchaseBarcodePoolHead entity = (PurchaseBarcodePoolHead)((Object)JSON.parseObject((String)JSON.toJSONString(data), PurchaseBarcodePoolHead.class));
            if (CharSequenceUtil.isNotBlank((CharSequence)entity.getBarcode())) {
                if (stringList.contains(entity.getBarcode())) {
                    String msg = I18nUtil.translate((String)"i18n_alert_uNWFsjVBjTo_852dffe1", (String)"\u5bfc\u5165\u6570\u636e\u4e2d\u6709\u91cd\u590d\u7684\u6761\u7801");
                    this.errorAdd(excelImportDTO, msg, data);
                    continue;
                }
                stringList.add(entity.getBarcode());
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(PurchaseBarcodePoolHead::getBarcode, (Object)entity.getBarcode());
            queryWrapper.lambda().eq(PurchaseBarcodePoolHead::getRuleCode, (Object)entity.getRuleCode());
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
            PurchaseBarcodePoolHead head = (PurchaseBarcodePoolHead)((Object)this.purchaseBarcodePoolHeadService.getOne((Wrapper)queryWrapper));
            if (null != head) {
                String msg = I18nUtil.translate((String)"i18n_alert_uNWFsjIOMKjTo_bb06f3b4", (String)"\u5bfc\u5165\u6570\u636e\u4e2d\u6709\u5df2\u7ecf\u5b58\u5728\u7684\u6761\u7801");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            entity.setElsAccount(TenantContext.getTenant());
            entity.setStatus(SrmEnabledStatusEnum.ENABLED.getValue());
            entity.setPrintedNumber(0);
            entityList.add(entity);
        }
        if (!entityList.isEmpty()) {
            this.purchaseBarcodePoolHeadService.saveBatch(entityList);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

