/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.execl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.PurchaseBarcodePoolHead;
import com.els.modules.barcode.service.PurchaseBarcodePoolHeadService;
import com.els.modules.barcode.service.PurchaseBarcodePoolItemService;
import com.els.modules.barcode.vo.PurchaseBarcodePoolItemVO;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="barcodePoolItemExcelHandle")
public class BarcodePoolItemExcelHandle
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private PurchaseBarcodePoolHeadService purchaseBarcodePoolHeadService;
    @Autowired
    private PurchaseBarcodePoolItemService purchaseBarcodePoolItemService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List<Map<String, Object>> dataList = excelImportDTO.getDataList();
        int totalCount = dataList.size();
        Assert.notEmpty(dataList, (String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        ArrayList<PurchaseBarcodePoolItemVO> entityList = new ArrayList<PurchaseBarcodePoolItemVO>();
        for (Map<String, Object> data : dataList) {
            PurchaseBarcodePoolItemVO entity = (PurchaseBarcodePoolItemVO)((Object)JSON.parseObject((String)JSON.toJSONString(data), PurchaseBarcodePoolItemVO.class));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(PurchaseBarcodePoolHead::getBarcode, (Object)entity.getBarcode());
            queryWrapper.lambda().eq(PurchaseBarcodePoolHead::getRuleCode, (Object)entity.getRuleCode());
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
            PurchaseBarcodePoolHead head = (PurchaseBarcodePoolHead)((Object)this.purchaseBarcodePoolHeadService.getOne((Wrapper)queryWrapper));
            if (null == head) {
                String msg = I18nUtil.translate((String)"i18n_alert_mhxuIdjToVH_1fa0d1f7", (String)"\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u6761\u7801\u4fe1\u606f");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            entity.setHeadId(head.getId());
            entity.setElsAccount(TenantContext.getTenant());
            entityList.add(entity);
        }
        if (!entityList.isEmpty()) {
            this.purchaseBarcodePoolItemService.saveBatch(entityList);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

