/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.history.rocketMq.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.modules.history.entity.ElsInitialTable;
import com.els.modules.history.service.ElsInitialTableService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Component;

@Component
public class InitTableConsumer {
    private static final Logger log = LoggerFactory.getLogger(InitTableConsumer.class);
    @Autowired
    private ElsInitialTableService elsInitialTableService;

    @StreamListener(value="inputInit")
    public void receive(String msgBody) {
        try {
            if (StringUtils.isBlank((CharSequence)msgBody)) {
                return;
            }
            JSONObject body = JSONObject.parseObject((String)msgBody);
            ElsInitialTable table = (ElsInitialTable)((Object)JSONObject.toJavaObject((JSON)body, ElsInitialTable.class));
            if (StringUtils.isNotBlank((CharSequence)table.getRelationId()) && StringUtils.isNotBlank((CharSequence)table.getBusinessInfoJson())) {
                log.info("msgBody: " + msgBody);
                ElsInitialTable bdTable = (ElsInitialTable)((Object)this.elsInitialTableService.getOne((Wrapper)new LambdaQueryWrapper().eq(ElsInitialTable::getRelationId, (Object)table.getRelationId())));
                if (bdTable != null) {
                    this.elsInitialTableService.updateElsInitialTable(table);
                } else {
                    this.elsInitialTableService.saveElsInitialTable(table);
                }
            }
        }
        catch (Exception e) {
            log.error("InitTableConsumer_receive_msgBody:" + msgBody, (Throwable)e);
            throw e;
        }
    }
}

