/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.util.RedisUtil;
import com.els.modules.system.entity.District;
import com.els.modules.system.mapper.DistrictMapper;
import com.els.modules.system.model.DistrictModel;
import com.els.modules.system.service.DistrictService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DistrictServiceImpl
extends ServiceImpl<DistrictMapper, District>
implements DistrictService {
    @Resource
    private RedisUtil redisUtil;

    @Override
    @CacheEvict(value={"sys:cache:district"})
    public void saveDistrict(District district) {
        ((DistrictMapper)this.baseMapper).insert(district);
    }

    @Override
    @CacheEvict(value={"sys:cache:district"})
    public void updateDistrict(District district) {
        ((DistrictMapper)this.baseMapper).updateById(district);
    }

    @Override
    @CacheEvict(value={"sys:cache:district"})
    public void delDistrict(String id) {
        ((DistrictMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.redisUtil.del(new String[]{"sys:cache:district"});
    }

    @Override
    public void delBatchDistrict(List<String> idList) {
        ((DistrictMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @Cacheable(value={"sys:cache:district"})
    public List<DistrictModel> districtTree(String countryCode) {
        List districtList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(District::getCountryCode, (Object)countryCode)).eq(District::getDeleted, (Object)CommonConstant.DEL_FLAG_0)).list();
        HashMap<String, ArrayList> groupDistrict = new HashMap<String, ArrayList>(16);
        ArrayList<DistrictModel> provinceList = new ArrayList<DistrictModel>();
        ArrayList<DistrictModel> cityList = new ArrayList<DistrictModel>();
        for (District district : districtList) {
            DistrictModel districtModel = new DistrictModel();
            districtModel.setId(district.getId());
            districtModel.setLabel(district.getName());
            districtModel.setValue(district.getAdCode());
            if ("province".equals(district.getLevel())) {
                provinceList.add(districtModel);
            } else if ("city".equals(district.getLevel())) {
                cityList.add(districtModel);
            }
            if (groupDistrict.containsKey(district.getParentId())) {
                ((List)groupDistrict.get(district.getParentId())).add(districtModel);
                continue;
            }
            groupDistrict.put(district.getParentId(), Lists.newArrayList((Object[])new DistrictModel[]{districtModel}));
        }
        cityList.forEach(item -> item.setChildren((List)groupDistrict.get(item.getId())));
        provinceList.forEach(item -> item.setChildren((List)groupDistrict.get(item.getId())));
        return provinceList;
    }
}

