/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.EmailBuilder;
import com.els.common.util.I18nUtil;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.base.api.dto.ElsEmailConfigDTO;
import com.els.modules.system.entity.ElsEmailConfig;
import com.els.modules.system.mapper.ElsEmailConfigMapper;
import com.els.modules.system.service.ElsEmailConfigService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ElsEmailConfigServiceImpl
extends BaseServiceImpl<ElsEmailConfigMapper, ElsEmailConfig>
implements ElsEmailConfigService {
    private boolean sendEmailCheck(ElsEmailConfig config) {
        try {
            EmailBuilder.sendEmailWithEp((ElsEmailConfigDTO)Convert.convert(ElsEmailConfigDTO.class, (Object)((Object)config)), config.getEmailUsername(), "SRM Email Setting Test!", "SRM Email Setting Test!", CharSequenceUtil.isBlank((CharSequence)config.getEmailCc()) ? config.getEmailUsername() : config.getEmailCc(), true);
            return true;
        }
        catch (Exception e) {
            this.log.error(":::\u90ae\u4ef6\u9884\u53d1\u9001\u5931\u8d25:{}", e.getCause());
            return false;
        }
    }

    private void emailSetting(ElsEmailConfig elsEmailConfig) {
        elsEmailConfig.setEnabled("0");
        if (null == elsEmailConfig.getWeight()) {
            elsEmailConfig.setWeight(100);
        }
        if (null == elsEmailConfig.getSortOrder()) {
            elsEmailConfig.setSortOrder(0);
        }
        if (null == elsEmailConfig.getEmailPort()) {
            elsEmailConfig.setEmailPort(25);
        }
        if (SrmEnabledStatusEnum.ENABLED.getValue().equals(elsEmailConfig.getStatus())) {
            boolean check = this.sendEmailCheck(elsEmailConfig);
            elsEmailConfig.setEnabled(check ? "1" : "0");
        }
    }

    @Override
    public void add(ElsEmailConfig elsEmailConfig) {
        this.emailSetting(elsEmailConfig);
        ((ElsEmailConfigMapper)this.baseMapper).insert((Object)elsEmailConfig);
    }

    @Override
    public void edit(ElsEmailConfig elsEmailConfig) {
        this.emailSetting(elsEmailConfig);
        int count = ((ElsEmailConfigMapper)this.baseMapper).updateById((Object)elsEmailConfig);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((ElsEmailConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ElsEmailConfigMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public ElsEmailConfigDTO getEmailConfig(String elsAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ElsEmailConfig::getStatus, (Object)SrmEnabledStatusEnum.ENABLED.getValue())).eq(ElsEmailConfig::getEnabled, (Object)"1")).orderByDesc(ElsEmailConfig::getWeight)).last(" limit 1");
        ElsEmailConfig elsEmailConfig = (ElsEmailConfig)((Object)((ElsEmailConfigMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        if (null == elsEmailConfig && !"100000".equals(elsAccount)) {
            wrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)"100000")).eq(ElsEmailConfig::getStatus, (Object)SrmEnabledStatusEnum.ENABLED.getValue())).eq(ElsEmailConfig::getEnabled, (Object)"1")).orderByDesc(ElsEmailConfig::getWeight)).last(" limit 1");
            elsEmailConfig = (ElsEmailConfig)((Object)((ElsEmailConfigMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        }
        return (ElsEmailConfigDTO)Convert.convert(ElsEmailConfigDTO.class, (Object)((Object)elsEmailConfig));
    }

    @Override
    public List<ElsEmailConfigDTO> getEmailConfigs(String elsAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ElsEmailConfig::getStatus, (Object)SrmEnabledStatusEnum.ENABLED.getValue())).eq(ElsEmailConfig::getEnabled, (Object)"1")).orderByDesc(ElsEmailConfig::getWeight);
        List elsEmailConfigs = ((ElsEmailConfigMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)elsEmailConfigs) && !"100000".equals(elsAccount)) {
            wrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)"100000")).eq(ElsEmailConfig::getStatus, (Object)SrmEnabledStatusEnum.ENABLED.getValue())).eq(ElsEmailConfig::getEnabled, (Object)"1")).orderByDesc(ElsEmailConfig::getWeight);
            elsEmailConfigs = ((ElsEmailConfigMapper)this.baseMapper).selectList((Wrapper)wrapper);
        }
        return Convert.toList(ElsEmailConfigDTO.class, (Object)elsEmailConfigs);
    }
}

