/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.extend.api.common.util.SerialNumberUtil;
import com.els.modules.system.entity.CodeGeneratorSerial;
import com.els.modules.system.service.CodeGeneratorSerialService;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SerialNumberUtilImpl
implements SerialNumberUtil {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CodeGeneratorSerialService codeGeneratorSerialService;
    private final Long LOCK_TIME_OUT = 3000L;
    private final Long LOCK_WAIT_TIME = 3000L;

    public String getContractNum(String orderKey, String supplierType, String orgType, String objStr) {
        String serialNumer = this.getSerialNumer(orgType, orderKey);
        if (StringUtils.equals((CharSequence)supplierType, (CharSequence)"A")) {
            return this.generateSupplierTypeACode(objStr, serialNumer);
        }
        if (StringUtils.equalsAny((CharSequence)supplierType, (CharSequence[])new CharSequence[]{"B"})) {
            return this.generateSupplierTypeBCode(orgType, serialNumer);
        }
        throw new RuntimeException("\u5408\u540c\u9700\u65b9\u7c7b\u578b\u672a\u5b9a\u4e49\uff0c\u65e0\u6cd5\u751f\u6210\u8ba2\u5355\u7f16\u53f7\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNumer(String orgType, String orderKey) {
        String serialNo;
        block12: {
            LocalDate currentdate = LocalDate.now();
            int year = currentdate.getYear();
            int month = currentdate.getMonthValue();
            String salt = ConvertUtils.randomGen((int)8);
            String elsAccount = TenantContext.getTenant();
            String redisKey = elsAccount + "_" + orderKey + "_" + year + month + "_" + orgType;
            Long serialNoLongVal = this.redisUtil.incr("serial:" + redisKey + "_" + salt, 1L);
            serialNo = String.valueOf(serialNoLongVal);
            try {
                if (this.redisUtil.tryLockWithTimeout(redisKey, salt, this.LOCK_TIME_OUT.longValue(), this.LOCK_WAIT_TIME.longValue())) {
                    if (StringUtils.isEmpty((CharSequence)elsAccount)) {
                        elsAccount = TenantContext.getTenant();
                    }
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"serial_key", (Object)redisKey);
                    queryWrapper.eq((Object)"els_account", (Object)elsAccount);
                    CodeGeneratorSerial codeGeneratorSerial = (CodeGeneratorSerial)((Object)this.codeGeneratorSerialService.getOne((Wrapper)queryWrapper));
                    if (1L == serialNoLongVal) {
                        if (codeGeneratorSerial != null) {
                            codeGeneratorSerial.setSerialValue(codeGeneratorSerial.getSerialValue() + 1);
                            this.codeGeneratorSerialService.updateById((Object)codeGeneratorSerial);
                            this.redisUtil.incr("serial:" + redisKey + "_" + salt, (long)codeGeneratorSerial.getSerialValue().intValue() - 1L);
                            this.redisUtil.expire("serial:" + redisKey + "_" + salt, 87400L);
                        } else {
                            if (999L <= serialNoLongVal) {
                                throw new RuntimeException("\u5408\u540c\u7f16\u53f7\u6d41\u6c34\u53f7\u5df2\u7528\u5b8c\uff01");
                            }
                            codeGeneratorSerial = new CodeGeneratorSerial();
                            codeGeneratorSerial.setSerialKey(redisKey);
                            codeGeneratorSerial.setSerialValue(1);
                            codeGeneratorSerial.setElsAccount(elsAccount);
                            this.codeGeneratorSerialService.save((Object)codeGeneratorSerial);
                            this.redisUtil.expire("serial:" + redisKey + "_" + salt, 87400L);
                        }
                        serialNo = String.format("%03d", codeGeneratorSerial.getSerialValue());
                    } else {
                        if (codeGeneratorSerial != null) {
                            codeGeneratorSerial.setSerialValue(serialNoLongVal.intValue());
                            this.codeGeneratorSerialService.updateById((Object)codeGeneratorSerial);
                        } else {
                            codeGeneratorSerial = new CodeGeneratorSerial();
                            codeGeneratorSerial.setSerialKey(redisKey);
                            codeGeneratorSerial.setSerialValue(serialNoLongVal.intValue());
                            codeGeneratorSerial.setElsAccount(elsAccount);
                            this.codeGeneratorSerialService.save((Object)codeGeneratorSerial);
                        }
                        serialNo = String.format("%03d", (long)serialNoLongVal);
                    }
                    break block12;
                }
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_HeiJWVRSKKW_c75d5308", (String)"\u7cfb\u7edf\u6b63\u5fd9\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\uff01"));
            }
            finally {
                this.redisUtil.releaseDistributedLock(redisKey, salt);
            }
        }
        return serialNo;
    }

    public String generateSupplierTypeACode(String objStr, String serialNumer) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        String newNumber = "W" + format.format(new Date()) + serialNumer + objStr;
        return newNumber;
    }

    public String generateSupplierTypeBCode(String orgType, String serialNumer) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String companyCode = null;
        if (StringUtils.equals((CharSequence)orgType, (CharSequence)"HXCG")) {
            companyCode = "CG";
        } else if (StringUtils.equals((CharSequence)orgType, (CharSequence)"HYCG")) {
            companyCode = "HYCG";
        } else if (StringUtils.equals((CharSequence)orgType, (CharSequence)"LMD")) {
            companyCode = "LMD";
        } else if (StringUtils.equals((CharSequence)orgType, (CharSequence)"XTCG")) {
            companyCode = "XT";
        } else if (StringUtils.equals((CharSequence)orgType, (CharSequence)"HXBJ")) {
            companyCode = "BJ";
        } else if (StringUtils.equals((CharSequence)orgType, (CharSequence)"XTZZ")) {
            companyCode = "XT";
        } else if (StringUtils.equals((CharSequence)orgType, (CharSequence)"AHCG")) {
            companyCode = "AHCG";
        } else if (StringUtils.equals((CharSequence)orgType, (CharSequence)"DYWL")) {
            companyCode = "DYFST";
        } else if (StringUtils.equals((CharSequence)orgType, (CharSequence)"DKCG")) {
            companyCode = "HZ";
        }
        return companyCode + format.format(new Date()) + serialNumer;
    }
}

