/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.els.common.exception.ELSBootException;
import com.els.config.mybatis.TenantContext;
import com.els.modules.extend.api.common.util.ThirdPartyInterfaceUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ThirdPartyInterfaceUtilImpl
implements ThirdPartyInterfaceUtil {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyInterfaceUtilImpl.class);
    private static final Map<String, String> SYSTEM_CACHE = new HashMap<String, String>();
    @Value(value="${interface.config.url}")
    private String baseUrl;
    @Value(value="${interface.config.appKey}")
    private String appKey;
    @Value(value="${interface.config.appSecret}")
    private String appSecret;
    @Value(value="${interface.code.getOaToken}")
    private String getOaTokenCode;
    @Value(value="${interface.config.esb.clientId}")
    private String clientId;
    @Value(value="${interface.config.oa.oaGetToken}")
    private String oaGetToken;
    @Value(value="${interface.config.oa.appId}")
    private String appId;
    @Value(value="${interface.config.oa.secret}")
    private String secret;
    @Value(value="${interface.config.oa.spk}")
    private String spk;
    @Value(value="${interface.config.mdm.userName}")
    private String mdmUserName;
    @Value(value="${interface.config.mdm.pwd}")
    private String mdmUserPwd;
    @Value(value="${interface.code.srmGetMDMToken}")
    private String srmGetMDMToken;

    public static void main(String[] args) {
        Map<String, Object> regist = ThirdPartyInterfaceUtilImpl.regist("http://10.10.0.239");
        regist.forEach((x, y) -> System.out.println("x = " + x + " : " + y));
    }

    public static Map<String, Object> regist(String address) {
        RSA rsa = new RSA();
        String publicKey = rsa.getPublicKeyBase64();
        String privateKey = rsa.getPrivateKeyBase64();
        SYSTEM_CACHE.put("LOCAL_PRIVATE_KEY", privateKey);
        SYSTEM_CACHE.put("LOCAL_PUBLIC_KEY", publicKey);
        String data = ((HttpRequest)((HttpRequest)HttpRequest.post((String)(address + "/api/ec/dev/auth/regist")).header("appid", "ELS-CS")).header("cpk", publicKey)).timeout(2000).execute().body();
        System.out.println("testRegist()\uff1a" + data);
        JSONObject datas = JSONUtil.parseObj((String)data);
        SYSTEM_CACHE.put("SERVER_PUBLIC_KEY", StrUtil.nullToEmpty((CharSequence)((String)datas.get("spk"))));
        SYSTEM_CACHE.put("SERVER_SECRET", StrUtil.nullToEmpty((CharSequence)((String)datas.get("secrit"))));
        return datas;
    }

    public String geToken() {
        RSA rsa = new RSA(null, this.spk);
        log.info("SPK====" + this.spk);
        String encryptSecret = rsa.encryptBase64(this.secret, CharsetUtil.CHARSET_UTF_8, KeyType.PublicKey);
        HashMap<String, String> headParam = new HashMap<String, String>();
        headParam.put("appid", this.appId);
        headParam.put("secret", encryptSecret);
        headParam.put("time", "1800");
        headParam.put("OperationCode", this.oaGetToken);
        headParam.put("ClientId", this.clientId);
        com.alibaba.fastjson.JSONObject resultToken = this.callInterface(null, this.getOaTokenCode, headParam);
        if (!resultToken.getBoolean("success").booleanValue() || StringUtils.isBlank((CharSequence)resultToken.getJSONObject("result").getString("token"))) {
            if (resultToken.getInteger("code") == 200 && resultToken.getBoolean("success").booleanValue()) {
                com.alibaba.fastjson.JSONObject result = resultToken.getJSONObject("result");
                if (result != null) {
                    String errMsg = resultToken.getJSONObject("result").getString("msg");
                    log.error("\u83b7\u53d6token\u5931\u8d25\uff0c" + errMsg);
                    throw new ELSBootException("OA\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u5185\u5bb9\uff1a" + errMsg + "\uff0c\u8bf7\u8054\u7cfbOA\u7cfb\u7edf\u7ba1\u7406\u5458");
                }
                throw new ELSBootException("OA\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u5185\u5bb9\uff1a\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfbOA\u7cfb\u7edf\u7ba1\u7406\u5458");
            }
            throw new ELSBootException("\u63a5\u53e3\u5e73\u53f0\u9519\u8bef");
        }
        return resultToken.getJSONObject("result").getString("token");
    }

    public String RSAUserId(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw new ELSBootException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new RSA(null, this.spk).encryptBase64(userId, CharsetUtil.CHARSET_UTF_8, KeyType.PublicKey);
    }

    public String getMdmToken() {
        HashMap bodyMap = new HashMap();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("username", this.mdmUserName);
        body.put("password", this.mdmUserPwd);
        com.alibaba.fastjson.JSONObject result = this.callInterface(body, this.srmGetMDMToken, null);
        System.out.println("MDM\u8fd4\u56de\u7528\u6237\u4fe1\u606f==========dataJson:" + result.toString());
        com.alibaba.fastjson.JSONObject data = com.alibaba.fastjson.JSONObject.parseObject((String)result.get((Object)"result").toString());
        if (!data.containsKey((Object)"token")) {
            throw new RuntimeException("MDM\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u5185\u5bb9\uff1a" + result.getString("message") + "\uff0c\u8bf7\u8054\u7cfbMDM\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        }
        return data.getString("token").toString();
    }

    private com.alibaba.fastjson.JSONObject callInterface(Object bodyParam, String interfaceCode, Object headParam) {
        String elsAccount = TenantContext.getTenant();
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        if (bodyMap != null) {
            bodyMap.put("body", bodyParam);
        }
        if (headParam != null) {
            bodyMap.put("header_param", headParam);
        }
        bodyMap.put("bus_account", elsAccount);
        bodyMap.put("interface_code", interfaceCode);
        com.alibaba.fastjson.JSONObject dataJson = com.alibaba.fastjson.JSONObject.parseObject((String)com.alibaba.fastjson.JSONObject.toJSONString(bodyMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        System.out.println("\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570 \u89e3\u6790===" + dataJson.toJSONString());
        String result = ((HttpRequest)((HttpRequest)HttpRequest.post((String)(this.baseUrl + "/els/openApi/invoke")).header("key", this.appKey)).header("secret", this.appSecret)).body(dataJson.toJSONString()).execute().body();
        System.out.println("\u63a5\u53e3\u8fd4\u56de\u53c2\u6570 \u89e3\u6790===" + result);
        return com.alibaba.fastjson.JSONObject.parseObject((String)result);
    }
}

