/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.base.entity.BaseEntity;
import com.els.modules.system.entity.BackgroundFileTask;
import com.els.modules.system.enums.ExcelTaskTypeEnum;
import com.els.modules.system.enums.TaskStatusEnum;
import com.els.modules.system.mapper.BackgroundFileTaskMapper;
import com.els.modules.system.service.BackgroundFileTaskService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BackgroundFileTaskServiceImpl
extends ServiceImpl<BackgroundFileTaskMapper, BackgroundFileTask>
implements BackgroundFileTaskService {
    private static final Logger log = LoggerFactory.getLogger(BackgroundFileTaskServiceImpl.class);

    @Override
    public void saveImportTask(String excelBusinessOptType, String excelBusinessOptTypeName, String id, String elsAccount) {
        BackgroundFileTask task1 = (BackgroundFileTask)((Object)((BackgroundFileTaskMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (null != task1) {
            return;
        }
        BackgroundFileTask task = new BackgroundFileTask();
        task.setTaskName(CharSequenceUtil.isEmpty((CharSequence)excelBusinessOptTypeName) ? excelBusinessOptType : excelBusinessOptTypeName);
        task.setTaskType(ExcelTaskTypeEnum.IMPORT_ERROR.getCode());
        task.setTaskStatus("-1");
        task.setElsAccount(elsAccount);
        task.setTaskOptBusinessType(excelBusinessOptType);
        task.setId(id);
        this.save((Object)task);
    }

    @Override
    public void cleanTask() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, BackgroundFileTask::getTaskFilePath});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BackgroundFileTask::getTaskStatus, (Object)TaskStatusEnum.FAIL.getCode())).ge(BackgroundFileTask::getFailTimes, (Object)1)).gt(BackgroundFileTask::getExpirationTime, (Object)new Date());
        List backgroundFileTasks = ((BackgroundFileTaskMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)backgroundFileTasks)) {
            return;
        }
        ((BackgroundFileTaskMapper)this.baseMapper).deleteBatchIds(backgroundFileTasks.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        backgroundFileTasks.forEach(f -> FileUtil.del((String)f.getTaskFilePath()));
    }

    @Override
    public List<BackgroundFileTask> loadExcelImportRunTask() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, BackgroundFileTask::getFailTimes, BackgroundFileTask::getTaskType, BackgroundFileTask::getTaskName});
        ((LambdaQueryWrapper)wrapper.eq(BackgroundFileTask::getTaskStatus, (Object)Lists.newArrayList((Object[])new String[]{TaskStatusEnum.FAIL.getCode()}))).lt(BackgroundFileTask::getFailTimes, (Object)3);
        return ((BackgroundFileTaskMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public void deleteFileTask(String id) {
        BackgroundFileTask task = (BackgroundFileTask)((Object)((BackgroundFileTaskMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        ((BackgroundFileTaskMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        if (null == task || CharSequenceUtil.isBlank((CharSequence)task.getTaskFilePath())) {
            return;
        }
        try {
            FileUtil.del((String)task.getTaskFilePath());
        }
        catch (Exception e) {
            log.info("\u5220\u9664\u6587\u4ef6\u4efb\u52a1\u5931\u8d25:id:{},name:{}", (Object)task.getId(), (Object)task.getTaskName());
        }
    }
}

