/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.util.ExcelRedisKeyGenerateUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.exception.ELSExcelBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SqlInjectionUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.service.BackgroundFileTaskService;
import com.els.modules.system.util.ExcelGenerateRunner;
import com.els.modules.system.vo.ErrorExcelImportDataVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelDataListener
extends AnalysisEventListener<Map<Integer, String>> {
    private static final Logger log = LoggerFactory.getLogger(ExcelDataListener.class);
    private List<Map<String, Object>> importDataList = new ArrayList<Map<String, Object>>();
    private Map<String, Object> primaryMap = new HashMap<String, Object>(16);
    private List<ExcelDetail> excelDetailList;
    private List<String> fileHeadTitle;
    private int row = 0;
    private ExcelImportRpcService service;
    private InvokeBaseRpcService invokeBaseRpcService;
    private String dataKey;
    private String errorExcelKey;
    private final String excelBusinessOptType;
    private final String excelBusinessOptTypeName;
    private List<Map<String, Object>> otherSheetList;
    private final ErrorExcelImportDataVO errorExcelImportDataVO = new ErrorExcelImportDataVO();
    private final String elsAccount;
    private final ExcelByConfigDTO excelByConfigDTO;
    private long successCount;
    private long failCount;
    String errorTitle = I18nUtil.translate((String)"", (String)"\u9519\u8bef\u7ed3\u679c\u8bb0\u5f55");
    String errorStatus = I18nUtil.translate((String)"", (String)"\u5904\u7406\u72b6\u6001");

    public ExcelDataListener(ExcelImportRpcService service, List<ExcelDetail> excelDetailList, String dataKey, InvokeBaseRpcService invokeBaseRpcService, List<Map<String, Object>> otherSheetList, String excelBusinessOptType, String excelBusinessOptTypeName, String elsAccount, ExcelByConfigDTO excelByConfigDTO) {
        this.service = service;
        this.excelDetailList = excelDetailList;
        this.dataKey = dataKey;
        this.invokeBaseRpcService = invokeBaseRpcService;
        this.otherSheetList = otherSheetList;
        this.excelBusinessOptType = excelBusinessOptType;
        this.excelBusinessOptTypeName = excelBusinessOptTypeName;
        this.elsAccount = elsAccount;
        this.excelByConfigDTO = excelByConfigDTO;
    }

    public List<Map<String, Object>> getImportDataList() {
        return this.importDataList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDictValue(ExcelDetail detail, String val) {
        String dictCode = detail.getDataFormat();
        if (!dictCode.contains("#")) {
            if (!dictCode.contains(",")) return this.invokeBaseRpcService.queryDictCodeByText(dictCode, val, SysUtil.getLoginUser().getElsAccount());
        }
        String[] params = null;
        params = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
        if (params.length < 3) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JCWWWWmKxiR_bc91c337", (String)"\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e"));
        }
        String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
        SqlInjectionUtil.filterContent((String[])sqlInjCheck);
        if (params.length != 4) throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JCxzE_2d5d1760", (String)"\u5b57\u5178\u4e0d\u5339\u914d"));
        String filterSql = params[3] + " and " + params[1] + " = '" + val + "'";
        SqlInjectionUtil.filterContent((String)filterSql);
        return this.invokeBaseRpcService.queryTableDictItemsByValue(params[0], params[1], params[2], filterSql, val, SysUtil.getLoginUser().getElsAccount());
    }

    public void invoke(Map<Integer, String> data, AnalysisContext context) {
        ++this.row;
        if (this.row == 1) {
            this.fileHeadTitle = Lists.newArrayList(data.values());
            this.errorExcelImportDataVO.setExcelHead(this.fileHeadTitle);
            return;
        }
        int headRow = 2;
        if (this.row <= headRow) {
            this.errorExcelImportDataVO.setExcelHeadTip(Lists.newArrayList(data.values()));
            return;
        }
        HashMap newData = new HashMap(data.size());
        if (CollUtil.isNotEmpty(data)) {
            data.forEach((key, val) -> {
                String title = this.fileHeadTitle.get((int)key);
                newData.put(title, val);
            });
        }
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        StringBuilder primaryKey = new StringBuilder();
        boolean check = true;
        HashMap excelData = new HashMap();
        StringBuffer errorSb = new StringBuffer();
        for (ExcelDetail detail : this.excelDetailList) {
            String msg;
            String columnCode = detail.getColumnCode();
            String val2 = (String)newData.get(columnCode);
            if (StrUtil.isNotBlank((CharSequence)val2)) {
                if (ExcelDataTypeEnum.DICT.getCode().equals(detail.getDataType())) {
                    StringBuffer temVal = new StringBuffer("");
                    if (StrUtil.isNotBlank((CharSequence)val2) && val2.contains(",")) {
                        String[] split = val2.split(",");
                        for (int i = 0; i < split.length; ++i) {
                            String dictValue;
                            if (!StrUtil.isNotBlank((CharSequence)split[i]) || !StrUtil.isNotBlank((CharSequence)(dictValue = this.getDictValue(detail, split[i])))) continue;
                            temVal.append(dictValue).append(",");
                        }
                    } else {
                        temVal.append(this.getDictValue(detail, val2));
                    }
                    val2 = temVal.toString();
                    if (val2.endsWith(",")) {
                        val2 = val2.substring(0, val2.length() - 1);
                    }
                    if (StrUtil.isBlank((CharSequence)val2)) {
                        String msg2 = I18nUtil.translate((String)"i18n_alert_WWWWWWxMKUWFJCAoWWWWWWvLC_25bc7b9c", (String)"[${0}]\u4e0d\u5b58\u5728\u4e8e\u6570\u636e\u5b57\u5178\u7f16\u7801[${1}]\u8303\u56f4\u5185", (String[])new String[]{detail.getColumnName(), detail.getDataFormat()});
                        errorSb.append(msg2).append(";");
                        check = false;
                        continue;
                    }
                    dataMap.put(columnCode, val2);
                } else if (ExcelDataTypeEnum.DATE.getCode().equals(detail.getDataType())) {
                    if (detail.getDataFormat() == null || detail.getDataFormat().length() < 11) {
                        if (val2.length() > 0 && val2.length() < 11) {
                            msg = I18nUtil.translate((String)"i18n_alert_WWWWWWxBnWWWWWWjBAmKWWWWWWjPV_c3220484", (String)"[${0}]\u4e0d\u7b26\u5408[${1}]\u7684\u65e5\u671f\u683c\u5f0f[${2}]\u7684\u8981\u6c42", (String[])new String[]{val2, detail.getColumnName(), detail.getDataFormat()});
                            errorSb.append(msg).append(";");
                            check = false;
                            continue;
                        }
                        val2 = val2.substring(0, 10);
                        dataMap.put(columnCode, val2);
                    }
                } else if (ExcelDataTypeEnum.NUMBER.getCode().equals(detail.getDataType())) {
                    try {
                        Double dVal = Double.valueOf(val2);
                        BigDecimal bVal = BigDecimal.valueOf(dVal).setScale(4, 4);
                        dataMap.put(columnCode, bVal.stripTrailingZeros().toPlainString());
                    }
                    catch (NumberFormatException e) {
                        dataMap.put(detail.getColumnCode(), val2);
                    }
                } else {
                    dataMap.put(columnCode, val2);
                }
                if (CommonConstant.STATUS_YES.equals(detail.getPrimaryKey())) {
                    primaryKey.append(val2).append(",");
                }
            } else if (CommonConstant.STATUS_YES.equals(detail.getRequired())) {
                msg = I18nUtil.translate((String)"i18n_alert_WWWWWWKlSJOWxOLV_21cd61c7", (String)"[${0}]\u662f\u5fc5\u586b\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{detail.getColumnName()});
                errorSb.append(msg).append(";");
                check = false;
            }
            Object obj = dataMap.get(columnCode);
            String oldObj = (String)newData.get(columnCode);
            if ((null == obj || "".equals(obj.toString()) || "null".equals(obj.toString())) && null != oldObj && obj != oldObj) {
                dataMap.put(columnCode, oldObj);
            }
            excelData.put(columnCode, newData.get(columnCode));
        }
        if (StrUtil.isNotBlank((CharSequence)primaryKey.toString())) {
            if (this.primaryMap.containsKey(primaryKey.toString())) {
                String msg = I18nUtil.translate((String)"i18n_alert_WWWWWWLIIVB_47f1ecff", (String)"[${0}]\u552f\u4e00\u952e\u91cd\u590d", (String[])new String[]{primaryKey.toString()});
                if (CharSequenceUtil.isBlank((CharSequence)this.excelBusinessOptType)) {
                    throw new ELSBootException(msg);
                }
                errorSb.append(msg).append(";");
                check = false;
            } else {
                this.primaryMap.put(primaryKey.toString(), CommonConstant.STATUS_YES);
            }
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)this.excelBusinessOptType) && !check) {
            excelData.put(this.errorStatus, I18nUtil.translate((String)"", (String)"\u672a\u6267\u884c"));
            excelData.put(this.errorTitle, errorSb.toString());
            log.info(" #{} Excel\u5bfc\u5165\u5b58\u5728\u5f02\u5e38\u6570\u636e", (Object)this.excelBusinessOptType);
            this.errorExcelImportDataVO.getDataList().add(excelData);
            return;
        }
        if (dataMap.size() == 0) {
            return;
        }
        dataMap.put("els_account", this.elsAccount);
        this.importDataList.add(dataMap);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.fileHeadTitle = null;
        RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        if (CollUtil.isEmpty(this.importDataList)) {
            this.successCount = 0L;
            HashMap<String, Object> errorMap = new HashMap<String, Object>();
            errorMap.put("successCount", this.successCount);
            if (CharSequenceUtil.isNotBlank((CharSequence)this.excelBusinessOptType)) {
                String id = this.errorExcelGenerate(redisUtil);
                if (!this.errorExcelImportDataVO.getDataList().isEmpty()) {
                    this.errorExcelKey = id;
                    ((ExcelGenerateRunner)SpringContextUtils.getBean(ExcelGenerateRunner.class)).immediateExec(id, this.excelDetailList);
                    this.failCount = this.errorExcelImportDataVO.getDataList().size();
                    errorMap.put("errorId", this.errorExcelKey);
                    errorMap.put("failCount", this.failCount);
                    throw new ELSExcelBootException(I18nUtil.translate((String)"i18n_alert_uNIrjWFxqjWVImSKuN_65704043", (String)"\u5bfc\u5165\u6a21\u677f\u7684\u6570\u636e\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u5bfc\u5165"), errorMap);
                }
                this.errorExcelKey = null;
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_uNIrjWFxqjWVImSKuN_65704043", (String)"\u5bfc\u5165\u6a21\u677f\u7684\u6570\u636e\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u5bfc\u5165"));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)this.excelBusinessOptType)) {
            this.errorExcelKey = this.errorExcelGenerate(redisUtil);
        }
        ExcelImportDTO excelImportDTO = new ExcelImportDTO();
        excelImportDTO.setDataList(this.importDataList);
        excelImportDTO.setExcelBusinessOptType(this.excelBusinessOptType);
        excelImportDTO.setExcelBusinessOptTypeName(this.excelBusinessOptTypeName);
        excelImportDTO.setErrorExcelRunnerId(this.errorExcelKey);
        if (StrUtil.isBlank((CharSequence)this.dataKey)) {
            if (CollectionUtil.isNotEmpty(this.otherSheetList)) {
                HashMap<String, List<Map<String, Object>>> otherMap = new HashMap<String, List<Map<String, Object>>>();
                otherMap.put("otherSheetList", this.otherSheetList);
                this.importDataList.add(otherMap);
            }
            log.info("#doAfterAllAnalysed \u5373\u5c06\u6267\u884c\u5bfc\u5165\u6570\u636e\u7684\u903b\u8f91");
            excelImportDTO.setExcelByConfigDTO(this.excelByConfigDTO);
            this.importDataList = this.service.importExcel(excelImportDTO);
            if (CharSequenceUtil.isNotBlank((CharSequence)this.excelBusinessOptType) && CharSequenceUtil.isNotBlank((CharSequence)this.errorExcelKey)) {
                String key = ExcelRedisKeyGenerateUtil.generateImportKey((String)this.excelBusinessOptType, (String)this.elsAccount, (String)this.errorExcelKey);
                long mapLen = redisUtil.mapLen(key);
                if (mapLen > 2L) {
                    this.failCount = mapLen - 2L;
                    ((ExcelGenerateRunner)SpringContextUtils.getBean(ExcelGenerateRunner.class)).immediateExec(this.errorExcelKey, this.excelDetailList);
                } else {
                    ((BackgroundFileTaskService)SpringContextUtils.getBean(BackgroundFileTaskService.class)).deleteFileTask(this.errorExcelKey);
                    this.errorExcelKey = null;
                }
            }
            this.successCount = (Long)redisUtil.get(ExcelRedisKeyGenerateUtil.generateImportSuccessCountKey((String)this.excelBusinessOptType, (String)this.errorExcelKey));
        } else {
            log.info("doAfterAllAnalysed save importDataList to redis key:{}", (Object)this.dataKey);
            redisUtil.set(this.dataKey, (Object)excelImportDTO);
        }
    }

    private String errorExcelGenerate(RedisUtil redisUtil) {
        String idKey = IdWorker.getIdStr();
        String key = ExcelRedisKeyGenerateUtil.generateImportKey((String)this.excelBusinessOptType, (String)this.elsAccount, (String)idKey);
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        result.put("title", this.errorExcelImportDataVO.getExcelHead());
        result.put("titleTip", this.errorExcelImportDataVO.getExcelHeadTip());
        for (int i = 0; i < this.errorExcelImportDataVO.getDataList().size(); ++i) {
            result.put(String.valueOf(i), this.errorExcelImportDataVO.getDataList().get(i));
        }
        redisUtil.hmset(key, result, 259200L);
        String templateListKey = ExcelRedisKeyGenerateUtil.generateImportDetailKey((String)this.excelBusinessOptType, (String)idKey);
        redisUtil.set(templateListKey, this.excelDetailList, 260200L);
        if (this.errorExcelImportDataVO.getDataList().size() > 0) {
            log.info("#errorExcelGenerate  \u5bfc\u5165\u6a21\u677f\u6821\u9a8c\u65f6\u5019\u5b58\u5728\u9519\u8bef\u6570\u636e\uff0c\u4fdd\u5b58\u9519\u8bef\u8bb0\u5f55");
            BackgroundFileTaskService taskService = (BackgroundFileTaskService)SpringContextUtils.getBean(BackgroundFileTaskService.class);
            taskService.saveImportTask(this.excelBusinessOptType, this.excelBusinessOptTypeName, idKey, this.elsAccount);
        }
        return idKey;
    }

    public String getErrorExcelKey() {
        return this.errorExcelKey;
    }

    public long getSuccessCount() {
        return this.successCount;
    }

    public long getFailCount() {
        return this.failCount;
    }
}

