/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.handler.WriteHandler;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.excel.util.ExcelRedisKeyGenerateUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.exception.ELSExcelBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportCheckDTO;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.entity.ExcelHeader;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.enums.ExcelTemplateTypeEnum;
import com.els.modules.system.mapper.ExcelDetailMapper;
import com.els.modules.system.mapper.ExcelHeaderMapper;
import com.els.modules.system.rpc.service.BaseInvokeExcelImportRpcService;
import com.els.modules.system.service.BackgroundFileTaskService;
import com.els.modules.system.service.ExcelHeaderService;
import com.els.modules.system.util.ExcelCellStyleStrategy;
import com.els.modules.system.util.ExcelDataCheckListener;
import com.els.modules.system.util.ExcelDataListener;
import com.els.modules.system.util.ExcelDictWriteHandler;
import com.els.modules.system.util.ExcelGenerateRunner;
import com.els.modules.system.util.ExcelHeaderUtil;
import com.els.modules.system.vo.ExcelHeaderVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ExcelHeaderServiceImpl
extends ServiceImpl<ExcelHeaderMapper, ExcelHeader>
implements ExcelHeaderService {
    private static final Logger log = LoggerFactory.getLogger(ExcelHeaderServiceImpl.class);
    @Value(value="${els.path.upload}")
    private String uploadpath;
    @Resource
    private ExcelHeaderMapper excelHeaderMapper;
    @Resource
    private ExcelDetailMapper excelDetailMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    @Lazy
    private InvokeBaseRpcService invokeBaseRpcService;
    private final String LOCK_PREFIX = "excel_import_";
    private final long EXPIRE_TIME = 50000L;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(ExcelHeader excelHeader, List<ExcelDetail> excelDetailList) {
        this.excelHeaderMapper.insert((Object)excelHeader);
        int i = 1;
        for (ExcelDetail entity : excelDetailList) {
            entity.setExcelId(excelHeader.getId());
            entity.setColumnIndex(i);
            this.excelDetailMapper.insert((Object)entity);
            ++i;
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(ExcelHeader excelHeader, List<ExcelDetail> excelDetailList) {
        this.excelHeaderMapper.updateById((Object)excelHeader);
        this.excelDetailMapper.deleteByMainId(excelHeader.getId());
        int i = 1;
        for (ExcelDetail entity : excelDetailList) {
            entity.setExcelId(excelHeader.getId());
            entity.setColumnIndex(i);
            this.excelDetailMapper.insert((Object)entity);
            ++i;
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.excelDetailMapper.deleteByMainId(id);
        this.excelHeaderMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.excelDetailMapper.deleteByMainId(serializable.toString());
            this.excelHeaderMapper.deleteById(serializable);
        }
    }

    @Override
    public void getTemplate(HttpServletResponse res, String excelCode) {
        ExcelHeader excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, TenantContext.getTenant());
        if (excelHeader == null) {
            excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, "100000");
        }
        if (excelHeader == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u8bf7\u914d\u7f6e\u7f16\u7801[" + excelCode + "]\u7684Excel\u6a21\u677f")));
        }
        if (ExcelTemplateTypeEnum.FIXED.getCode().contentEquals(excelHeader.getTemplateType())) {
            this.getFixedTemplate(res, excelHeader);
        } else {
            this.getDynamicTemplate(res, excelHeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDynamicTemplate(HttpServletResponse res, ExcelHeader excelHeader) {
        List<ExcelDetail> detailList = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        OutputStream outputStream = null;
        try {
            List<Map<String, Object>> dataList = this.buildEmptyData(detailList, 1000);
            outputStream = res.getOutputStream();
            EasyExcel.write((OutputStream)outputStream).registerWriteHandler((WriteHandler)new ExcelCellStyleStrategy(detailList)).registerWriteHandler((WriteHandler)new ExcelDictWriteHandler(detailList, this.invokeBaseRpcService)).head(ExcelHeaderUtil.getHeaderList(detailList)).sheet("data").doWrite(dataList);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private List<Map<String, Object>> buildEmptyData(List<ExcelDetail> detailList, int length) {
        ArrayList objects = Lists.newArrayList();
        HashMap<String, String> data = new HashMap<String, String>();
        for (ExcelDetail detail : detailList) {
            if (!ExcelDataTypeEnum.STRING.getCode().equals(detail.getDataType()) && !ExcelDataTypeEnum.NUMBER.getCode().equals(detail.getDataType())) continue;
            data.put(detail.getColumnCode(), "");
        }
        if (data.size() == 0) {
            return objects;
        }
        for (int i = 0; i < length; ++i) {
            objects.add(data);
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFixedTemplate(HttpServletResponse res, ExcelHeader excelHeader) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        String filePath = excelHeader.getFixedTemplate();
        try {
            String localPath;
            String downloadFilePath;
            File file;
            res.setContentType("application/force-download");
            res.addHeader("Content-Disposition", "attachment;fileName=" + new String(excelHeader.getExcelName().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            filePath = filePath.replace("..", "");
            if (filePath.endsWith(",")) {
                filePath = filePath.substring(0, filePath.length() - 1);
            }
            if ((file = new File(downloadFilePath = (localPath = this.uploadpath) + File.separator + filePath)).exists()) {
                int len;
                inputStream = new BufferedInputStream(new FileInputStream(file));
                outputStream = res.getOutputStream();
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                    outputStream.flush();
                }
                res.flushBuffer();
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public static Workbook readExcel(File file, String Suffix) {
        HSSFWorkbook wb;
        block17: {
            XSSFWorkbook xSSFWorkbook;
            wb = null;
            if (file == null) {
                return null;
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                if ("xls".equals(Suffix)) {
                    HSSFWorkbook hSSFWorkbook = wb = new HSSFWorkbook((InputStream)is);
                    return hSSFWorkbook;
                }
                if (!"xlsx".equals(Suffix)) break block17;
                wb = new XSSFWorkbook((InputStream)is);
                xSSFWorkbook = wb;
            }
            catch (Exception e) {
                throw new ELSBootException(e.getMessage());
            }
            finally {
                if (null != is) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return xSSFWorkbook;
        }
        return wb;
    }

    public static LinkedHashSet<String> getTopRow(File file, String suffix) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Workbook wb = ExcelHeaderServiceImpl.readExcel(file, suffix);
        if (null == wb) {
            throw new ELSBootException("Create Sheet Error");
        }
        Sheet sheet = wb.getSheetAt(0);
        Row row = sheet.getRow(0);
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            String cellData = (String)ExcelHeaderServiceImpl.getCellFormatValue(row.getCell(i));
            result.add(cellData.replaceAll(" ", ""));
        }
        return result;
    }

    private static Object getCellFormatValue(Cell cell) {
        Object cellValue = null;
        if (cell != null) {
            CellType cellType = cell.getCellType();
            switch (cellType) {
                case NUMERIC: {
                    cell.setCellType(CellType.STRING);
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case FORMULA: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        cellValue = cell.getDateCellValue();
                        break;
                    }
                    cellValue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                case STRING: {
                    cellValue = cell.getRichStringCellValue().getString();
                    break;
                }
                default: {
                    cellValue = cell.getRichStringCellValue().getString();
                    break;
                }
            }
        } else {
            cellValue = "";
        }
        return cellValue;
    }

    private List<String> getExcelTitle(MultipartFile file) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Map<String, Object> importExcel(String excelCode, MultipartFile file, Map<String, Object> otherRequestParam) {
        ExcelHeader excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, TenantContext.getTenant());
        if (excelHeader == null) {
            excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, "100000");
        }
        List<ExcelDetail> detailList = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        ExcelImportRpcService service = ((BaseInvokeExcelImportRpcService)SpringContextUtils.getBean(BaseInvokeExcelImportRpcService.class)).getExcelImportRpcService(excelHeader.getImplBean());
        try (InputStream inputStream = file.getInputStream();){
            ExcelDataListener excelDataListener = new ExcelDataListener(service, detailList, null, this.invokeBaseRpcService, null, excelHeader.getExcelCode(), excelHeader.getExcelName(), TenantContext.getTenant(), null, otherRequestParam);
            EasyExcel.read((InputStream)inputStream, (ReadListener)excelDataListener).sheet().headRowNumber(Integer.valueOf(0)).doRead();
            HashMap<String, Object> errorMap = new HashMap<String, Object>();
            errorMap.put("successCount", excelDataListener.getSuccessCount());
            errorMap.put("failCount", excelDataListener.getFailCount());
            errorMap.put("errorId", excelDataListener.getErrorExcelKey());
            HashMap<String, Object> hashMap = errorMap;
            return hashMap;
        }
        catch (Exception e) {
            if (!(e instanceof ELSExcelBootException)) throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
            throw (ELSExcelBootException)e;
        }
    }

    @Override
    public List previewExcel(String dataKey, String excelCode, MultipartFile file) {
        ExcelHeader excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, TenantContext.getTenant());
        if (excelHeader == null) {
            excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, "100000");
        }
        List<ExcelDetail> detailList = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        ExcelImportRpcService service = ((BaseInvokeExcelImportRpcService)SpringContextUtils.getBean(BaseInvokeExcelImportRpcService.class)).getExcelImportRpcService(excelHeader.getImplBean());
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            ExcelDataListener excelDataListener = new ExcelDataListener(service, detailList, dataKey, this.invokeBaseRpcService, null, excelHeader.getExcelCode(), excelHeader.getExcelName(), TenantContext.getTenant(), null, null);
            EasyExcel.read((InputStream)inputStream, (ReadListener)excelDataListener).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(0)).doRead();
            ExcelImportDTO excelImportDTO = (ExcelImportDTO)this.redisUtil.get(dataKey);
            if (CollUtil.isEmpty((Collection)excelImportDTO.getDataList()) && CharSequenceUtil.isNotBlank((CharSequence)excelDataListener.getErrorExcelKey())) {
                HashMap<String, Object> errorMap = new HashMap<String, Object>();
                errorMap.put("errorExcelKey", excelImportDTO.getErrorExcelRunnerId());
                errorMap.put("successCount", excelDataListener.getSuccessCount());
                errorMap.put("failCount", excelDataListener.getFailCount());
                throw new ELSExcelBootException(I18nUtil.translate((String)"i18n_alert_uNIrjWFxqjWVImSKuN_65704043", (String)"\u5bfc\u5165\u6a21\u677f\u7684\u6570\u636e\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u5bfc\u5165"), errorMap);
            }
            List list = excelImportDTO.getDataList();
            return list;
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u9884\u89c8\u6570\u636e\u5f02\u5e38:{}", (Object)e.getMessage());
            if (e instanceof ELSExcelBootException) {
                throw (ELSExcelBootException)e;
            }
            throw new ELSBootException(e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Map<String, Object> importPreviewExcelData(String dataKey, String excelCode, Map<String, Object> otherRequestParam) {
        String requestId = dataKey;
        String lockKey = "excel_import_" + dataKey;
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        try {
            if (this.redisUtil.tryGetDistributedLock(lockKey, requestId, 50000L)) {
                ExcelHeader excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, TenantContext.getTenant());
                if (excelHeader == null) {
                    excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, "100000");
                }
                ExcelImportRpcService service = ((BaseInvokeExcelImportRpcService)SpringContextUtils.getBean(BaseInvokeExcelImportRpcService.class)).getExcelImportRpcService(excelHeader.getImplBean());
                ExcelImportDTO excelImportDTO = (ExcelImportDTO)this.redisUtil.get(dataKey);
                excelImportDTO.setOtherRequestParam(otherRequestParam);
                List result = service.importExcel(excelImportDTO);
                errorMap.put("successCount", null == result ? 0 : result.size());
                String key = ExcelRedisKeyGenerateUtil.generateImportKey((String)excelImportDTO.getExcelBusinessOptType(), (String)TenantContext.getTenant(), (String)excelImportDTO.getErrorExcelRunnerId());
                long mapLen = this.redisUtil.mapLen(key);
                this.redisUtil.del(new String[]{dataKey});
                if (mapLen > 2L) {
                    errorMap.put("failCount", mapLen - 2L);
                    errorMap.put("errorId", excelImportDTO.getErrorExcelRunnerId());
                    ((ExcelGenerateRunner)SpringContextUtils.getBean(ExcelGenerateRunner.class)).immediateExec(excelImportDTO.getErrorExcelRunnerId(), null);
                } else {
                    errorMap.put("failCount", 0);
                    ((BackgroundFileTaskService)SpringContextUtils.getBean(BackgroundFileTaskService.class)).deleteFileTask(excelImportDTO.getErrorExcelRunnerId());
                }
                HashMap<String, Object> hashMap = errorMap;
                return hashMap;
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFuNsWVSVBtk_f35bfc9d", (String)"\u6570\u636e\u5bfc\u5165\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c"));
        }
        finally {
            this.redisUtil.releaseDistributedLock(lockKey, requestId);
        }
    }

    @Override
    public ExcelHeaderVO getExcelConfig(QueryWrapper<ExcelHeader> queryWrapper) {
        ExcelHeader excelHeader = (ExcelHeader)((Object)((ExcelHeaderMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (excelHeader == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VWERuNIr_57fd0ad9", (String)"\u8bf7\u5148\u914d\u7f6e\u5bfc\u5165\u6a21\u677f"));
        }
        ExcelHeaderVO excelHeaderVO = new ExcelHeaderVO();
        BeanUtils.copyProperties((Object)((Object)excelHeader), (Object)((Object)excelHeaderVO));
        List<ExcelDetail> excelDetailList = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        excelHeaderVO.setExcelDetailList(excelDetailList);
        return excelHeaderVO;
    }

    @Override
    public ExcelHeaderVO getExcelConfig(String excelCode) {
        ExcelHeader excelHeader;
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(ExcelHeader::getExcelCode, (Object)excelCode)).orderByDesc(BaseEntity::getUpdateTime);
        List header = ((ExcelHeaderMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (header.size() > 1) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MKOmWWWWWIr_2fbe8b35", (String)"\u5b58\u5728\u591a\u4e2aExcel\u6a21\u677f"));
        }
        ExcelHeader excelHeader2 = excelHeader = header.isEmpty() ? null : (ExcelHeader)((Object)header.get(0));
        if (excelHeader == null) {
            queryWrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)"100000")).eq(ExcelHeader::getExcelCode, (Object)excelCode)).orderByDesc(BaseEntity::getUpdateTime);
            List excelHeaders = ((ExcelHeaderMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
            if (excelHeaders.isEmpty()) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VWERuNIr_57fd0ad9", (String)"\u8bf7\u5148\u914d\u7f6e\u5bfc\u5165\u6a21\u677f"));
            }
            if (header.size() > 1) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MKOmWWWWWIr_2fbe8b35", (String)"\u5b58\u5728\u591a\u4e2aExcel\u6a21\u677f"));
            }
            excelHeader = (ExcelHeader)((Object)excelHeaders.get(0));
            Assert.isTrue((excelHeader != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_VWERuNIr_57fd0ad9", (String)"\u8bf7\u5148\u914d\u7f6e\u5bfc\u5165\u6a21\u677f"));
        }
        ExcelHeaderVO excelHeaderVO = new ExcelHeaderVO();
        BeanUtils.copyProperties((Object)((Object)excelHeader), (Object)((Object)excelHeaderVO));
        List<ExcelDetail> excelDetailList = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        excelHeaderVO.setExcelDetailList(excelDetailList);
        return excelHeaderVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addToEnterprise(String id) {
        ExcelHeader excelHeader = (ExcelHeader)((Object)this.excelHeaderMapper.selectById((Serializable)((Object)id)));
        List<ExcelDetail> details = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        String subAccount = SysUtil.getLoginUser().getSubAccount();
        String elsAccount = TenantContext.getTenant();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"excel_code", (Object)excelHeader.getExcelCode());
        queryWrapper.eq((Object)"impl_bean", (Object)excelHeader.getImplBean());
        queryWrapper.eq((Object)"template_type", (Object)excelHeader.getTemplateType());
        List headers = this.excelHeaderMapper.selectList((Wrapper)queryWrapper);
        if (!headers.isEmpty()) {
            String oldId = ((ExcelHeader)((Object)headers.get(0))).getId();
            this.excelDetailMapper.deleteByMainId(oldId);
            this.excelHeaderMapper.deleteById((Serializable)((Object)oldId));
        }
        excelHeader.setId(null);
        excelHeader.setElsAccount(elsAccount);
        excelHeader.setCreateBy(subAccount);
        excelHeader.setUpdateBy(subAccount);
        excelHeader.setCreateTime(new Date());
        excelHeader.setUpdateTime(new Date());
        this.excelHeaderMapper.insert((Object)excelHeader);
        for (ExcelDetail detail : details) {
            detail.setId(null);
            detail.setExcelId(excelHeader.getId());
            detail.setElsAccount(elsAccount);
            detail.setCreateBy(subAccount);
            detail.setUpdateBy(subAccount);
            detail.setCreateTime(new Date());
            detail.setUpdateTime(new Date());
        }
        if (!details.isEmpty()) {
            this.excelDetailMapper.insertBatchSomeColumn(details);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExcelImportCheckDTO importExcelDataInteractive(String excelCode, MultipartFile file) {
        ExcelHeader excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, TenantContext.getTenant());
        if (excelHeader == null) {
            excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, "100000");
        }
        List<ExcelDetail> detailList = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        ExcelImportRpcService service = ((BaseInvokeExcelImportRpcService)SpringContextUtils.getBean(BaseInvokeExcelImportRpcService.class)).getExcelImportRpcService(excelHeader.getImplBean());
        try (InputStream inputStream = file.getInputStream();){
            ExcelDataCheckListener excelDataListener = new ExcelDataCheckListener(service, detailList, null, this.invokeBaseRpcService, null, TenantContext.getTenant());
            EasyExcel.read((InputStream)inputStream, (ReadListener)excelDataListener).sheet().headRowNumber(Integer.valueOf(0)).doRead();
            ExcelImportCheckDTO excelImportCheckDTO = excelDataListener.getCheckDTO();
            return excelImportCheckDTO;
        }
        catch (Exception e) {
            if (!(e instanceof ELSExcelBootException)) throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
            throw (ELSExcelBootException)e;
        }
    }

    @Override
    public ExcelImportCheckDTO importExcelPreviewDataInteractive(String dataKey, String excelCode) {
        ExcelHeader excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, TenantContext.getTenant());
        if (excelHeader == null) {
            excelHeader = ((ExcelHeaderMapper)this.baseMapper).selectByExcelCode(excelCode, "100000");
        }
        ExcelImportRpcService service = ((BaseInvokeExcelImportRpcService)SpringContextUtils.getBean(BaseInvokeExcelImportRpcService.class)).getExcelImportRpcService(excelHeader.getImplBean());
        ExcelImportDTO excelImportDTO = (ExcelImportDTO)this.redisUtil.get(dataKey);
        return service.interactiveCheck(excelImportDTO);
    }
}

