/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SqlInjectionUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.service.impl.ExcelItemExcelServiceImpl;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelDictWriteHandler
implements SheetWriteHandler,
CellWriteHandler {
    private static final Logger log = LoggerFactory.getLogger(ExcelDictWriteHandler.class);
    private String busAccount;
    private List<ExcelDetail> detailList;
    private InvokeBaseRpcService invokeBaseRpcService;
    private ExcelItemExcelServiceImpl excelItemExcelService;

    public ExcelDictWriteHandler(List<ExcelDetail> detailList, InvokeBaseRpcService invokeBaseRpcService) {
        this.detailList = detailList;
        this.invokeBaseRpcService = invokeBaseRpcService;
        this.busAccount = null;
    }

    public ExcelDictWriteHandler(List<ExcelDetail> detailList, InvokeBaseRpcService invokeBaseRpcService, ExcelItemExcelServiceImpl excelItemExcelService) {
        this.detailList = detailList;
        this.invokeBaseRpcService = invokeBaseRpcService;
        this.excelItemExcelService = excelItemExcelService;
        this.busAccount = null;
    }

    public ExcelDictWriteHandler(List<ExcelDetail> detailList, InvokeBaseRpcService invokeBaseRpcService, ExcelItemExcelServiceImpl excelItemExcelService, String busAccount) {
        this.detailList = detailList;
        this.invokeBaseRpcService = invokeBaseRpcService;
        this.excelItemExcelService = excelItemExcelService;
        this.busAccount = busAccount;
    }

    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        Sheet sheet = writeSheetHolder.getSheet();
        DataValidationHelper helper = sheet.getDataValidationHelper();
        int hiddenIndex = 1;
        for (ExcelDetail detail : this.detailList) {
            List dictList;
            int index = detail.getColumnIndex() - 1;
            if (!ExcelDataTypeEnum.DICT.getCode().equals(detail.getDataType())) continue;
            String busAccount = StringUtils.isBlank((CharSequence)this.busAccount) ? TenantContext.getTenant() : this.busAccount;
            String dictCode = detail.getDataFormat();
            if (dictCode.contains("#") || dictCode.contains(",")) {
                String[] params = null;
                params = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
                if (params.length < 3) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JCWWWWmKxiR_bc91c337", (String)"\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e"));
                }
                String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
                SqlInjectionUtil.filterContent((String[])sqlInjCheck);
                if (params.length != 4) throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JCxzE_2d5d1760", (String)"\u5b57\u5178\u4e0d\u5339\u914d"));
                String filterSql = params[3];
                SqlInjectionUtil.filterContent((String)filterSql);
                dictList = this.invokeBaseRpcService.queryTableDictListByFilterSql(busAccount, params[0], params[1], params[2], filterSql);
            } else {
                dictList = "permissionScope".equals(detail.getDataFormat()) ? this.invokeBaseRpcService.findOpenbusinessType() : this.invokeBaseRpcService.queryDictItemsByCode(detail.getDataFormat(), busAccount);
            }
            if (dictList.size() <= 0) continue;
            String[] values = new String[dictList.size()];
            for (int i = 0; i < dictList.size(); ++i) {
                values[i] = ((DictDTO)dictList.get(i)).getText();
            }
            String hiddenSheet = "selectTypeList_" + hiddenIndex++;
            this.generateListSheet(writeWorkbookHolder, hiddenSheet, values, 2, index);
            DataValidation sheetDataValidation = this.buildSheetDataValidation(helper, hiddenSheet, 2, 10000, index, index);
            writeWorkbookHolder.getWorkbook().setSheetHidden(Integer.parseInt(hiddenSheet.split("_")[1]), true);
            sheet.addValidationData(sheetDataValidation);
        }
        if (this.excelItemExcelService == null) return;
        ExcelItemExcelServiceImpl.SHEET_NUMBER.set(hiddenIndex);
    }

    public DataValidation buildSheetDataValidation(DataValidationHelper helper, String sheetName, int firstRow, int endRow, int firstCol, int endCol) {
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        DataValidationConstraint formulaListConstraint = helper.createFormulaListConstraint(sheetName);
        return helper.createValidation(formulaListConstraint, regions);
    }

    public void generateListSheet(WriteWorkbookHolder holder, String sheetName, String[] typeList, int row, int cell) {
        Workbook wb = holder.getWorkbook();
        Sheet sheet = wb.getSheet(sheetName);
        if (null == sheet) {
            sheet = wb.createSheet(sheetName);
        }
        for (int i = 0; i < typeList.length; ++i) {
            sheet.createRow(row + i).createCell(cell).setCellValue(typeList[i]);
        }
        Name hiddenSheet = wb.getName(sheetName);
        if (null == hiddenSheet) {
            hiddenSheet = wb.createName();
            hiddenSheet.setNameName(sheetName);
        }
        String col = ExcelDictWriteHandler.getCellFormat(cell + 1);
        try {
            col = col.replaceAll("[A-Z]@", "Z");
            hiddenSheet.setRefersToFormula(sheetName + "!$" + col + "$2:$" + col + "$" + (typeList.length + 2));
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public static String getCellFormat(int cell) {
        String result = "";
        int multiple = Math.floorDiv(cell, 26);
        int mod = cell % 26;
        if (mod == 0 && multiple == 1) {
            result = (char)(mod + 90) + result;
            return result;
        }
        result = (char)(mod + 65 - 1) + result;
        if (multiple == 0) {
            return result;
        }
        return ExcelDictWriteHandler.getCellFormat(multiple) + result;
    }

    public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer integer, Integer integer1, Boolean aBoolean) {
    }

    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer integer, Boolean aBoolean) {
        Workbook workbook = writeSheetHolder.getSheet().getWorkbook();
        CellStyle cellStyle = workbook.createCellStyle();
        DataFormat dataFormat = workbook.createDataFormat();
        cellStyle.setDataFormat(dataFormat.getFormat("@"));
        cell.setCellStyle(cellStyle);
    }

    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<CellData> list, Cell cell, Head head, Integer integer, Boolean aBoolean) {
    }
}

