/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.executor;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.excel.context.WriteContext;
import com.alibaba.excel.enums.HeadKindEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.util.ClassUtils;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.WorkBookUtil;
import com.alibaba.excel.util.WriteHandlerUtils;
import com.alibaba.excel.write.executor.AbstractExcelWriteExecutor;
import com.alibaba.excel.write.metadata.holder.WriteHolder;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelWriteAddExecutor
extends AbstractExcelWriteExecutor {
    private static final Logger log = LoggerFactory.getLogger(ExcelWriteAddExecutor.class);

    public ExcelWriteAddExecutor(WriteContext writeContext) {
        super(writeContext);
    }

    public void add(List data) {
        log.error("\u6e90\u7801:" + data.size());
        if (CollectionUtils.isEmpty((Collection)data)) {
            return;
        }
        WriteSheetHolder writeSheetHolder = this.writeContext.writeSheetHolder();
        int newRowIndex = writeSheetHolder.getNewRowIndexAndStartDoWrite();
        if (writeSheetHolder.isNew() && !writeSheetHolder.getExcelWriteHeadProperty().hasHead()) {
            newRowIndex += this.writeContext.currentWriteHolder().relativeHeadRowIndex();
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (int relativeRowIndex = 0; relativeRowIndex < data.size(); ++relativeRowIndex) {
            int n = relativeRowIndex + newRowIndex;
            this.addOneRowOfDataToExcel(data.get(relativeRowIndex), n, relativeRowIndex, fieldList);
        }
    }

    private void addOneRowOfDataToExcel(Object oneRowData, int n, int relativeRowIndex, List<Field> fieldList) {
        if (oneRowData == null) {
            return;
        }
        WriteHandlerUtils.beforeRowCreate((WriteContext)this.writeContext, (Integer)n, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
        Row row = WorkBookUtil.createRow((Sheet)this.writeContext.writeSheetHolder().getSheet(), (int)n);
        WriteHandlerUtils.afterRowCreate((WriteContext)this.writeContext, (Row)row, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
        if (oneRowData instanceof List) {
            this.addBasicTypeToExcel((List)oneRowData, row, relativeRowIndex);
        } else {
            log.error("JavaObject");
            this.addJavaObjectToExcel(oneRowData, row, relativeRowIndex, fieldList);
        }
        WriteHandlerUtils.afterRowDispose((WriteContext)this.writeContext, (Row)row, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
    }

    private void addBasicTypeToExcel(List<Object> oneRowData, Row row, int relativeRowIndex) {
        if (CollectionUtils.isEmpty(oneRowData)) {
            return;
        }
        Map headMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getHeadMap();
        int dataIndex = 0;
        int cellIndex = 0;
        for (Map.Entry entry : headMap.entrySet()) {
            if (dataIndex >= oneRowData.size()) {
                return;
            }
            cellIndex = (Integer)entry.getKey();
            Head head = (Head)entry.getValue();
            this.doAddBasicTypeToExcel(oneRowData, head, row, relativeRowIndex, dataIndex++, cellIndex);
        }
        if (dataIndex >= oneRowData.size()) {
            return;
        }
        if (cellIndex != 0) {
            ++cellIndex;
        }
        int size = oneRowData.size() - dataIndex;
        for (int i = 0; i < size; ++i) {
            this.doAddBasicTypeToExcel(oneRowData, null, row, relativeRowIndex, dataIndex++, cellIndex++);
        }
    }

    private void doAddBasicTypeToExcel(List<Object> oneRowData, Head head, Row row, int relativeRowIndex, int dataIndex, int cellIndex) {
        if (this.writeContext.currentWriteHolder().ignore(null, Integer.valueOf(cellIndex))) {
            return;
        }
        WriteHandlerUtils.beforeCellCreate((WriteContext)this.writeContext, (Row)row, (Head)head, (Integer)cellIndex, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
        Cell cell = WorkBookUtil.createCell((Row)row, (int)cellIndex);
        WriteHandlerUtils.afterCellCreate((WriteContext)this.writeContext, (Cell)cell, (Head)head, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
        Object value = oneRowData.get(dataIndex);
        CellData cellData = this.converterAndSet(this.writeContext.currentWriteHolder(), value == null ? null : value.getClass(), cell, value, null);
        WriteHandlerUtils.afterCellDispose((WriteContext)this.writeContext, (CellData)cellData, (Cell)cell, (Head)head, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
    }

    private void addJavaObjectToExcel(Object oneRowData, Row row, int relativeRowIndex, List<Field> fieldList) {
        Object value;
        log.error("className:" + oneRowData.getClass().getName());
        WriteHolder currentWriteHolder = this.writeContext.currentWriteHolder();
        HashMap beanMap = null;
        if (oneRowData instanceof JSONObject) {
            log.error("JSONObject");
            beanMap = new HashMap();
            BeanUtil.copyProperties((Object)oneRowData, beanMap, (String[])new String[0]);
        } else {
            beanMap = oneRowData instanceof HashMap ? (HashMap)oneRowData : BeanMap.create((Object)oneRowData);
        }
        log.error("beanMap:" + ((Object)beanMap).toString());
        HashSet<String> beanMapHandledSet = new HashSet<String>();
        int cellIndex = 0;
        if (HeadKindEnum.CLASS.equals((Object)this.writeContext.currentWriteHolder().excelWriteHeadProperty().getHeadKind())) {
            Map headMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getHeadMap();
            Map contentPropertyMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getContentPropertyMap();
            for (Map.Entry entry : contentPropertyMap.entrySet()) {
                cellIndex = (Integer)entry.getKey();
                ExcelContentProperty excelContentProperty = (ExcelContentProperty)entry.getValue();
                String name = excelContentProperty.getField().getName();
                if (this.writeContext.currentWriteHolder().ignore(name, Integer.valueOf(cellIndex)) || !beanMap.containsKey(name)) continue;
                Head head = (Head)headMap.get(cellIndex);
                WriteHandlerUtils.beforeCellCreate((WriteContext)this.writeContext, (Row)row, (Head)head, (Integer)cellIndex, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
                Cell cell = WorkBookUtil.createCell((Row)row, (int)cellIndex);
                WriteHandlerUtils.afterCellCreate((WriteContext)this.writeContext, (Cell)cell, (Head)head, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
                value = beanMap.get(name);
                CellData cellData = this.converterAndSet(currentWriteHolder, excelContentProperty.getField().getType(), cell, value, excelContentProperty);
                WriteHandlerUtils.afterCellDispose((WriteContext)this.writeContext, (CellData)cellData, (Cell)cell, (Head)head, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
                beanMapHandledSet.add(name);
            }
        }
        if (beanMapHandledSet.size() == beanMap.size()) {
            return;
        }
        if (cellIndex != 0) {
            ++cellIndex;
        }
        Map ignoreMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getIgnoreMap();
        Map headMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getHeadMap();
        for (Map.Entry entry : headMap.entrySet()) {
            boolean uselessData;
            Head head = (Head)entry.getValue();
            int columnIndex = (Integer)entry.getKey();
            String filedName = (String)head.getHeadNameList().get(0);
            boolean bl = uselessData = !beanMap.containsKey(filedName) || beanMapHandledSet.contains(filedName) || ignoreMap.containsKey(filedName) || this.writeContext.currentWriteHolder().ignore(filedName, Integer.valueOf(cellIndex));
            if (uselessData) continue;
            value = beanMap.get(filedName);
            WriteHandlerUtils.beforeCellCreate((WriteContext)this.writeContext, (Row)row, null, (Integer)cellIndex, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
            Cell cell = WorkBookUtil.createCell((Row)row, (int)cellIndex++);
            WriteHandlerUtils.afterCellCreate((WriteContext)this.writeContext, (Cell)cell, null, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
            CellData cellData = this.converterAndSet(currentWriteHolder, value == null ? null : value.getClass(), cell, value, null);
            WriteHandlerUtils.afterCellDispose((WriteContext)this.writeContext, (CellData)cellData, (Cell)cell, null, (Integer)relativeRowIndex, (Boolean)Boolean.FALSE);
        }
    }

    private void initFieldList(Class clazz, List<Field> fieldList) {
        if (!fieldList.isEmpty()) {
            return;
        }
        ClassUtils.declaredFields((Class)clazz, fieldList, (Boolean)this.writeContext.writeWorkbookHolder().getWriteWorkbook().getConvertAllFiled());
    }
}

