/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.excel.poi.excel.ExcelImportUtil;
import com.els.common.excel.poi.excel.entity.ExportParams;
import com.els.common.excel.poi.excel.entity.ImportParams;
import com.els.common.excel.poi.excel.view.ELSEntityExcelView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportCheckDTO;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.entity.ExcelHeader;
import com.els.modules.system.service.ExcelDetailService;
import com.els.modules.system.service.ExcelHeaderService;
import com.els.modules.system.vo.ExcelHeaderVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/base/excelHeader"})
@Api(tags={"Excel\u914d\u7f6e"})
public class ExcelHeaderController
extends BaseController<ExcelHeader, ExcelHeaderService> {
    private static final Logger log = LoggerFactory.getLogger(ExcelHeaderController.class);
    @Autowired
    private ExcelHeaderService excelHeaderService;
    @Autowired
    private ExcelDetailService excelDetailService;
    private final String EXCEL_DATA_KEY_PREFIX = "excel_data_key_";

    @AutoLog(value="Excel\u914d\u7f6e(\u4f01\u4e1a\u7ea7)-\u5206\u9875\u5217\u8868\u67e5\u8be2", operateType=1)
    @ApiOperation(value="Excel\u914d\u7f6e-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="Excel\u914d\u7f6e-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ExcelHeader excelHeader, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)excelHeader), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.excelHeaderService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="Excel\u914d\u7f6e(\u5e73\u53f0\u7ea7)-\u5206\u9875\u5217\u8868\u67e5\u8be2", operateType=1)
    @ApiOperation(value="Excel\u914d\u7f6e-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="Excel\u914d\u7f6e-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/listSys"})
    public Result<?> querySysPageList(ExcelHeader excelHeader, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)excelHeader), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.excelHeaderService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u83b7\u53d6\u914d\u7f6e", operateType=1)
    @ApiOperation(value="Excel\u914d\u7f6e-\u83b7\u53d6\u914d\u7f6e", notes="Excel\u914d\u7f6e-\u83b7\u53d6\u914d\u7f6e")
    @GetMapping(value={"/getConfig/{excelCode}"})
    public Result<?> getConfig(@PathVariable(value="excelCode") String excelCode) {
        ExcelHeaderVO excelHeaderVO = this.excelHeaderService.getExcelConfig(excelCode);
        return Result.ok((Object)((Object)excelHeaderVO));
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u6839\u636eExcelCode\u83b7\u53d6\u914d\u7f6e", operateType=1)
    @PostMapping(value={"/previewExcelData/{excelCode}"})
    public Result<?> previewExcelData(HttpServletRequest request, @PathVariable(value="excelCode") String excelCode) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            String dataKey = "excel_data_key_" + UUID.fastUUID().toString();
            List dataList = this.excelHeaderService.previewExcel(dataKey, excelCode, file);
            data.put("dataKey", dataKey);
            data.put("dataList", dataList);
        }
        return Result.ok(data);
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u6839\u636eExcelCode\u548cdataKey\u83b7\u53d6\u914d\u7f6e", operateType=1)
    @PostMapping(value={"/importPreviewExcelData/{excelCode}/{dataKey}"})
    public Result<?> importPreviewExcelData(@PathVariable(value="excelCode") String excelCode, @PathVariable(value="dataKey") String dataKey, @RequestBody Map<String, Object> otherRequestParam) {
        Map<String, Object> result = this.excelHeaderService.importPreviewExcelData(dataKey, excelCode, otherRequestParam);
        String msg = "";
        msg = result.containsKey("errorId") ? I18nUtil.translate((String)"", (String)"\u90e8\u5206\u6570\u636e\u5bfc\u5165\u6210\u529f\uff0c\u5f02\u5e38\u6570\u636e\u8bf7\u81ea\u884c\u4e0b\u8f7d\u67e5\u770b\uff01") : I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f");
        return Result.ok((String)msg, result);
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u6dfb\u52a0", operateType=2)
    @ApiOperation(value="Excel\u914d\u7f6e-\u6dfb\u52a0", notes="Excel\u914d\u7f6e-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ExcelHeaderVO excelHeaderPage) {
        ExcelHeader excelHeader = new ExcelHeader();
        BeanUtils.copyProperties((Object)((Object)excelHeaderPage), (Object)((Object)excelHeader));
        Assert.isNotBlank((String)excelHeader.getExcelCode(), (String)I18nUtil.translate((String)"i18n_title_pleaseInputTemplateCode", (String)"\u8bf7\u8f93\u5165\u6a21\u677f\u7f16\u7801"));
        Assert.isNotBlank((String)excelHeader.getExcelName(), (String)I18nUtil.translate((String)"i18n_title_enterATemplateName", (String)"\u8bf7\u8f93\u5165\u6a21\u677f\u540d\u79f0"));
        Assert.isNotBlank((String)excelHeader.getImplBean(), (String)I18nUtil.translate((String)"i18n_title_pleaseEnterImplementClass", (String)"\u8bf7\u8f93\u5165\u5b9e\u73b0\u7c7b\uff01"));
        Assert.isNotBlank((String)excelHeader.getTemplateType(), (String)I18nUtil.translate((String)"i18n_title_inputTemplateType", (String)"\u8bf7\u8f93\u5165\u6a21\u677f\u7c7b\u578b"));
        this.excelHeaderService.saveMain(excelHeader, excelHeaderPage.getExcelDetailList());
        return Result.ok((Object)((Object)excelHeader));
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u7f16\u8f91", operateType=3)
    @ApiOperation(value="Excel\u914d\u7f6e-\u7f16\u8f91", notes="Excel\u914d\u7f6e-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ExcelHeaderVO excelHeaderPage) {
        ExcelHeader excelHeader = new ExcelHeader();
        BeanUtils.copyProperties((Object)((Object)excelHeaderPage), (Object)((Object)excelHeader));
        Assert.isNotBlank((String)excelHeader.getExcelCode(), (String)I18nUtil.translate((String)"i18n_title_pleaseInputTemplateCode", (String)"\u8bf7\u8f93\u5165\u6a21\u677f\u7f16\u7801"));
        Assert.isNotBlank((String)excelHeader.getExcelName(), (String)I18nUtil.translate((String)"i18n_title_enterATemplateName", (String)"\u8bf7\u8f93\u5165\u6a21\u677f\u540d\u79f0"));
        Assert.isNotBlank((String)excelHeader.getImplBean(), (String)I18nUtil.translate((String)"i18n_title_pleaseEnterImplementClass", (String)"\u8bf7\u8f93\u5165\u5b9e\u73b0\u7c7b"));
        Assert.isNotBlank((String)excelHeader.getTemplateType(), (String)I18nUtil.translate((String)"i18n_title_inputTemplateType", (String)"\u8bf7\u8f93\u5165\u6a21\u677f\u7c7b\u578b"));
        this.excelHeaderService.updateMain(excelHeader, excelHeaderPage.getExcelDetailList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5c06100000\u53f7\u7684Excel\u914d\u7f6e\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7-\u6dfb\u52a0", operateType=2)
    @ApiOperation(value="\u5c06100000\u53f7\u7684Excel\u914d\u7f6e\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7-\u6dfb\u52a0", notes="\u5c06100000\u53f7\u7684Excel\u914d\u7f6e\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7-\u6dfb\u52a0")
    @GetMapping(value={"/addToEnterprise"})
    public Result<?> addToEnterprise(@RequestParam(value="id") String id) {
        this.excelHeaderService.addToEnterprise(id);
        return Result.ok((Object)2);
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664", operateType=4)
    @ApiOperation(value="Excel\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664", notes="Excel\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.excelHeaderService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u6279\u91cf\u5220\u9664", operateType=4)
    @ApiOperation(value="Excel\u914d\u7f6e-\u6279\u91cf\u5220\u9664", notes="Excel\u914d\u7f6e-\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.excelHeaderService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u901a\u8fc7id\u67e5\u8be2", operateType=1)
    @ApiOperation(value="Excel\u914d\u7f6e-\u901a\u8fc7id\u67e5\u8be2", notes="Excel\u914d\u7f6e-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ExcelHeader excelHeader = (ExcelHeader)((Object)this.excelHeaderService.getById((Serializable)((Object)id)));
        ExcelHeaderVO excelHeaderVO = new ExcelHeaderVO();
        BeanUtils.copyProperties((Object)((Object)excelHeader), (Object)((Object)excelHeaderVO));
        List<ExcelDetail> excelDetailList = this.excelDetailService.selectByMainId(id);
        excelHeaderVO.setExcelDetailList(excelDetailList);
        return Result.ok((Object)((Object)excelHeaderVO));
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u901a\u8fc7Excel\u914d\u7f6eid\u67e5\u8be2Excel\u914d\u7f6e\u660e\u7ec6", operateType=1)
    @ApiOperation(value="Excel\u914d\u7f6e-\u901a\u8fc7Excel\u914d\u7f6eid\u67e5\u8be2Excel\u914d\u7f6e\u660e\u7ec6", notes="Excel\u914d\u7f6e-\u901a\u8fc7Excel\u914d\u7f6eid\u67e5\u8be2Excel\u914d\u7f6e\u660e\u7ec6")
    @GetMapping(value={"/queryExcelDetailByMainId"})
    public Result<?> queryExcelDetailListByMainId(@RequestParam(name="id") String id) {
        List<ExcelDetail> excelDetailList = this.excelDetailService.selectByMainId(id);
        return Result.ok(excelDetailList);
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u4e0b\u8f7d\u6a21\u677f", operateType=6)
    @GetMapping(value={"/downloadTemplate"})
    public void downloadTemplate(HttpServletResponse res, ExcelHeader excelHeader) {
        this.excelHeaderService.getTemplate(res, excelHeader.getExcelCode());
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u901a\u8fc7excel\u6a21\u677f\u5bfc\u5165\u6570\u636e", operateType=5)
    @PostMapping(value={"/importExcelData/{excelCode}"})
    public Result<?> importExcelData(HttpServletRequest request, @PathVariable(value="excelCode") String excelCode, @RequestBody Map<String, Object> otherRequestParam) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<Map<String, Object>> ids = new ArrayList<Map<String, Object>>();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            Map<String, Object> errorMap = this.excelHeaderService.importExcel(excelCode, file, otherRequestParam);
            ids.add(errorMap);
        }
        return Result.ok(ids);
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u5bfc\u5165\u540e\u7aef\u6570\u636e\u4ea4\u4e92", operateType=5)
    @PostMapping(value={"/importExcelDataInteractive/{excelCode}"})
    public Result<?> importExcelDataInteractive(HttpServletRequest request, @PathVariable(value="excelCode") String excelCode) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ExcelImportCheckDTO> result = new ArrayList<ExcelImportCheckDTO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ExcelImportCheckDTO checkDTO = this.excelHeaderService.importExcelDataInteractive(excelCode, file);
            result.add(checkDTO);
        }
        return Result.ok(result);
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u5bfc\u5165\u540e\u7aef\u6570\u636e\u4ea4\u4e92", operateType=5)
    @PostMapping(value={"/importExcelPreviewDataInteractive/{excelCode}/{dataKey}"})
    public Result<?> importExcelPreviewDataInteractive(@PathVariable(value="excelCode") String excelCode, @PathVariable(value="dataKey") String dataKey) {
        ExcelImportCheckDTO checkDTO = this.excelHeaderService.importExcelPreviewDataInteractive(dataKey, excelCode);
        return Result.ok((Object)checkDTO);
    }

    @AutoLog(value="Excel\u914d\u7f6e-\u5bfc\u51faExcel", operateType=6)
    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, ExcelHeader excelHeader) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)excelHeader), (Map)request.getParameterMap());
        LoginUser sysUser = SysUtil.getLoginUser();
        ArrayList<ExcelHeaderVO> pageList = new ArrayList<ExcelHeaderVO>();
        List excelHeaderList = this.excelHeaderService.list((Wrapper)queryWrapper);
        for (ExcelHeader temp : excelHeaderList) {
            ExcelHeaderVO vo = new ExcelHeaderVO();
            BeanUtils.copyProperties((Object)((Object)temp), (Object)((Object)vo));
            List<ExcelDetail> excelDetailList = this.excelDetailService.selectByMainId(temp.getId());
            vo.setExcelDetailList(excelDetailList);
            pageList.add(vo);
        }
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"Excel\u914d\u7f6e");
        mv.addObject("entity", ExcelHeaderVO.class);
        mv.addObject("params", (Object)new ExportParams("Excel\u914d\u7f6e\u6570\u636e", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "Excel\u914d\u7f6e", request.getParameter("defineColumnCode")));
        mv.addObject("data", pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoLog(value="Excel\u914d\u7f6e-\u5bfc\u5165Excel", operateType=5)
    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), ExcelHeaderVO.class, (ImportParams)params);
                for (ExcelHeaderVO page : list) {
                    ExcelHeader po = new ExcelHeader();
                    BeanUtils.copyProperties((Object)((Object)page), (Object)((Object)po));
                    this.excelHeaderService.saveMain(po, page.getExcelDetailList());
                }
                Result result = Result.ok((String)(I18nUtil.translate((String)"i18n_alert_QIuNLRWWFcWW_d62b9dbe", (String)"\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570:") + list.size()));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)(I18nUtil.translate((String)"i18n_alert_QIuNKmW_af2c5e2e", (String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:") + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException iOException) {}
            }
        }
        return Result.error((String)I18nUtil.translate((String)"i18n__QIuNKmW_af2d5cf5", (String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25!"));
    }
}

