/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integrated.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.integrated.entity.IntegratedNodes;
import com.els.modules.integrated.entity.IntegratedParamsHead;
import com.els.modules.integrated.entity.IntegratedParamsItem;
import com.els.modules.integrated.mapper.IntegratedNodesMapper;
import com.els.modules.integrated.service.IntegratedNodesService;
import com.els.modules.integrated.service.IntegratedParamsHeadService;
import com.els.modules.integrated.service.IntegratedParamsItemService;
import com.els.modules.integrated.vo.IntegratedNodesVO;
import com.els.modules.language.service.I18nService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class IntegratedNodesServiceImpl
extends BaseServiceImpl<IntegratedNodesMapper, IntegratedNodes>
implements IntegratedNodesService {
    @Autowired
    private IntegratedParamsHeadService integratedParamsHeadService;
    @Autowired
    private IntegratedParamsItemService integratedParamsItemService;
    @Autowired
    private I18nService i18nService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(IntegratedNodes integratedNodes, List<IntegratedParamsHead> integratedParamsHeadList, List<IntegratedParamsItem> integratedParamsItemList) {
        ((IntegratedNodesMapper)this.baseMapper).insert((Object)integratedNodes);
        super.setHeadDefaultValue((BaseEntity)integratedNodes);
        this.insertData(integratedNodes, integratedParamsHeadList, integratedParamsItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(IntegratedNodes integratedNodes, List<IntegratedParamsHead> integratedParamsHeadList, List<IntegratedParamsItem> integratedParamsItemList) {
        int count;
        if (StringUtils.isBlank((CharSequence)integratedNodes.getBusinessTypeI18nKey())) {
            String s = this.i18nService.checkAndAdd(integratedNodes.getBusinessTypeName());
            integratedNodes.setBusinessTypeI18nKey(s);
        }
        Assert.isTrue(((count = ((IntegratedNodesMapper)this.baseMapper).updateById((Object)integratedNodes)) != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.integratedParamsHeadService.deleteByMainId(integratedNodes.getId());
        this.integratedParamsItemService.deleteByMainId(integratedNodes.getId());
        this.insertData(integratedNodes, integratedParamsHeadList, integratedParamsItemList);
    }

    private void insertData(IntegratedNodes integratedNodes, List<IntegratedParamsHead> integratedParamsHeadList, List<IntegratedParamsItem> integratedParamsItemList) {
        Map<String, String> stringMap;
        List<String> collect;
        if (!CollectionUtils.isEmpty(integratedParamsHeadList)) {
            collect = integratedParamsHeadList.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getFieldLabelI18nKey())).map(IntegratedParamsHead::getFieldLabel).collect(Collectors.toList());
            stringMap = this.i18nService.checkAndAdd(collect);
            for (IntegratedParamsHead integratedParamsHead : integratedParamsHeadList) {
                integratedParamsHead.setId(null);
                integratedParamsHead.setIntegratedNodesId(integratedNodes.getId());
                SysUtil.setSysParam((BaseEntity)integratedParamsHead, (BaseEntity)integratedNodes);
                if (!StringUtils.isBlank((CharSequence)integratedParamsHead.getFieldLabelI18nKey()) || !stringMap.containsKey(integratedParamsHead.getFieldLabel())) continue;
                integratedParamsHead.setFieldLabelI18nKey(stringMap.get(integratedParamsHead.getFieldLabel()));
            }
            this.integratedParamsHeadService.saveBatch(integratedParamsHeadList, 2000);
        }
        if (!CollectionUtils.isEmpty(integratedParamsItemList)) {
            collect = integratedParamsHeadList.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getFieldLabelI18nKey())).map(IntegratedParamsHead::getFieldLabel).collect(Collectors.toList());
            stringMap = this.i18nService.checkAndAdd(collect);
            for (IntegratedParamsItem integratedParamsItem : integratedParamsItemList) {
                integratedParamsItem.setId(null);
                integratedParamsItem.setIntegratedNodesId(integratedNodes.getId());
                SysUtil.setSysParam((BaseEntity)integratedParamsItem, (BaseEntity)integratedNodes);
                if (!StringUtils.isBlank((CharSequence)integratedParamsItem.getFieldLabelI18nKey()) || !stringMap.containsKey(integratedParamsItem.getFieldLabel())) continue;
                integratedParamsItem.setFieldLabelI18nKey(stringMap.get(integratedParamsItem.getFieldLabel()));
            }
            this.integratedParamsItemService.saveBatch(integratedParamsItemList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.integratedParamsHeadService.deleteByMainId(id);
        this.integratedParamsItemService.deleteByMainId(id);
        ((IntegratedNodesMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.integratedParamsHeadService.deleteByMainId(serializable.toString());
            this.integratedParamsItemService.deleteByMainId(serializable.toString());
            ((IntegratedNodesMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public List<IntegratedNodesVO> getIntegratedNodes() {
        String tenant = TenantContext.getTenant();
        ArrayList<IntegratedNodesVO> integratedNodesVOS = new ArrayList<IntegratedNodesVO>();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)tenant)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        }
        for (IntegratedNodes integratedNodes : list) {
            IntegratedNodesVO integratedNodesVO = new IntegratedNodesVO();
            BeanUtils.copyProperties((Object)((Object)integratedNodes), (Object)((Object)integratedNodesVO));
            List<IntegratedParamsHead> integratedParamsHeads = this.integratedParamsHeadService.selectByMainId(integratedNodes.getId());
            integratedNodesVO.setIntegratedParamsHeadList(integratedParamsHeads);
            List<IntegratedParamsItem> integratedParamsItems = this.integratedParamsItemService.selectByMainId(integratedNodes.getId());
            integratedNodesVO.setIntegratedParamsItemList(integratedParamsItems);
            integratedNodesVOS.add(integratedNodesVO);
        }
        return integratedNodesVOS;
    }
}

