/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integrated.listener;

import com.alibaba.fastjson.JSONObject;
import com.els.modules.integrated.entity.IntegratedBusinessData;
import com.els.modules.integrated.service.IntegratedBusinessDataService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Component;

@Component
public class IntegratedDataConsumer {
    private static final Logger log = LoggerFactory.getLogger(IntegratedDataConsumer.class);
    @Autowired
    private IntegratedBusinessDataService integratedBusinessDataService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @StreamListener(value="inputIntegratedData")
    public void receive(String msgBody) {
        if (StringUtils.isBlank((CharSequence)msgBody)) {
            return;
        }
        JSONObject body = JSONObject.parseObject((String)msgBody);
        log.info("\u63a5\u6536\u6d88\u606f,\u6d88\u606f\u5185\u5bb9:" + body.toJSONString());
        try {
            IntegratedBusinessData integratedBusinessData = (IntegratedBusinessData)((Object)JSONObject.parseObject((String)msgBody, IntegratedBusinessData.class));
            integratedBusinessData.setDataJson(body.getJSONObject("jsonData").toJSONString());
            this.integratedBusinessDataService.updateIntegratedData(integratedBusinessData);
        }
        catch (Exception e) {
            log.error("save log failed:", (Throwable)e);
        }
    }
}

