/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.language.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.DictModel;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.BaiduConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsCompanyLanguageDTO;
import com.els.modules.base.api.dto.I18nDTO;
import com.els.modules.language.entity.I18n;
import com.els.modules.language.init.I18nInit;
import com.els.modules.language.mapper.I18nMapper;
import com.els.modules.language.service.I18nService;
import com.els.modules.language.vo.I18nVO;
import com.els.modules.system.entity.CompanyI18n;
import com.els.modules.system.mapper.CompanyI18nMapper;
import com.els.modules.system.service.CheckService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.util.Hex;
import com.els.modules.system.util.TranslateUtilBD;
import com.google.common.collect.Lists;
import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.dictionary.py.Pinyin;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class I18nServiceImpl
extends ServiceImpl<I18nMapper, I18n>
implements I18nService {
    private BaiduConfig baiduConfig = (BaiduConfig)SpringContextUtils.getBean(BaiduConfig.class);
    private static final String chinessSimpleQQT = "zh";
    private static final String chinessComplexQQT = "cht";
    private Map<String, Map<String, String>> mutiLanguageCacheMap = new ConcurrentHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> elsCacheMap = new ConcurrentHashMap<String, Map<String, String>>();
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private I18nMapper i18nMapper;
    @Autowired
    @Lazy
    private DictService dictService;
    @Autowired
    @Lazy
    private CheckService checkService;
    @Autowired
    private CompanyI18nMapper companyI18nMapper;
    private static final String I18N_KEY = "sys:i18n:";
    private static String I18_CACHE_KEY = "srm:i18:cache";
    private static final String COLON = ":";

    @Override
    public IPage<I18n> finPagelist(I18n i18n) {
        List<I18n> list = ((I18nMapper)this.baseMapper).findPageList(i18n);
        int count = ((I18nMapper)this.baseMapper).findPageListCount(i18n);
        Page page = new Page((long)i18n.getFromIndex().intValue(), (long)i18n.getPageSize().intValue());
        page.setRecords(list);
        page.setSize((long)count);
        page.setTotal((long)count);
        return page;
    }

    @Override
    public IPage<I18nVO> finPagelistAll(I18nVO i18n) {
        List<Object> chineseList = new ArrayList();
        long count = 0L;
        if (StringUtils.isEmpty((CharSequence)i18n.getChinese())) {
            count = ((I18nMapper)this.baseMapper).findPageCount(i18n);
            chineseList = ((I18nMapper)this.baseMapper).findPageChinese(i18n);
        } else {
            count = ((I18nMapper)this.baseMapper).findPageCountch(i18n);
            chineseList = ((I18nMapper)this.baseMapper).findPageChinesech(i18n);
        }
        List<String> i18nKeyList = chineseList.stream().map(I18n::getI18nKey).distinct().collect(Collectors.toList());
        ArrayList<I18nVO> list = new ArrayList<I18nVO>(chineseList.size());
        if (i18nKeyList != null && !i18nKeyList.isEmpty()) {
            List<I18n> englishList = ((I18nMapper)this.baseMapper).findPageEnglish(i18nKeyList, i18n.getElsAccount());
            Map<String, String> englishMap = englishList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> chtList = ((I18nMapper)this.baseMapper).findPageCht(i18nKeyList, i18n.getElsAccount());
            Map<String, String> chtMap = chtList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> fraList = ((I18nMapper)this.baseMapper).findPageFra(i18nKeyList, i18n.getElsAccount());
            Map<String, String> fraMap = fraList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> vieList = ((I18nMapper)this.baseMapper).findPageVie(i18nKeyList, i18n.getElsAccount());
            Map<String, String> vieMap = vieList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> germanList = ((I18nMapper)this.baseMapper).findPageGerman(i18nKeyList, i18n.getElsAccount());
            Map<String, String> germanMap = germanList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            for (I18n i18n2 : chineseList) {
                I18nVO vo = new I18nVO();
                vo.setChinese(i18n2.getI18nValue());
                vo.setI18nKey(i18n2.getI18nKey());
                if (englishMap.containsKey(i18n2.getI18nKey())) {
                    vo.setEnglish(englishMap.get(i18n2.getI18nKey()));
                }
                if (fraMap.containsKey(i18n2.getI18nKey())) {
                    vo.setFrench(fraMap.get(i18n2.getI18nKey()));
                }
                if (chtMap.containsKey(i18n2.getI18nKey())) {
                    vo.setTraditionalChinese(chtMap.get(i18n2.getI18nKey()));
                }
                if (vieMap.containsKey(i18n2.getI18nKey())) {
                    vo.setVietnamese(vieMap.get(i18n2.getI18nKey()));
                }
                if (germanMap.containsKey(i18n2.getI18nKey())) {
                    vo.setGerman(germanMap.get(i18n2.getI18nKey()));
                }
                list.add(vo);
            }
        }
        Page page = new Page((long)i18n.getFromIndex().intValue(), (long)i18n.getPageSize().intValue());
        page.setRecords(list);
        page.setSize(count);
        page.setTotal(count);
        return page;
    }

    @Override
    public JSONObject findAllList(I18n i18n) {
        StringBuilder redisKey = new StringBuilder(I18N_KEY);
        redisKey.append(i18n.getElsAccount());
        redisKey.append(COLON);
        redisKey.append(i18n.getLanguage());
        JSONObject i18nJson = (JSONObject)this.redisUtil.get(redisKey.toString());
        if (i18nJson != null) {
            return i18nJson;
        }
        i18n.setFromIndex(0);
        i18n.setPageSize(Integer.MAX_VALUE);
        List<I18n> list = ((I18nMapper)this.baseMapper).findPageList(i18n);
        i18nJson = new JSONObject();
        for (I18n o : list) {
            i18nJson.put(i18n.getElsAccount() + "#" + o.getI18nKey(), (Object)o.getI18nValue());
        }
        this.redisUtil.set(redisKey.toString(), (Object)i18nJson, 3600L);
        return i18nJson;
    }

    @Override
    public String getI18nValue(String i18nKey, String defaultValue) {
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = chinessSimpleQQT;
        }
        I18n i18n = new I18n();
        i18n.setElsAccount(TenantContext.getTenant());
        i18n.setLanguage(language);
        JSONObject i18nJson = this.findAllList(i18n);
        if (i18nJson == null) {
            return defaultValue;
        }
        if (i18nJson.containsKey((Object)(TenantContext.getTenant() + "#" + i18nKey))) {
            return i18nJson.getString(TenantContext.getTenant() + "#" + i18nKey);
        }
        return defaultValue;
    }

    @Override
    public JSONObject findAllListCache(String tenant, String language) {
        String string = language = StringUtils.isBlank((CharSequence)language) ? I18nUtil.getCurrentLanguage() : language;
        if (StrUtil.isBlank((CharSequence)language)) {
            language = chinessSimpleQQT;
        }
        I18n i18n = new I18n();
        i18n.setElsAccount(StringUtils.isBlank((CharSequence)tenant) ? TenantContext.getTenant() : tenant);
        i18n.setLanguage(language);
        StringBuilder redisKey = new StringBuilder(I18N_KEY);
        redisKey.append(i18n.getElsAccount());
        redisKey.append(COLON);
        redisKey.append(i18n.getLanguage());
        JSONObject i18nJson = (JSONObject)this.redisUtil.get(redisKey.toString());
        if (i18nJson != null) {
            return i18nJson;
        }
        i18n.setFromIndex(0);
        i18n.setPageSize(Integer.MAX_VALUE);
        List<I18n> list = ((I18nMapper)this.baseMapper).findPageList(i18n);
        i18nJson = new JSONObject();
        for (I18n o : list) {
            i18nJson.put(i18n.getElsAccount() + "#" + o.getI18nKey(), (Object)o.getI18nValue());
        }
        this.redisUtil.set(redisKey.toString(), (Object)i18nJson, 3600L);
        return i18nJson;
    }

    public JSONObject findAllListCacheByI18(List<String> i18keyList) {
        if (CollectionUtils.isEmpty(i18keyList)) {
            return null;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(I18n::getI18nKey, i18keyList);
        List i18ns = ((I18nMapper)this.baseMapper).selectList((Wrapper)wrapper);
        i18ns.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount, Collectors.toList()));
        LambdaQueryWrapper wrapper1 = Wrappers.lambdaQuery();
        wrapper1.eq(CompanyI18n::getI18nKey, i18keyList);
        List companyI18ns = this.companyI18nMapper.selectList((Wrapper)wrapper1);
        return null;
    }

    @Override
    public List<I18nDTO> findI18Key(String tenant, String i18Key) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)tenant)).eq(I18n::getI18nKey, (Object)i18Key);
        List list = ((I18nMapper)this.baseMapper).selectList((Wrapper)wrapper);
        return Convert.toList(I18nDTO.class, (Object)list);
    }

    @Override
    public List<I18n> initI18Key() {
        return ((I18nMapper)this.baseMapper).loadAllI18Key();
    }

    @Override
    public void putI18nToRedis(String i18Key) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(I18n::getI18nKey, (Object)i18Key);
        List list = ((I18nMapper)this.baseMapper).selectList((Wrapper)wrapper);
        for (I18n n : list) {
            String key = I18_CACHE_KEY + COLON + "100000" + COLON + i18Key + COLON + n.getLanguage();
            this.redisUtil.set(key, (Object)n.getI18nValue());
        }
    }

    @Override
    public void delRedisData() {
        this.redisUtil.dels(I18N_KEY);
    }

    @Override
    public void delI18Data(String elsAccount, String i18Key) {
        String key = I18_CACHE_KEY + COLON + elsAccount + COLON + i18Key;
        this.redisUtil.dels(key);
        List<I18nDTO> dtos = this.findI18Key(elsAccount, i18Key);
        for (I18nDTO dto : dtos) {
            this.redisUtil.set(I18_CACHE_KEY + COLON + dto.getElsAccount() + COLON + dto.getI18nKey() + COLON + dto.getLanguage(), (Object)dto.getI18nValue());
        }
    }

    @Override
    public void i18nTranslate() {
    }

    @Override
    public void translateZh(String to) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(I18n::getLanguage, (Object)chinessSimpleQQT)).notExists("select i18n_key from els_i18n b where els_i18n.i18n_key=b.i18n_key AND b.language ='" + to + "'")).list();
        try {
            if (!CollectionUtils.isEmpty((Collection)list) && this.baiduConfig.getTranlateCheck()) {
                int listCount = list.size();
                int qy = 3;
                ArrayList<I18n> arrayList = new ArrayList<I18n>();
                ArrayList<I18n> list1 = new ArrayList<I18n>();
                Map<String, List<I18n>> collect = list.stream().collect(Collectors.toMap(I18n::getI18nValue, p -> {
                    ArrayList<I18n> getNameList = new ArrayList<I18n>();
                    getNameList.add((I18n)((Object)p));
                    return getNameList;
                }, (value1, value2) -> {
                    value1.addAll(value2);
                    return value1;
                }));
                for (int i = 0; i < listCount; ++i) {
                    list1.add((I18n)((Object)list.get(i)));
                    if (i == 0 || i % 50 != 0) continue;
                    List<I18n> i18ns = this.runTranslate(list1, to, collect);
                    arrayList.addAll(i18ns);
                    list1.clear();
                }
                if (list1.size() > 0) {
                    List<I18n> i18ns = this.runTranslate(list1, to, collect);
                    arrayList.addAll(i18ns);
                }
                if (!CollectionUtils.isEmpty(arrayList)) {
                    Map maps = arrayList.stream().collect(Collectors.toMap(I18n::getI18nKey, Function.identity(), (key1, key2) -> key2));
                    this.saveBatch(maps.values());
                    ((I18nInit)SpringContextUtils.getBean(I18nInit.class)).push(Lists.newArrayList(maps.values()));
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u56fd\u9645\u5316\u7ffb\u8bd1\u5931\u8d25:" + e);
        }
    }

    private List<I18n> runTranslate(List<I18n> i18ns, String to, Map<String, List<I18n>> collect) {
        ArrayList<I18n> arrayList = new ArrayList<I18n>();
        Map<String, Object> map = this.transformationParam(i18ns);
        String param = TranslateUtilBD.baiduFY((String)map.get("param"), chinessSimpleQQT, to);
        JSONArray jsonArray = JSONArray.parseArray((String)param);
        for (int n = 0; n < jsonArray.size(); ++n) {
            JSONObject jsonObject = JSONObject.parseObject((String)jsonArray.get(n).toString());
            if (!collect.containsKey(jsonObject.getString("src"))) continue;
            List<I18n> src = collect.get(jsonObject.getString("src"));
            for (I18n i18ndb : src) {
                I18n i18n = new I18n();
                i18n.setI18nKey(i18ndb.getI18nKey());
                i18n.setElsAccount("100000");
                i18n.setLanguage(to);
                i18n.setI18nValue(jsonObject.getString("dst"));
                arrayList.add(i18n);
            }
        }
        return arrayList;
    }

    private Map<String, Object> transformationParam(List<I18n> i18ns) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> mapKey = new HashMap<String, String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < i18ns.size(); ++i) {
            if (i == i18ns.size() - 1) {
                stringBuffer.append(i18ns.get(i).getI18nValue());
            } else {
                stringBuffer.append(i18ns.get(i).getI18nValue() + "\n");
            }
            mapKey.put(i18ns.get(i).getI18nValue(), i18ns.get(i).getI18nKey());
        }
        map.put("param", stringBuffer.toString());
        map.put("key", mapKey);
        return map;
    }

    public static String unicodeToString(String str) {
        Pattern pattern = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            char ch = (char)Integer.parseInt(matcher.group(2), 16);
            str = str.replace(matcher.group(1), ch + "");
        }
        return str;
    }

    private synchronized void putMutiLanguageCacheMap(List<I18n> i18nVOS, String language) {
        if (i18nVOS == null || i18nVOS.size() < 1) {
            return;
        }
        Map<String, String> cacheMap = this.mutiLanguageCacheMap.get(language);
        if (cacheMap == null) {
            cacheMap = new HashMap<String, String>();
        } else {
            cacheMap.clear();
        }
        Object cachekey = null;
        for (I18n i18nVO1 : i18nVOS) {
            cacheMap.put((String)cachekey, "");
        }
        this.mutiLanguageCacheMap.put(language, cacheMap);
    }

    @Override
    public void clearI18nRedis() {
        String language = "";
        this.elsCacheMap.clear();
        if (this.mutiLanguageCacheMap.get(language) != null) {
            this.mutiLanguageCacheMap.get(language).clear();
        }
        new Thread(new I18nCacheLoad(language)).start();
    }

    private synchronized void i18nTranslateValueIsEmpty() {
    }

    private boolean i18nInitCheck() {
        return false;
    }

    private void elsAppNameInit() {
    }

    private void tableColumnKeyInit() {
    }

    private synchronized void translateMutiThread() {
    }

    @SrmTransaction
    public void translateAndUpdate(String key, String value) {
    }

    private I18n findChinessVo(List<I18n> list) {
        if (list == null || list.size() < 1) {
            return null;
        }
        for (I18n i18nVO : list) {
            if (!chinessSimpleQQT.equals(i18nVO.getLanguage())) continue;
            return i18nVO;
        }
        return null;
    }

    private I18n i18nVOGet(String key, String value, String QQTlanguage, String toLanguage, String createUser) {
        return new I18n();
    }

    private I18n i18nVOGet(String key, String value, String toLanguage, String createUser) {
        I18n i18nVO = new I18n();
        i18nVO.setLanguage(toLanguage);
        return i18nVO;
    }

    private String languageStrFilter(String languageStr) {
        char[] languageStrChars = languageStr.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (char c : languageStrChars) {
            if ('\"' == c) {
                stringBuffer.append("&quot;");
                continue;
            }
            if ('&' == c) {
                stringBuffer.append("&amp;");
                continue;
            }
            if ('<' == c) {
                stringBuffer.append("&lt;");
                continue;
            }
            if ('>' == c) {
                stringBuffer.append("&gt;");
                continue;
            }
            if ('\'' == c) {
                stringBuffer.append("&acute;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    @Override
    public String createI18nKey(String chinessStr, String type) {
        if (StringUtils.isBlank((CharSequence)chinessStr)) {
            return "";
        }
        int keyHashCode = chinessStr.hashCode();
        List pinyins = HanLP.convertToPinyinList((String)chinessStr);
        StringBuilder stringBuilder = new StringBuilder();
        for (Pinyin s : pinyins) {
            String headString = s.getPinyinWithoutTone();
            int total = 0;
            for (byte b : headString.getBytes()) {
                total += b - 96;
            }
            stringBuilder.append(Hex.byteToHex(total));
        }
        String key_temp = "i18n_" + type + "_" + stringBuilder.toString() + "_" + Integer.toHexString(keyHashCode);
        return key_temp;
    }

    @Override
    public void addOtherKey(Map<String, String> map) {
        if (!CollectionUtils.isEmpty(map)) {
            List collect = map.entrySet().parallelStream().map(item -> {
                I18n i18n = new I18n();
                i18n.setI18nKey((String)item.getValue());
                i18n.setLanguage(chinessSimpleQQT);
                i18n.setI18nValue((String)item.getKey());
                i18n.setElsAccount("100000");
                return i18n;
            }).collect(Collectors.toList());
            this.saveBatch(collect);
            this.translateAll();
            this.delRedisData();
        }
    }

    @Override
    @Async
    public void translateAll() {
        List<DictModel> translateLanguage = this.dictService.queryDictItemsByCode("translateLanguage", "100000");
        if (CollectionUtils.isEmpty(translateLanguage)) {
            List<String> languages = Stream.of("en", chinessComplexQQT, "fra", "de", "vie").collect(Collectors.toList());
            languages.forEach(item -> this.translateZh((String)item));
        } else {
            List<String> collect1 = translateLanguage.stream().map(DictModel::getValue).collect(Collectors.toList());
            collect1.forEach(item -> this.translateZh((String)item));
        }
        this.delRedisData();
    }

    @Override
    public void removeByKey(String i18Key) {
        this.i18nMapper.delByI18nKeyInt(i18Key);
    }

    @Override
    public String checkAndAdd(String value) {
        return this.checkAndAdd(value, "field");
    }

    @Override
    public String checkAndAdd(String value, String fieldType) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        String key = "";
        List zh = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(I18n::getLanguage, (Object)chinessSimpleQQT)).eq(I18n::getI18nValue, (Object)value)).list();
        if (CollectionUtils.isEmpty((Collection)zh)) {
            String i18nKey = this.createI18nKey(value, fieldType);
            I18n i18n = new I18n();
            i18n.setI18nKey(i18nKey);
            i18n.setLanguage(chinessSimpleQQT);
            i18n.setI18nValue(value);
            i18n.setElsAccount("100000");
            this.save((Object)i18n);
            this.translateAll();
            this.delRedisData();
            return i18nKey;
        }
        return ((I18n)((Object)zh.get(0))).getI18nKey();
    }

    @Override
    public Map<String, String> checkAndAdd(List<String> value) {
        return this.checkAndAdd(value, "field");
    }

    @Override
    public Map<String, String> checkAndAdd(List<String> value, String fieldType) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(value)) {
            return hashMap;
        }
        String key = "";
        List zh = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(I18n::getLanguage, (Object)chinessSimpleQQT)).in(I18n::getI18nValue, value)).list();
        Map<String, String> collect = zh.stream().collect(Collectors.toMap(I18n::getI18nValue, I18n::getI18nKey, (key1, key2) -> key2));
        ArrayList<I18n> i18ns = new ArrayList<I18n>();
        for (String s : value) {
            if (collect.containsKey(s)) {
                hashMap.put(s, collect.get(s));
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)s) || hashMap.containsKey(s)) continue;
            String i18nKey = this.createI18nKey(s, fieldType);
            I18n i18n = new I18n();
            i18n.setI18nKey(i18nKey);
            i18n.setLanguage(chinessSimpleQQT);
            i18n.setI18nValue(s);
            i18n.setElsAccount("100000");
            String msg = this.checkService.checkExist(i18n.getId(), "els_i18n", "concat(language,'-',i18n_key)", i18n.getLanguage() + "-" + i18n.getI18nKey());
            if (!"success".equals(msg)) continue;
            i18ns.add(i18n);
            hashMap.put(s, i18nKey);
        }
        this.saveBatch(i18ns);
        this.translateAll();
        this.delRedisData();
        return hashMap;
    }

    @Override
    public Map<String, String> translateLanguage(List<ElsCompanyLanguageDTO> elsCompanyLanguageDTOList) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ElsCompanyLanguageDTO elsCompanyLanguageDTO : elsCompanyLanguageDTOList) {
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(I18n::getLanguage, (Object)elsCompanyLanguageDTO.getLanguagesKey())).eq(I18n::getI18nKey, (Object)elsCompanyLanguageDTO.getLanguagesI18nValue())).list();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                map.put(elsCompanyLanguageDTO.getLanguagesKey(), ((I18n)((Object)list.get(0))).getI18nValue());
                continue;
            }
            map.put(elsCompanyLanguageDTO.getLanguagesKey(), elsCompanyLanguageDTO.getLanguagesValue());
        }
        return map;
    }

    class I18nTranslateThread
    implements Runnable {
        private List<String> list = null;

        @Override
        public void run() {
            this.translateMutile();
        }

        public I18nTranslateThread() {
        }

        public I18nTranslateThread(List<String> list) {
            this.list = list;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void translateMutile() {
            List<String> list = this.list;
            I18n selectI18n = new I18n();
            List singleKeyAllList = null;
            ArrayList insertList = new ArrayList();
            for (String resourceKey : list) {
                try {
                    singleKeyAllList = ((LambdaQueryChainWrapper)I18nServiceImpl.this.lambdaQuery().eq(I18n::getI18nKey, (Object)resourceKey)).list();
                    I18n chinessI18n = I18nServiceImpl.this.findChinessVo(singleKeyAllList);
                    if (chinessI18n == null) {
                        HashMap<String, String> keyMap = new HashMap<String, String>();
                        keyMap.put("key", resourceKey);
                        I18nServiceImpl.this.i18nMapper.deleteById((Serializable)((Object)""));
                        continue;
                    }
                    boolean languageEqualsTag = false;
                    languageEqualsTag = false;
                    for (I18n i18nVO : singleKeyAllList) {
                        if (!I18nServiceImpl.chinessComplexQQT.equals(i18nVO.getLanguage())) continue;
                        languageEqualsTag = true;
                        break;
                    }
                    if (languageEqualsTag) continue;
                }
                catch (Exception exception) {}
            }
            try {
                if (insertList.size() <= 0) return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class I18nCacheLoad
    implements Runnable {
        private String language;

        public I18nCacheLoad(String language) {
            this.language = language;
        }

        @Override
        public void run() {
            List i18nVOS = ((LambdaQueryChainWrapper)I18nServiceImpl.this.lambdaQuery().eq(I18n::getLanguage, (Object)this.language)).list();
            I18nServiceImpl.this.putMutiLanguageCacheMap(i18nVOS, this.language);
        }
    }
}

