/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.storage.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.enumerate.FileStorageTypeEnum;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.attachment.storage.spi.StorageSpi;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="fileStoreSignServiceImpl")
public class FileStoreSignServiceImpl
implements FileStoreSignService {
    private static final Logger log = LoggerFactory.getLogger(FileStoreSignServiceImpl.class);
    @Value(value="${els.storage.type}")
    private String storeType;
    private static final String STR_FORMAT = "yyyyMMdd";
    private static final String STR_SPLIT = "_";
    private static final String STR_DOT = ".";
    private static final String BIZ_PATH = "files";

    protected StorageSpi getClientService(String type) {
        type = CharSequenceUtil.emptyToDefault((CharSequence)type, (String)this.storeType);
        return (StorageSpi)SpringContextUtils.getBean((String)(type + "StorageSpi"));
    }

    private JSONObject rebuildPolicyParam(String type, JSONObject policyParam) {
        FileStorageTypeEnum type1 = FileStorageTypeEnum.getType(type);
        switch (type1) {
            case LOCAL: {
                break;
            }
            case COS: {
                if (policyParam.containsKey((Object)"key")) break;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APQIMGAcMGWWWsWlT_2a9af70a", (String)"\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b\u5b58\u50a8key\u53c2\u6570\u5fc5\u987b"));
            }
            case OSS: {
                if (policyParam.containsKey((Object)"saveType")) break;
                policyParam.put("saveType", (Object)"2");
                break;
            }
        }
        return policyParam;
    }

    @Override
    public JSONObject sign(JSONObject policyParam, boolean callBack, String type, HttpServletResponse response) {
        type = CharSequenceUtil.emptyToDefault((CharSequence)type, (String)this.storeType);
        this.rebuildPolicyParam(type, policyParam);
        if (FileStorageTypeEnum.LOCAL.getCode().equals(type)) {
            JSONObject result = new JSONObject();
            log.error(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u4e0d\u652f\u6301\u83b7\u53d6\u7b7e\u540d...", (Object)type);
            result.put("supportSign", (Object)false);
            return result;
        }
        StorageSpi clientService = this.getClientService(type);
        if (null == clientService) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_BjqjjnICQIMGBSWVImERKQiR_8a9b2e1f", (String)"\u6ca1\u6709\u53ef\u7528\u7684\u7b2c\u4e09\u65b9\u6587\u4ef6\u5b58\u50a8\u670d\u52a1,\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e"));
        }
        if (!clientService.supportSign()) {
            JSONObject result = new JSONObject();
            log.error(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u4e0d\u652f\u6301\u83b7\u53d6\u7b7e\u540d...", (Object)type);
            result.put("supportSign", (Object)false);
            return result;
        }
        policyParam.put("dir", (Object)this.buildDir());
        JSONObject result = callBack && clientService.supportCallBack() ? this.getClientService(type).getPolicyAndCallback(policyParam, response) : this.getClientService(type).getPolicy(policyParam, response);
        if (null == result) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIXVVVPRKm_798aa173", (String)"\u6587\u4ef6\u4e0a\u4f20\u8bf7\u6c42\u7b7e\u540d\u5931\u8d25"));
        }
        result.put("supportSign", (Object)true);
        result.put("storageType", (Object)clientService.type());
        return result;
    }

    @Override
    public String getDownloadPath(String objectPath, String type) {
        type = CharSequenceUtil.emptyToDefault((CharSequence)type, (String)this.storeType);
        return this.getClientService(type).loadDownloadPath(objectPath);
    }

    @Override
    public String loadDownloadSafePath(String objectPath, String fileName, String type) {
        type = CharSequenceUtil.emptyToDefault((CharSequence)type, (String)this.storeType);
        StorageFileInfo fileInfo = new StorageFileInfo();
        fileInfo.setPath(objectPath);
        if (CharSequenceUtil.isNotEmpty((CharSequence)fileName)) {
            String replace = objectPath.replace("\\", "/");
            fileInfo.setFilename(replace.substring(replace.lastIndexOf("/")));
        } else {
            fileInfo.setFilename(fileName);
        }
        return this.getClientService(type).loadDownloadSafePath(fileInfo);
    }

    @Override
    public void verifyCallbackRequest(HttpServletRequest request, HttpServletResponse response, String type) {
        StorageSpi clientService = this.getClientService(type = CharSequenceUtil.emptyToDefault((CharSequence)type, (String)this.storeType));
        if (null == clientService) {
            log.error(":::\u6ca1\u6709\u53ef\u7528\u7684\u7b2c\u4e09\u65b9\u6587\u4ef6\u5b58\u50a8\u670d\u52a1,\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e...");
            return;
        }
        if (!clientService.supportCallBack() && !clientService.getStoreProperties().supportSign(type)) {
            log.error(":::\u5f53\u524d\u5b58\u50a8\u65b9\u5f0f\u4e0d\u652f\u6301\u56de\u8c03\u6821\u9a8c:{}", (Object)type);
            return;
        }
        clientService.verifyCallbackRequest(request, response);
    }

    private String buildDir() {
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowday = dtf.format(time);
        String dir = BIZ_PATH + File.separator + TenantContext.getTenant() + File.separator + nowday + File.separator;
        return dir.replace("\\", "/");
    }

    @Override
    public StorageFileInfo storeFile(MultipartFile uploadFile, String savePath, String type) {
        type = CharSequenceUtil.emptyToDefault((CharSequence)type, (String)this.storeType);
        StorageFileInfo fileInfo = new StorageFileInfo();
        try {
            fileInfo.setInputStream(uploadFile.getInputStream());
        }
        catch (IOException e) {
            log.error(":::\u4e0a\u4f20\u6587\u4ef6\u8bfb\u53d6\u8f93\u5165\u6d41\u5931\u8d25:{}", (Object)e.getMessage());
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_XVQIIH_b56fc95b", (String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38:{}", (String[])new String[]{e.getMessage()}));
        }
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowday = dtf.format(time);
        String documentName = uploadFile.getOriginalFilename();
        documentName = documentName.replaceAll("-", STR_SPLIT);
        String documentType = "";
        String fileName = "";
        int suffixLocation = documentName.lastIndexOf(STR_DOT);
        if (suffixLocation > 0) {
            documentType = documentName.substring(suffixLocation + 1);
            fileName = documentName.substring(0, documentName.lastIndexOf(STR_DOT)) + STR_SPLIT + System.currentTimeMillis() + STR_DOT + documentType;
        } else {
            fileName = documentName + STR_SPLIT + System.currentTimeMillis();
        }
        String documentLocation = File.separator + BIZ_PATH + File.separator + TenantContext.getTenant() + File.separator + nowday + File.separator + fileName;
        if (documentLocation.contains("\\")) {
            documentLocation = documentLocation.replace("\\", "/");
        }
        savePath = CharSequenceUtil.emptyToDefault((CharSequence)savePath, (String)documentLocation);
        savePath = savePath.replaceAll(" ", STR_SPLIT);
        fileInfo.setPath(savePath);
        fileInfo.setFilename(fileName);
        fileInfo.setSize(uploadFile.getSize());
        fileInfo.setOriginalFilename(uploadFile.getOriginalFilename());
        fileInfo.setSaveType(type);
        this.getClientService(type).store(fileInfo);
        return fileInfo;
    }

    @Override
    public StorageFileInfo storeFile(byte[] bytes, StorageFileInfo fileInfo, String type) {
        if (null == bytes) {
            log.error("storeFile bytes is null");
            return null;
        }
        return this.storeFile(new ByteArrayInputStream(bytes), fileInfo, type);
    }

    @Override
    public StorageFileInfo storeFile(InputStream inputStream, StorageFileInfo fileInfo, String type) {
        if (null == inputStream || null == fileInfo) {
            return null;
        }
        if (CharSequenceUtil.isBlank((CharSequence)fileInfo.getFilename()) || CharSequenceUtil.isBlank((CharSequence)fileInfo.getPath())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIMGHOIH_2b77810a", (String)"\u6587\u4ef6\u5b58\u50a8\u8def\u5f84\u5f02\u5e38"));
        }
        if (CharSequenceUtil.isBlank((CharSequence)fileInfo.getOriginalFilename())) {
            fileInfo.setOriginalFilename(fileInfo.getFilename());
        }
        fileInfo.setInputStream(inputStream);
        fileInfo.setSaveType(type);
        this.getClientService(type).store(fileInfo);
        return fileInfo;
    }

    @Override
    public void downloadFileWithOutput(HttpServletResponse response, OutputStream outputStream, String filePath, String type) {
        type = CharSequenceUtil.emptyToDefault((CharSequence)type, (String)this.storeType);
        this.getClientService(type).downloadFileWithOutput(response, outputStream, filePath);
    }

    @Override
    public InputStream downloadFileWithInputStream(String filePath, String type) {
        type = CharSequenceUtil.emptyToDefault((CharSequence)type, (String)this.storeType);
        return this.getClientService(type).downloadFileWithInputStream(filePath);
    }

    @Override
    public Resource loadAsResource(OutputStream outputStream, String storageKey, String type) {
        type = CharSequenceUtil.emptyToDefault((CharSequence)type, (String)this.storeType);
        return this.getClientService(type).loadAsResource(outputStream, storageKey);
    }

    @Override
    public boolean delete(String keyName, String type) {
        type = CharSequenceUtil.emptyToDefault((CharSequence)type, (String)this.storeType);
        return this.getClientService(type).delete(keyName);
    }

    @Override
    public boolean deleteFileBatch(List<String> remotePaths, String type) {
        type = CharSequenceUtil.emptyToDefault((CharSequence)type, (String)this.storeType);
        return this.getClientService(type).deleteFileBatch(remotePaths);
    }

    @Override
    public String activeType() {
        return this.storeType;
    }
}

