/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.excel.poi.excel.ExcelImportUtil;
import com.els.common.excel.poi.excel.entity.ExportParams;
import com.els.common.excel.poi.excel.entity.ImportParams;
import com.els.common.excel.poi.excel.view.ELSEntityExcelView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.modules.barcode.entity.SaleBarcodePoolHead;
import com.els.modules.barcode.entity.SaleBarcodePoolItem;
import com.els.modules.barcode.entity.SaleBarcodePoolRecord;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.service.SaleBarcodePoolHeadService;
import com.els.modules.barcode.service.SaleBarcodePoolItemService;
import com.els.modules.barcode.service.SaleBarcodePoolRecordService;
import com.els.modules.barcode.vo.BarcodeRecordVO;
import com.els.modules.barcode.vo.SaleBarcodePoolHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/base/barcode/saleBarcodePoolHead"})
@Api(tags={"\u9500\u552e\u6761\u7801\u5e93\u5934\u8868"})
public class SaleBarcodePoolHeadController
extends BaseController<SaleBarcodePoolHead, SaleBarcodePoolHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleBarcodePoolHeadController.class);
    @Autowired
    private SaleBarcodePoolHeadService saleBarcodePoolHeadService;
    @Autowired
    private SaleBarcodePoolItemService saleBarcodePoolItemService;
    @Autowired
    private SaleBarcodePoolRecordService saleBarcodePoolRecordService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SaleBarcodePoolHead saleBarcodePoolHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleBarcodePoolHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleBarcodePoolHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u9500\u552e\u6761\u7801\u5e93\u5934\u8868", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SaleBarcodePoolHeadVO saleBarcodePoolHeadPage) {
        SaleBarcodePoolHead saleBarcodePoolHead = new SaleBarcodePoolHead();
        BeanUtils.copyProperties((Object)((Object)saleBarcodePoolHeadPage), (Object)((Object)saleBarcodePoolHead));
        this.saleBarcodePoolHeadService.saveMain(saleBarcodePoolHead, saleBarcodePoolHeadPage.getSaleBarcodePoolItemList(), saleBarcodePoolHeadPage.getSaleBarcodePoolRecordList());
        return Result.ok((Object)((Object)saleBarcodePoolHead));
    }

    @AutoLog(busModule="\u9500\u552e\u6761\u7801\u5e93\u5934\u8868", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody SaleBarcodePoolHeadVO saleBarcodePoolHeadPage) {
        SaleBarcodePoolHead saleBarcodePoolHead = new SaleBarcodePoolHead();
        BeanUtils.copyProperties((Object)((Object)saleBarcodePoolHeadPage), (Object)((Object)saleBarcodePoolHead));
        this.saleBarcodePoolHeadService.updateMain(saleBarcodePoolHead, saleBarcodePoolHeadPage.getSaleBarcodePoolItemList(), saleBarcodePoolHeadPage.getSaleBarcodePoolRecordList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9500\u552e\u6761\u7801\u5e93\u5934\u8868", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleBarcodePoolHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u9500\u552e\u6761\u7801\u5e93\u5934\u8868", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.saleBarcodePoolHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u72b6\u6001\u53d8\u66f4")
    @ApiOperation(value="\u72b6\u6001\u53d8\u66f4", notes="\u72b6\u6001\u53d8\u66f4")
    @PostMapping(value={"/changeStatus"})
    public Result<?> changeStatus(@RequestBody SaleBarcodePoolHeadVO saleBarcodePoolHeadVO) {
        if ("1".equals(saleBarcodePoolHeadVO.getStatusType())) {
            saleBarcodePoolHeadVO.setStatus(SrmEnabledStatusEnum.ENABLED.getValue());
        } else if ("2".equals(saleBarcodePoolHeadVO.getStatusType())) {
            saleBarcodePoolHeadVO.setStatus(SrmEnabledStatusEnum.DISABLED.getValue());
        }
        SaleBarcodePoolHead saleBarcodePoolHead = new SaleBarcodePoolHead();
        BeanUtils.copyProperties((Object)((Object)saleBarcodePoolHeadVO), (Object)((Object)saleBarcodePoolHead));
        this.saleBarcodePoolHeadService.updateById((Object)saleBarcodePoolHead);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"barcode#salePool:detail"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleBarcodePoolHead saleBarcodePoolHead = (SaleBarcodePoolHead)((Object)this.saleBarcodePoolHeadService.getById((Serializable)((Object)id)));
        SaleBarcodePoolHeadVO saleBarcodePoolHeadVO = new SaleBarcodePoolHeadVO();
        BeanUtils.copyProperties((Object)((Object)saleBarcodePoolHead), (Object)((Object)saleBarcodePoolHeadVO));
        List<SaleBarcodePoolItem> saleBarcodePoolItemList = this.saleBarcodePoolItemService.selectByMainId(id);
        saleBarcodePoolHeadVO.setSaleBarcodePoolItemList(saleBarcodePoolItemList);
        List<SaleBarcodePoolRecord> saleBarcodePoolRecordList = this.saleBarcodePoolRecordService.selectByMainId(id);
        saleBarcodePoolHeadVO.setSaleBarcodePoolRecordList(saleBarcodePoolRecordList);
        return Result.ok((Object)((Object)saleBarcodePoolHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u6761\u7801\u5e93\u5934\u8868id\u67e5\u8be2\u9500\u552e\u6761\u7801\u5e93\u884c\u8868", notes="\u901a\u8fc7\u9500\u552e\u6761\u7801\u5e93\u5934\u8868id\u67e5\u8be2\u9500\u552e\u6761\u7801\u5e93\u884c\u8868")
    @GetMapping(value={"/querySaleBarcodePoolItemByMainId"})
    public Result<?> querySaleBarcodePoolItemListByMainId(@RequestParam(name="id") String id) {
        List<SaleBarcodePoolItem> saleBarcodePoolItemList = this.saleBarcodePoolItemService.selectByMainId(id);
        return Result.ok(saleBarcodePoolItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u6761\u7801\u5e93\u5934\u8868id\u67e5\u8be2\u9500\u552e\u6761\u7801\u5e93\u4f7f\u7528\u8bb0\u5f55\u8868", notes="\u901a\u8fc7\u9500\u552e\u6761\u7801\u5e93\u5934\u8868id\u67e5\u8be2\u9500\u552e\u6761\u7801\u5e93\u4f7f\u7528\u8bb0\u5f55\u8868")
    @GetMapping(value={"/querySaleBarcodePoolRecordByMainId"})
    public Result<?> querySaleBarcodePoolRecordListByMainId(@RequestParam(name="id") String id) {
        List<SaleBarcodePoolRecord> saleBarcodePoolRecordList = this.saleBarcodePoolRecordService.selectByMainId(id);
        return Result.ok(saleBarcodePoolRecordList);
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, SaleBarcodePoolHead saleBarcodePoolHead) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleBarcodePoolHead), (Map)request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        ArrayList<SaleBarcodePoolHeadVO> pageList = new ArrayList<SaleBarcodePoolHeadVO>();
        List saleBarcodePoolHeadList = this.saleBarcodePoolHeadService.list((Wrapper)queryWrapper);
        for (SaleBarcodePoolHead temp : saleBarcodePoolHeadList) {
            SaleBarcodePoolHeadVO vo = new SaleBarcodePoolHeadVO();
            BeanUtils.copyProperties((Object)((Object)temp), (Object)((Object)vo));
            List<SaleBarcodePoolItem> saleBarcodePoolItemList = this.saleBarcodePoolItemService.selectByMainId(temp.getId());
            vo.setSaleBarcodePoolItemList(saleBarcodePoolItemList);
            List<SaleBarcodePoolRecord> saleBarcodePoolRecordList = this.saleBarcodePoolRecordService.selectByMainId(temp.getId());
            vo.setSaleBarcodePoolRecordList(saleBarcodePoolRecordList);
            pageList.add(vo);
        }
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)I18nUtil.translate((String)"i18n_alert_XlToGeB_43afb359", (String)"\u9500\u552e\u6761\u7801\u5e93\u5934\u8868"));
        mv.addObject("entity", SaleBarcodePoolHeadVO.class);
        mv.addObject("params", (Object)new ExportParams("\u9500\u552e\u6761\u7801\u5e93\u5934\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u9500\u552e\u6761\u7801\u5e93\u5934\u8868"));
        mv.addObject("data", pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), SaleBarcodePoolHeadVO.class, (ImportParams)params);
                for (SaleBarcodePoolHeadVO page : list) {
                    SaleBarcodePoolHead po = new SaleBarcodePoolHead();
                    BeanUtils.copyProperties((Object)((Object)page), (Object)((Object)po));
                    this.saleBarcodePoolHeadService.saveMain(po, page.getSaleBarcodePoolItemList(), page.getSaleBarcodePoolRecordList());
                }
                Result result = Result.ok((String)I18nUtil.translate((String)"i18n_alert_QIuNLRWWFcW_6e8a1fc", (String)"\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570:${0}", (String[])new String[]{String.valueOf(list.size())}));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)(I18nUtil.translate((String)"i18n_alert_QIuNKm_c396138c", (String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:") + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException iOException) {}
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }

    @ApiOperation(value="\u56de\u5199\u6761\u7801\u8bb0\u5f55\u4fe1\u606f", notes="\u56de\u5199\u6761\u7801\u8bb0\u5f55\u4fe1\u606f")
    @PostMapping(value={"/saveBarcodeRecordByPrint"})
    public Result<?> saveBarcodeRecordByPrint(@RequestBody BarcodeRecordVO barcodeRecordVO) {
        if (StringUtils.isBlank((CharSequence)barcodeRecordVO.getTemplateId())) {
            return Result.error((String)I18nUtil.translate((String)"", (String)"templateId\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StringUtils.isBlank((CharSequence)barcodeRecordVO.getBusinessType())) {
            return Result.error((String)I18nUtil.translate((String)"", (String)"businessType\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        this.saleBarcodePoolRecordService.saveBatchBarcodeByPrint(barcodeRecordVO);
        return Result.ok(null);
    }
}

