/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.system.entity.TenantParamConfig;
import com.els.modules.system.mapper.TenantParamConfigMapper;
import com.els.modules.system.service.TenantParamConfigService;
import com.els.modules.system.vo.TenantParamConfigVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantParamConfigServiceImpl
extends BaseServiceImpl<TenantParamConfigMapper, TenantParamConfig>
implements TenantParamConfigService {
    private static final String REDIS_KEY = "sys:tenant:config:";
    @Resource
    private RedisUtil redisUtil;

    private String getRedisKey(String elsAccount, String configCode) {
        StringBuilder redisKey = new StringBuilder(REDIS_KEY);
        redisKey.append(elsAccount);
        redisKey.append(configCode);
        return redisKey.toString();
    }

    @Override
    public void add(TenantParamConfig tenantParamConfig) {
        ((TenantParamConfigMapper)this.baseMapper).insert((Object)tenantParamConfig);
    }

    @Override
    public void edit(TenantParamConfig tenantParamConfig) {
        ((TenantParamConfigMapper)this.baseMapper).updateById((Object)tenantParamConfig);
    }

    @Override
    public void delete(String id) {
        ((TenantParamConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public List<TenantParamConfig> findList(String elsAccount) {
        return ((TenantParamConfigMapper)this.baseMapper).findList(elsAccount, SysUtil.getPurchaseAccount());
    }

    @Override
    @Transactional
    public void saveTenantConfig(TenantParamConfigVO configVO) {
        List<TenantParamConfig> configList = configVO.getConfigList();
        ArrayList<TenantParamConfig> insertList = new ArrayList<TenantParamConfig>();
        ArrayList<TenantParamConfig> updateList = new ArrayList<TenantParamConfig>();
        for (TenantParamConfig config : configList) {
            if (StrUtil.isBlank((CharSequence)config.getCompanyId())) {
                TenantParamConfig tenantConfig = new TenantParamConfig();
                BeanUtils.copyProperties((Object)((Object)config), (Object)((Object)tenantConfig));
                tenantConfig.setId(null);
                tenantConfig.setElsAccount(configVO.getElsAccount());
                insertList.add(tenantConfig);
            } else {
                config.setId(config.getCompanyId());
                updateList.add(config);
            }
            this.redisUtil.del(new String[]{this.getRedisKey(configVO.getElsAccount(), config.getConfigCode())});
        }
        if (!insertList.isEmpty()) {
            this.saveBatch(insertList);
        }
        if (!updateList.isEmpty()) {
            this.updateBatchById(updateList);
        }
    }

    @Override
    public String getOneConfig(String elsAccount, String configCode) {
        String result = (String)this.redisUtil.get(this.getRedisKey(elsAccount, configCode));
        if (StrUtil.isNotBlank((CharSequence)result)) {
            return result;
        }
        TenantParamConfig config = ((TenantParamConfigMapper)this.baseMapper).getOneConfig(elsAccount, configCode);
        result = "1".equals(config.getUnlimited()) ? "Y" : config.getDefaultValue();
        this.redisUtil.set(this.getRedisKey(elsAccount, configCode), (Object)result);
        return result;
    }
}

