/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.modules.barcode.entity.SaleBarcodePoolHead;
import com.els.modules.barcode.entity.SaleBarcodePrintHead;
import com.els.modules.barcode.entity.SaleBarcodePrintItem;
import com.els.modules.barcode.enumerate.ElsBarcodeFiledType;
import com.els.modules.barcode.service.SaleBarcodePoolHeadService;
import com.els.modules.barcode.service.SaleBarcodePrintHeadService;
import com.els.modules.barcode.service.SaleBarcodePrintItemService;
import com.els.modules.barcode.vo.SaleBarcodePrintHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/barcode/saleBarcodePrintHead"})
@Api(tags={"\u9500\u552e\u6761\u7801\u6253\u5370\u5934\u8868"})
public class SaleBarcodePrintHeadController
extends BaseController<SaleBarcodePrintHead, SaleBarcodePrintHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleBarcodePrintHeadController.class);
    @Autowired
    private SaleBarcodePrintHeadService saleBarcodePrintHeadService;
    @Autowired
    private SaleBarcodePrintItemService saleBarcodePrintItemService;
    @Autowired
    private SaleBarcodePoolHeadService saleBarcodePoolHeadService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SaleBarcodePrintHead saleBarcodePrintHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleBarcodePrintHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleBarcodePrintHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(busModule="\u9500\u552e\u6761\u7801\u6253\u5370\u5934\u8868", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"barcode#salePrint:add"})
    public Result<?> add(@RequestBody SaleBarcodePrintHeadVO saleBarcodePrintHeadPage) {
        SaleBarcodePrintHead saleBarcodePrintHead = new SaleBarcodePrintHead();
        BeanUtils.copyProperties((Object)((Object)saleBarcodePrintHeadPage), (Object)((Object)saleBarcodePrintHead));
        this.saleBarcodePrintHeadService.saveMain(saleBarcodePrintHead, saleBarcodePrintHeadPage.getItemList());
        return Result.ok((Object)((Object)saleBarcodePrintHead));
    }

    @SrmValidated
    @AutoLog(busModule="\u9500\u552e\u6761\u7801\u6253\u5370\u5934\u8868", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"barcode#salePrint:edit"})
    public Result<?> edit(@RequestBody SaleBarcodePrintHeadVO saleBarcodePrintHeadPage) {
        SaleBarcodePrintHead saleBarcodePrintHead = new SaleBarcodePrintHead();
        BeanUtils.copyProperties((Object)((Object)saleBarcodePrintHeadPage), (Object)((Object)saleBarcodePrintHead));
        this.saleBarcodePrintHeadService.updateMain(saleBarcodePrintHead, saleBarcodePrintHeadPage.getItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9500\u552e\u6761\u7801\u6253\u5370\u5934\u8868", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"barcode#salePrint:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleBarcodePrintHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u9500\u552e\u6761\u7801\u6253\u5370\u5934\u8868", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.saleBarcodePrintHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"barcode#salePrint:detail"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleBarcodePrintHead saleBarcodePrintHead = (SaleBarcodePrintHead)((Object)this.saleBarcodePrintHeadService.getById((Serializable)((Object)id)));
        SaleBarcodePrintHeadVO saleBarcodePrintHeadVO = new SaleBarcodePrintHeadVO();
        BeanUtils.copyProperties((Object)((Object)saleBarcodePrintHead), (Object)((Object)saleBarcodePrintHeadVO));
        List<SaleBarcodePrintItem> saleBarcodePrintItemList = this.saleBarcodePrintItemService.selectByMainId(id);
        saleBarcodePrintHeadVO.setItemList(saleBarcodePrintItemList);
        return Result.ok((Object)((Object)saleBarcodePrintHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u6761\u7801\u6253\u5370\u5934\u8868id\u67e5\u8be2\u9500\u552e\u6761\u7801\u6253\u5370\u884c\u8868", notes="\u901a\u8fc7\u9500\u552e\u6761\u7801\u6253\u5370\u5934\u8868id\u67e5\u8be2\u9500\u552e\u6761\u7801\u6253\u5370\u884c\u8868")
    @GetMapping(value={"/querySaleBarcodePrintItemByMainId"})
    public Result<?> querySaleBarcodePrintItemListByMainId(@RequestParam(name="id") String id) {
        List<SaleBarcodePrintItem> saleBarcodePrintItemList = this.saleBarcodePrintItemService.selectByMainId(id);
        return Result.ok(saleBarcodePrintItemList);
    }

    @AutoLog(busModule="\u9500\u552e\u6761\u7801\u6253\u5370\u9884\u89c8", value="\u9500\u552e\u6761\u7801\u6253\u5370\u9884\u89c8")
    @ApiOperation(value="\u9500\u552e\u6761\u7801\u6253\u5370\u9884\u89c8", notes="\u9500\u552e\u6761\u7801\u6253\u5370\u9884\u89c8")
    @GetMapping(value={"/templatePreview"})
    @RequiresPermissions(value={"barcode#salePrint:print"})
    public Result<?> templatePreview(@RequestParam(name="id") String id) {
        SaleBarcodePrintHead saleBarcodePrintHead = (SaleBarcodePrintHead)((Object)this.saleBarcodePrintHeadService.getById((Serializable)((Object)id)));
        List<SaleBarcodePrintItem> saleBarcodePrintItemList = this.saleBarcodePrintItemService.selectByMainId(id);
        if (StringUtils.isBlank((CharSequence)saleBarcodePrintHead.getPrintNumber())) {
            return Result.error((String)"\u6253\u5370\u4efd\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<String> barcodeList = new ArrayList<String>();
        List barcodeItemList = saleBarcodePrintItemList.stream().filter(item -> "BARCODE".equals(item.getElementType()) && ElsBarcodeFiledType.CHANGE.value().equals(item.getFiledType())).collect(Collectors.toList());
        for (SaleBarcodePrintItem item2 : barcodeItemList) {
            if (!StringUtils.isNotBlank((CharSequence)item2.getDatasource())) continue;
            barcodeList.addAll(Arrays.asList(item2.getDatasource().split(",")));
        }
        if (barcodeList.size() > 0) {
            QueryWrapper poolHeadQueryWrapper = new QueryWrapper();
            poolHeadQueryWrapper.lambda().in(SaleBarcodePoolHead::getBarcode, barcodeList);
            List poolList = this.saleBarcodePoolHeadService.list((Wrapper)poolHeadQueryWrapper);
            poolList = poolList.stream().filter(pool -> Integer.parseInt(saleBarcodePrintHead.getPrintNumber()) > pool.getPrintNumber() - pool.getPrintedNumber()).collect(Collectors.toList());
            if (poolList.size() > 0) {
                List list = poolList.stream().map(SaleBarcodePoolHead::getBarcode).distinct().collect(Collectors.toList());
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_ToW_1929b9b", (String)"\u6761\u7801[") + String.join((CharSequence)",", list) + I18nUtil.translate((String)"i18n_alert_WIBRiTfWzW_1c56afe", (String)"]\u5df2\u8d85\u8fc7\u5141\u8bb8\u6253\u5370\u4efd\u6570")));
            }
        }
        Integer[] maxLength = new Integer[]{0};
        saleBarcodePrintItemList.stream().filter(item -> ElsBarcodeFiledType.CHANGE.value().equals(item.getFiledType())).forEach(info -> {
            maxLength[0] = StringUtils.isNotBlank((CharSequence)info.getDatasource()) && info.getDatasource().split(",").length > maxLength[0] ? info.getDatasource().split(",").length : maxLength[0];
        });
        StringBuffer buffer = new StringBuffer();
        for (SaleBarcodePrintItem item3 : saleBarcodePrintItemList) {
            buffer.append(item3.getDesignContent() + ";");
        }
        if (maxLength[0] > 0) {
            Object[] result = new String[maxLength[0].intValue()];
            for (int i = 0; i < maxLength[0]; ++i) {
                result[i] = buffer.toString();
            }
            List<SaleBarcodePrintItem> list = saleBarcodePrintItemList.stream().filter(item -> ElsBarcodeFiledType.CHANGE.value().equals(item.getFiledType())).collect(Collectors.toList());
            list.forEach(arg_0 -> SaleBarcodePrintHeadController.lambda$templatePreview$5((String[])result, arg_0));
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("template", "LODOP.PRINT_INIT(\" " + saleBarcodePrintHead.getTemplateName() + " \");LODOP.NewPage();" + StringUtils.join((Object[])result, (String)"LODOP.NewPage();"));
            resultMap.put("printNumber", saleBarcodePrintHead.getPrintNumber());
            return Result.ok(resultMap);
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("template", "LODOP.PRINT_INIT(\" " + saleBarcodePrintHead.getTemplateName() + " \");LODOP.NewPage();" + buffer.toString());
        resultMap.put("printNumber", saleBarcodePrintHead.getPrintNumber());
        return Result.ok(resultMap);
    }

    private static /* synthetic */ void lambda$templatePreview$5(String[] result, SaleBarcodePrintItem info) {
        int i = 0;
        if (StringUtils.isBlank((CharSequence)info.getDatasource())) {
            result[i] = "";
        } else {
            String[] datasourceArr;
            for (String datasource : datasourceArr = info.getDatasource().split(",")) {
                String newDataSource = info.getDesignContent().substring(0, info.getDesignContent().lastIndexOf(",") + 1) + "\"" + datasource + "\")";
                result[i] = result[i].replace(info.getDesignContent(), newDataSource);
                ++i;
            }
        }
    }
}

