/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.vo.DictModel;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.UserColumnDefine;
import com.els.modules.system.mapper.UserColumnDefineMapper;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.UserColumnDefineService;
import com.els.modules.system.vo.UserColumnDefineVO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserColumnDefineServiceImpl
extends ServiceImpl<UserColumnDefineMapper, UserColumnDefine>
implements UserColumnDefineService {
    private static final String COLUMN_GROUP_I18N_KEY = "srm:columnGroup:i18nKey:";
    @Autowired
    private DictService dictService;

    @Override
    public List<UserColumnDefineVO> getUserColumnDefine(String userId, String tableCode) {
        List<UserColumnDefineVO> list = ((UserColumnDefineMapper)this.baseMapper).getUserColumnDefine(TenantContext.getTenant(), userId, tableCode);
        if ("local".equals(SysUtil.getDeployWay()) && list.isEmpty()) {
            list = ((UserColumnDefineMapper)this.baseMapper).getUserColumnDefine(SysUtil.getPurchaseAccount(), userId, tableCode);
        }
        if (list.isEmpty()) {
            list = ((UserColumnDefineMapper)this.baseMapper).getUserColumnDefine("100000", userId, tableCode);
        }
        for (UserColumnDefineVO vo : list) {
            String i18nValue = I18nUtil.translate((String)vo.getColumnNameI18nKey(), (String)vo.getColumnName());
            vo.setColumnName(i18nValue);
        }
        return list;
    }

    @Override
    public JSONArray getUserColumnDefineJson(String userId, String tableCode) {
        List<UserColumnDefineVO> list = this.getUserColumnDefine(userId, tableCode);
        JSONArray jsonArray = new JSONArray();
        for (UserColumnDefineVO userColumnDefineVO : list) {
            if (userColumnDefineVO.getHidden() != 0) continue;
            JSONObject json = new JSONObject();
            if (StrUtil.isNotBlank((CharSequence)userColumnDefineVO.getFieldColors())) {
                try {
                    json.put("fieldColors", JSONObject.parse((String)userColumnDefineVO.getFieldColors()));
                }
                catch (Exception e) {
                    json.put("fieldColors", (Object)userColumnDefineVO.getFieldColors());
                }
            }
            json.put("title", (Object)I18nUtil.translate((String)userColumnDefineVO.getColumnNameI18nKey(), (String)userColumnDefineVO.getColumnName()));
            json.put("id", (Object)userColumnDefineVO.getId());
            if (StringUtils.isNotBlank((CharSequence)userColumnDefineVO.getAlignType())) {
                json.put("align", (Object)userColumnDefineVO.getAlignType());
            }
            json.put("dataIndex", (Object)userColumnDefineVO.getColumnCode());
            if (StringUtils.isNotBlank((CharSequence)userColumnDefineVO.getFixType())) {
                json.put("fixed", (Object)userColumnDefineVO.getFixType());
            } else {
                json.put("fixed", (Object)"");
            }
            if (StringUtils.isNotBlank((CharSequence)userColumnDefineVO.getColumnWidth())) {
                json.put("width", (Object)userColumnDefineVO.getColumnWidth());
            }
            json.put("sorter", (Object)true);
            if (StringUtils.isNotBlank((CharSequence)userColumnDefineVO.getScopedSlots())) {
                json.put("scopedSlots", (Object)userColumnDefineVO.getScopedSlots());
            }
            if (StringUtils.isNotBlank((CharSequence)userColumnDefineVO.getCustomRender())) {
                json.put("customRender", (Object)userColumnDefineVO.getCustomRender());
            }
            if (StringUtils.isNotBlank((CharSequence)userColumnDefineVO.getEdit())) {
                json.put("edit", (Object)userColumnDefineVO.getEdit());
            }
            if (StringUtils.isNotBlank((CharSequence)userColumnDefineVO.getLink())) {
                json.put("link", (Object)userColumnDefineVO.getLink());
            }
            if (StringUtils.isNotBlank((CharSequence)userColumnDefineVO.getRequired())) {
                json.put("required", (Object)userColumnDefineVO.getRequired());
            }
            if (StringUtils.isNotBlank((CharSequence)userColumnDefineVO.getFieldType())) {
                json.put("fieldType", (Object)userColumnDefineVO.getFieldType());
            }
            if (StringUtils.isNotBlank((CharSequence)userColumnDefineVO.getDataFormat())) {
                json.put("dataFormat", (Object)userColumnDefineVO.getDataFormat());
            }
            if (StringUtils.isNotBlank((CharSequence)userColumnDefineVO.getDictCode())) {
                json.put("dictCode", (Object)userColumnDefineVO.getDictCode());
            }
            if (StringUtils.isNotBlank((CharSequence)userColumnDefineVO.getExtendLink())) {
                json.put("extendLink", (Object)userColumnDefineVO.getExtendLink());
            }
            if (StringUtils.isNotBlank((CharSequence)userColumnDefineVO.getColumnGroup())) {
                json.put("columnGroup", (Object)userColumnDefineVO.getColumnGroup());
            } else {
                json.put("columnGroup", (Object)"");
            }
            if (StringUtils.isNotBlank((CharSequence)userColumnDefineVO.getColumnFilter())) {
                List<DictModel> ls = this.dictService.queryDictItemsByCode(userColumnDefineVO.getColumnFilter(), TenantContext.getTenant());
                JSONArray filters = new JSONArray();
                for (DictModel dm : ls) {
                    JSONObject filter = new JSONObject();
                    filter.put("text", (Object)I18nUtil.translate((String)dm.getTextI18nKey(), (String)dm.getText()));
                    filter.put("value", (Object)dm.getValue());
                    filters.add((Object)filter);
                }
                json.put("filters", (Object)filters);
            }
            jsonArray.add((Object)json);
        }
        return jsonArray;
    }

    @Override
    @SrmTransaction
    public void saveUserColumnDefine(List<UserColumnDefine> userColumnDefineList) {
        String tableCode = userColumnDefineList.get(0).getTableCode();
        String userId = userColumnDefineList.get(0).getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"table_code", (Object)tableCode);
        queryWrapper.eq((Object)"user_id", (Object)userId);
        ((UserColumnDefineMapper)this.baseMapper).delete((Wrapper)queryWrapper);
        ((UserColumnDefineMapper)this.baseMapper).insertBatchSomeColumn(userColumnDefineList);
    }

    @Override
    public void clearUserColumnDefine(String tableCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"table_code", (Object)tableCode);
        queryWrapper.eq((Object)"user_id", (Object)SysUtil.getLoginUser().getId());
        ((UserColumnDefineMapper)this.baseMapper).delete((Wrapper)queryWrapper);
    }
}

