/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.storage.spi;

import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.config.StorageProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.Resource;

public interface StorageSpi {
    public Object loadStorageClient();

    public String type();

    default public JSONObject getPolicy(JSONObject policyParam, HttpServletResponse response) {
        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APMGCKxRuPRXVCK_16e7b4d2", (String)"\u5f53\u524d\u5b58\u50a8\u65b9\u5f0f\u4e0d\u652f\u6301\u7b7e\u540d\u4e0a\u4f20\u6a21\u5f0f"));
    }

    default public JSONObject getPolicyAndCallback(JSONObject policyParam, HttpServletResponse response) {
        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APMGCKxRuPRXVCK_16e7b4d2", (String)"\u5f53\u524d\u5b58\u50a8\u65b9\u5f0f\u4e0d\u652f\u6301\u7b7e\u540d\u4e0a\u4f20\u6a21\u5f0f"));
    }

    default public StorageProperties getStoreProperties() {
        return (StorageProperties)SpringContextUtils.getBean(StorageProperties.class);
    }

    default public boolean supportSign() {
        return false;
    }

    default public boolean supportCallBack() {
        return false;
    }

    default public void verifyCallbackRequest(HttpServletRequest request, HttpServletResponse response) {
        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APMGCKxRuPRXVCK_16e7b4d2", (String)"\u5f53\u524d\u5b58\u50a8\u65b9\u5f0f\u4e0d\u652f\u6301\u7b7e\u540d\u4e0a\u4f20\u6a21\u5f0f"));
    }

    default public void response(HttpServletRequest request, HttpServletResponse response, String results, int status) throws IOException {
        response.setContentType("text/html;charset=utf-8");
        String callbackFunName = request.getParameter("callback");
        response.addHeader("Content-Length", String.valueOf(results.length()));
        if (callbackFunName == null || "".equalsIgnoreCase(callbackFunName)) {
            response.getWriter().println(results);
        } else {
            response.getWriter().println(callbackFunName + "( " + results + " )");
        }
        response.setStatus(status);
        response.flushBuffer();
    }

    public String loadDownloadPath(String var1);

    public String loadDownloadSafePath(StorageFileInfo var1);

    public boolean store(StorageFileInfo var1);

    public void downloadFileWithOutput(HttpServletResponse var1, OutputStream var2, String var3);

    public Resource loadAsResource(OutputStream var1, String var2);

    public boolean delete(String var1);

    public boolean deleteFileBatch(List<String> var1);

    public String getBaseUrl();

    public InputStream downloadFileWithInputStream(String var1);
}

