/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.language.entity.I18n;
import com.els.modules.language.service.I18nService;
import com.els.modules.system.entity.ColumnDefine;
import com.els.modules.system.service.ColumnDefineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217"})
@RestController
@RequestMapping(value={"/base/columnDefine"})
public class ColumnDefineController
extends BaseController<ColumnDefine, ColumnDefineService> {
    @Autowired
    private ColumnDefineService columnDefineService;
    @Autowired
    private I18nService i18nService;
    @Autowired
    private RedisUtil redisUtil;

    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"system#ColumnDefine:list"})
    public Result<?> queryPageList(ColumnDefine columnDefine, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)columnDefine, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.orderByAsc((Object)"sort_order");
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.columnDefineService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6839\u636etableCode\u67e5\u8be2", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6839\u636etableCode\u67e5\u8be2")
    @GetMapping(value={"/listByTableCode"})
    @RequiresPermissions(value={"system#ColumnDefine:base"})
    public Result<?> queryListByTableCode(ColumnDefine columnDefine, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        if (StringUtils.isBlank((String)columnDefine.getTableCode())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_BmAosWxOLVW_14e2f884", (String)"\u8868\u683c\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)columnDefine, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.orderByAsc((Object)"sort_order");
        IPage pageList = this.columnDefineService.page((IPage)page, (Wrapper)queryWrapper);
        if (pageList.getRecords().isEmpty()) {
            TenantContext.setTenant((String)"100000");
            queryWrapper = QueryGenerator.initQueryWrapper((Object)columnDefine, (Map)req.getParameterMap());
            pageList = this.columnDefineService.page((IPage)page, (Wrapper)queryWrapper);
            if (pageList.getRecords().isEmpty()) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LYuAEtHetAJIIVHW_1c2e4ea3", (String)"\u672a\u627e\u5230\u4f01\u4e1a\u53ca\u7cfb\u7edf\u7ea7\u5217\u81ea\u5b9a\u4e49\u4fe1\u606f!"));
            }
        }
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7tableCode\u67e5\u8be2(\u9ad8\u7ea7\u67e5\u8be2\u4f7f\u7528)", notes="\u901a\u8fc7tableCode\u67e5\u8be2(\u9ad8\u7ea7\u67e5\u8be2\u4f7f\u7528)")
    @GetMapping(value={"/queryListByTableCode"})
    @RequiresPermissions(value={"system#ColumnDefine:base"})
    public Result<?> queryListByTableCode(@RequestParam(name="tableCode", required=true) String tableCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"table_code", (Object)tableCode);
        queryWrapper.orderByAsc((Object)"sort_order");
        List defineList = this.columnDefineService.list((Wrapper)queryWrapper);
        if ("local".equals(SysUtil.getDeployWay()) && defineList.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)SysUtil.getPurchaseAccount());
            queryWrapper.eq((Object)"table_code", (Object)tableCode);
            queryWrapper.orderByAsc((Object)"sort_order");
            defineList = this.columnDefineService.list((Wrapper)queryWrapper);
        }
        if (defineList.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"table_code", (Object)tableCode);
            queryWrapper.orderByAsc((Object)"sort_order");
            defineList = this.columnDefineService.list((Wrapper)queryWrapper);
        }
        JSONArray result = new JSONArray();
        for (ColumnDefine define : defineList) {
            JSONObject object = new JSONObject();
            object.put("fieldCode", (Object)define.getColumnCode().split("_")[0]);
            object.put("fieldName", (Object)I18nUtil.translate((String)define.getColumnNameI18nKey(), (String)define.getColumnName()));
            object.put("fieldType", (Object)(StrUtil.isBlank((CharSequence)define.getFieldType()) ? "input" : define.getFieldType()));
            object.put("dictCode", (Object)define.getDictCode());
            result.add((Object)object);
        }
        return Result.ok((Object)result);
    }

    @ApiOperation(value="100000\u53f7\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="100000\u53f7\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sysList"})
    @RequiresPermissions(value={"system#ColumnDefine:sysList"})
    public Result<?> querySysPageList(ColumnDefine columnDefine, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)columnDefine, (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.orderByAsc((Object)"sort_order");
        IPage pageList = this.columnDefineService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6dfb\u52a0", logType=2, operateType=2)
    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6dfb\u52a0", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"system#ColumnDefine:add"})
    public Result<?> add(@RequestBody ColumnDefine columnDefine) {
        if (StringUtils.isBlank((String)columnDefine.getColumnNameI18nKey())) {
            String s = this.i18nService.checkAndAdd(columnDefine.getColumnName(), "field");
            columnDefine.setColumnNameI18nKey(s);
        }
        this.columnDefineService.save(columnDefine);
        return this.commonSuccessResult(2);
    }

    @SrmValidated
    @AutoLog(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u7f16\u8f91", logType=2, operateType=3)
    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u7f16\u8f91", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"system#ColumnDefine:edit"})
    public Result<?> edit(@RequestBody ColumnDefine columnDefine) {
        if (StringUtils.isBlank((String)columnDefine.getColumnNameI18nKey())) {
            String s = this.i18nService.checkAndAdd(columnDefine.getColumnName(), "field");
            columnDefine.setColumnNameI18nKey(s);
        }
        this.columnDefineService.updateById(columnDefine);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6279\u91cf\u751f\u6210\u56fd\u9645\u5316Key", logType=2, operateType=3)
    @ApiOperation(value="\u6279\u91cf\u751f\u6210\u56fd\u9645\u5316Key", notes="\u6279\u91cf\u751f\u6210\u56fd\u9645\u5316Key")
    @PostMapping(value={"/addBatchKey"})
    @RequiresPermissions(value={"system#ColumnDefine:addBatchKey"})
    public Result<?> addBatchKey(@RequestBody HashMap<String, String> data) {
        String temIds = data.get("temIds");
        List<String> idList = Arrays.asList(temIds.split(","));
        Assert.isTrue((!CollectionUtil.isEmpty(idList) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_VRRiFIAHcbLW_eb724e13", (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u5217\u8fdb\u884c\u751f\u6210\uff01"));
        List columnDefineList = this.columnDefineService.listByIds(idList);
        List collect = columnDefineList.parallelStream().filter(item -> org.apache.commons.lang3.StringUtils.isBlank((CharSequence)item.getColumnNameI18nKey())).map(item -> item.getColumnName()).collect(Collectors.toList());
        Map<Object, Object> stringMap = new HashMap();
        if (!CollectionUtils.isEmpty(collect)) {
            List zh = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.i18nService.lambdaQuery().eq(I18n::getLanguage, (Object)"zh")).in(I18n::getI18nValue, collect)).list();
            stringMap = zh.stream().collect(Collectors.toMap(I18n::getI18nValue, I18n::getI18nKey, (key1, key2) -> key2));
        }
        HashMap<String, String> noKeyHashMap = new HashMap<String, String>();
        for (ColumnDefine entity : columnDefineList) {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entity.getColumnNameI18nKey())) continue;
            if (stringMap.containsKey(entity.getColumnName())) {
                entity.setColumnNameI18nKey((String)stringMap.get(entity.getColumnName()));
                continue;
            }
            String field = this.i18nService.createI18nKey(entity.getColumnName(), "field");
            noKeyHashMap.put(entity.getColumnName(), field);
            entity.setColumnNameI18nKey(field);
        }
        if (!columnDefineList.isEmpty()) {
            this.columnDefineService.updateBatchById(columnDefineList);
        }
        this.i18nService.addOtherKey(noKeyHashMap);
        this.i18nService.delRedisData();
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5c06100000\u53f7\u7684\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7", logType=2, operateType=2)
    @ApiOperation(value="\u5c06100000\u53f7\u7684\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7", notes="\u5c06100000\u53f7\u7684\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7")
    @PostMapping(value={"/addToEnterpriseLevel"})
    @RequiresPermissions(value={"system#ColumnDefine:addToEnterpriseLevel"})
    public Result<?> addToEnterpriseLevel(@RequestBody HashMap<String, String> map) {
        this.columnDefineService.addToEnterpriseLevel(map);
        return this.commonSuccessResult(2);
    }

    @AutoLog(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u5220\u9664", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"system#ColumnDefine:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.columnDefineService.removeById((Serializable)((Object)id));
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6279\u91cf\u5220\u9664", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"system#ColumnDefine:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.columnDefineService.removeByIds(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u67e5\u8be2", notes="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"system#ColumnDefine:queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ColumnDefine columnDefine = (ColumnDefine)this.columnDefineService.getById((Serializable)((Object)id));
        return Result.ok((Object)columnDefine);
    }

    private String checkDelete(String value) {
        return "success";
    }

    private String checkExist(String dataId, String value) {
        return "success";
    }

    @GetMapping(value={"/addDictI18nKey"})
    @RequiresPermissions(value={"system#ColumnDefine:addDictI18nKey"})
    public Result<?> addDictI18nKey() {
        this.columnDefineService.addColumnI18nKey();
        return Result.ok((Object)3);
    }
}

