/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.handler.WriteHandler;
import com.els.common.excel.util.ExcelRedisKeyGenerateUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.system.entity.BackgroundFileTask;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.TaskStatusEnum;
import com.els.modules.system.service.BackgroundFileTaskService;
import com.els.modules.system.util.ExcelCellStyleStrategy;
import com.els.modules.system.util.ExcelDictWriteHandler;
import com.els.modules.system.util.ExcelHeaderUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class ExcelGenerateRunner {
    private static final Logger log = LoggerFactory.getLogger(ExcelGenerateRunner.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private BackgroundFileTaskService backgroundFileTaskService;
    @Resource
    @Lazy
    private InvokeBaseRpcService invokeBaseRpcService;
    private static final String UPLOAD_PATH = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.path.upload");
    private static final String SERVICE_ADDRESS = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.config.service.address");
    private static final String NGINX_PATH = "/opt/upFiles";

    public void immediateExec(String id, List<ExcelDetail> detailList) {
        BackgroundFileTask task = (BackgroundFileTask)((Object)this.backgroundFileTaskService.getById((Serializable)((Object)id)));
        String key = ExcelRedisKeyGenerateUtil.generateImportKey((String)task.getTaskOptBusinessType(), (String)task.getElsAccount(), (String)id);
        Map resultData = this.redisUtil.hmget(key);
        List titleList = (List)resultData.remove("title");
        List titleTipList = (List)resultData.remove("titleTip");
        if (resultData.size() == 0) {
            log.info("#immediateExec \u65e0\u53ef\u5bfc\u51fa\u7684\u5f02\u5e38\u6570\u636e");
            task.setErrorMessage("no data");
            task.setTaskStatus(TaskStatusEnum.FAIL.getCode());
            Integer failTimes = (Integer)ObjectUtil.defaultIfNull((Object)task.getFailTimes(), (Object)0);
            task.setFailTimes(failTimes + 1);
            if (task.getFailTimes() > 1) {
                this.backgroundFileTaskService.removeById((Serializable)((Object)task.getId()));
            } else {
                this.backgroundFileTaskService.updateById((Object)task);
            }
            return;
        }
        TreeMap data = resultData.entrySet().stream().sorted(Comparator.comparing(x -> Integer.parseInt(String.valueOf(x.getKey())))).collect(Collectors.toMap(Map.Entry::getKey, val -> {
            Map m = (Map)val.getValue();
            Set mapKey = m.keySet();
            Map temMap = titleList.stream().filter(x -> !mapKey.contains(x)).collect(Collectors.toMap(Function.identity(), x -> ""));
            if (!temMap.isEmpty()) {
                m.putAll(temMap);
            }
            return m;
        }, (k1, k2) -> k1, TreeMap::new));
        if (CollUtil.isEmpty(detailList)) {
            String templateListKey = ExcelRedisKeyGenerateUtil.generateImportDetailKey((String)task.getTaskOptBusinessType(), (String)id);
            detailList = (List)this.redisUtil.get(templateListKey);
        }
        if (CollUtil.isEmpty(detailList)) {
            log.info("#immediateExec Excel\u6570\u636e\u5df2\u8fc7\u671f");
            task.setErrorMessage("Excel\u6570\u636e\u5df2\u8fc7\u671f");
            task.setTaskStatus(TaskStatusEnum.FAIL.getCode());
            Integer failTimes = (Integer)ObjectUtil.defaultIfNull((Object)task.getFailTimes(), (Object)0);
            task.setFailTimes(failTimes);
            this.backgroundFileTaskService.updateById((Object)task);
            return;
        }
        String documentLocation = File.separator + "errorExcel" + File.separator + task.getElsAccount() + File.separator + task.getTaskName() + "_" + System.currentTimeMillis() + ".xlsx";
        File file = new File(this.loadSavePath(documentLocation));
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            EasyExcel.write((OutputStream)fileOutputStream).registerWriteHandler((WriteHandler)new ExcelCellStyleStrategy(detailList)).registerWriteHandler((WriteHandler)new ExcelDictWriteHandler(detailList, this.invokeBaseRpcService)).head(ExcelHeaderUtil.getErrorHeaderList(titleList, titleTipList)).sheet("data").doWrite((List)Lists.newArrayList(data.values()));
            task.setTaskStatus(TaskStatusEnum.SUCCESS.getCode());
            task.setTaskFilePath(this.loadDownloadPath(documentLocation));
            task.setExpirationTime((Date)DateUtil.offsetDay((Date)new Date(), (int)3));
            this.backgroundFileTaskService.updateById((Object)task);
        }
        catch (Exception e) {
            log.info("...#ExcelGenerateRunner#immediateExec \u751f\u6210\u9519\u8befExcel\u6570\u636e\u8868\u5f02\u5e38:{}", (Object)e.getMessage());
            Integer failTimes = (Integer)ObjectUtil.defaultIfNull((Object)task.getFailTimes(), (Object)0);
            task.setFailTimes(failTimes + 1);
            task.setTaskStatus(TaskStatusEnum.FAIL.getCode());
            task.setErrorMessage(e.getMessage());
            if (task.getFailTimes() >= 3) {
                this.backgroundFileTaskService.removeById((Serializable)((Object)task.getId()));
            }
            this.backgroundFileTaskService.updateById((Object)task);
        }
    }

    private String loadDownloadPath(String objectPath) {
        if (objectPath.startsWith(File.separator) && UPLOAD_PATH.endsWith(File.separator)) {
            objectPath = objectPath.substring(1);
        }
        String url = SERVICE_ADDRESS + NGINX_PATH + objectPath;
        return url.replace("\\", "/");
    }

    private String loadSavePath(String objectPath) {
        if (objectPath.startsWith(File.separator) && UPLOAD_PATH.endsWith(File.separator)) {
            objectPath = objectPath.substring(1);
        }
        String url = UPLOAD_PATH + objectPath;
        return url.replace("\\", "/");
    }

    @Scheduled(cron="0 0 3 ? * *")
    public void cleanTask() {
        log.info("#ExcelGenerateRunner#cleanTask \u5b9a\u65f6\u4efb\u52a1\u6e05\u9664\u8fc7\u671fExcel\u5bfc\u5165\u62a5\u9519\u8bb0\u5f55");
        this.backgroundFileTaskService.cleanTask();
    }

    @Scheduled(cron="0 0 5 ? * *")
    public void runTask() {
        log.info("#ExcelGenerateRunner#runTask \u5b9a\u65f6\u4efb\u52a1\u518d\u6b21\u6267\u884c\u751f\u6210\u9519\u8befExcel\u62a5\u8868");
        List<BackgroundFileTask> backgroundFileTasks = this.backgroundFileTaskService.loadExcelImportRunTask();
        for (BackgroundFileTask task : backgroundFileTasks) {
            ((ExcelGenerateRunner)SpringContextUtils.getBean(ExcelGenerateRunner.class)).immediateExec(task.getId(), null);
        }
    }
}

