/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.encryption.base.IEncryption;
import com.els.modules.barcode.entity.ElsBarCodeParamConfig;
import com.els.modules.barcode.entity.ElsBarcodeRuleHead;
import com.els.modules.barcode.entity.ElsBarcodeRuleItem;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoDetail;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoItem;
import com.els.modules.barcode.enumerate.BarcodeAttrEnum;
import com.els.modules.barcode.enumerate.BarcodeResolveTypeEnum;
import com.els.modules.barcode.enumerate.ElsBarCodeParamConfigEnum;
import com.els.modules.barcode.enumerate.EncryptionEnum;
import com.els.modules.barcode.mapper.ElsBarCodeParamConfigMapper;
import com.els.modules.barcode.mapper.ElsBarCodeShortCodeMapper;
import com.els.modules.barcode.mapper.ElsBarcodeRuleHeadMapper;
import com.els.modules.barcode.mapper.ElsBarcodeRuleItemMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodeInfoItemMapper;
import com.els.modules.barcode.service.PurchaseBarcodeInfoItemService;
import com.els.modules.barcode.vo.PurchaseBarcodeInfoHeadVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.list.TreeList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseBarcodeInfoItemServiceImpl
extends BaseServiceImpl<PurchaseBarcodeInfoItemMapper, PurchaseBarcodeInfoItem>
implements PurchaseBarcodeInfoItemService {
    @Autowired
    private PurchaseBarcodeInfoItemMapper purchaseBarcodeInfoItemMapper;
    @Autowired
    private ElsBarCodeShortCodeMapper elsBarCodeShortCodeMapper;
    @Autowired
    private ElsBarCodeParamConfigMapper elsBarCodeParamConfigMapper;
    @Autowired
    private ElsBarcodeRuleHeadMapper elsBarcodeRuleHeadMapper;
    @Autowired
    private ElsBarcodeRuleItemMapper elsBarcodeRuleItemMapper;

    @Override
    public List<PurchaseBarcodeInfoItem> selectByMainId(String mainId) {
        return this.purchaseBarcodeInfoItemMapper.selectByMainId(mainId);
    }

    @Override
    public List<PurchaseBarcodeInfoDetail> generateBarcode(PurchaseBarcodeInfoHeadVO purchaseBarcodeInfoHeadVO) throws Exception {
        ElsBarcodeRuleHead ruleHead = (ElsBarcodeRuleHead)((Object)this.elsBarcodeRuleHeadMapper.selectById((Serializable)((Object)purchaseBarcodeInfoHeadVO.getRuleId())));
        QueryWrapper ruleItemQueryWrapper = new QueryWrapper();
        ruleItemQueryWrapper.lambda().eq(ElsBarcodeRuleItem::getHeadId, (Object)purchaseBarcodeInfoHeadVO.getRuleId());
        List ruleItemList = this.elsBarcodeRuleItemMapper.selectList((Wrapper)ruleItemQueryWrapper);
        if (ruleItemList.size() == 0) {
            Assert.msgThrow((String)I18nUtil.translate((String)"i18n_alert_mhxuToLFERVH_70484664", (String)"\u67e5\u8be2\u4e0d\u5230\u6761\u7801\u89c4\u5219\u914d\u7f6e\u4fe1\u606f"));
        }
        Map<String, List<ElsBarcodeRuleItem>> groupByRuleItem = ruleItemList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getBusinessType())).collect(Collectors.groupingBy(ElsBarcodeRuleItem::getBusinessType));
        QueryWrapper paramConfigQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)paramConfigQueryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(ElsBarCodeParamConfig::getStatus, (Object)ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_ON.value());
        if (groupByRuleItem.size() > 1) {
            paramConfigQueryWrapper.lambda().isNull(ElsBarCodeParamConfig::getBusDocType);
        } else {
            paramConfigQueryWrapper.lambda().eq(ElsBarCodeParamConfig::getBusDocType, (Object)((ElsBarcodeRuleItem)((Object)ruleItemList.get(0))).getBusinessType());
        }
        List paramConfigs = this.elsBarCodeParamConfigMapper.selectList((Wrapper)paramConfigQueryWrapper);
        if (paramConfigs.size() == 0) {
            QueryWrapper defaultParamConfigQueryWrapper = new QueryWrapper();
            defaultParamConfigQueryWrapper.lambda().eq(ElsBarCodeParamConfig::getDefaultParam, (Object)"1");
            defaultParamConfigQueryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
            paramConfigs = this.elsBarCodeParamConfigMapper.selectList((Wrapper)defaultParamConfigQueryWrapper);
            Assert.msgThrow((String)I18nUtil.translate((String)"i18n_alert_mhxuTosWERVHWVWKTosWERsERCLjTosWW_17fed132", (String)"\u67e5\u8be2\u4e0d\u5230\u6761\u7801\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u5148\u5728\u6761\u7801\u53c2\u6570\u914d\u7f6e\u4e2d\u914d\u7f6e\u9ed8\u8ba4\u7684\u6761\u7801\u53c2\u6570\uff01"));
        }
        ArrayList<PurchaseBarcodeInfoDetail> list = new ArrayList<PurchaseBarcodeInfoDetail>();
        TreeList originalAttrList = new TreeList();
        List<String[]> attrList = this.replaceCode(purchaseBarcodeInfoHeadVO, (List<String[]>)originalAttrList);
        for (int i = 0; i < attrList.get(0).length; ++i) {
            List<String> newOriginalAttrList = new ArrayList<String>();
            newOriginalAttrList.add(((String[])originalAttrList.get(0))[i]);
            List<String> newAttrList = new ArrayList<String>();
            newAttrList.add(attrList.get(0)[i]);
            for (int j = 1; j < attrList.size(); ++j) {
                newAttrList = this.joinAttr(newAttrList, attrList.get(j));
                newOriginalAttrList = this.joinAttr(newOriginalAttrList, (String[])originalAttrList.get(j));
            }
            int k = 0;
            for (String newAttr : newAttrList) {
                PurchaseBarcodeInfoDetail detail = new PurchaseBarcodeInfoDetail();
                if ("1".equals(ruleHead.getEncrypt())) {
                    IEncryption iEncryption = EncryptionEnum.of(((ElsBarCodeParamConfig)((Object)paramConfigs.get(0))).getEncryptionArithmetic());
                    String cipherBarCode = iEncryption.plainTextEncrypt(newAttr + purchaseBarcodeInfoHeadVO.getRuleCode());
                    if (BarcodeResolveTypeEnum.NO.getValue().equals(ruleHead.getResolveType()) || BarcodeResolveTypeEnum.BARCODE_POOL.getValue().equals(ruleHead.getResolveType())) {
                        detail.setBarcode(cipherBarCode + ((ElsBarCodeParamConfig)((Object)paramConfigs.get(0))).getEncryptionArithmetic());
                    } else {
                        detail.setBarcode(cipherBarCode + purchaseBarcodeInfoHeadVO.getRuleCode() + ((ElsBarCodeParamConfig)((Object)paramConfigs.get(0))).getEncryptionArithmetic());
                    }
                } else {
                    StringBuilder barcode = new StringBuilder(newAttr);
                    if (!BarcodeResolveTypeEnum.NO.getValue().equals(ruleHead.getResolveType()) && !BarcodeResolveTypeEnum.BARCODE_POOL.getValue().equals(ruleHead.getResolveType())) {
                        barcode.append(purchaseBarcodeInfoHeadVO.getRuleCode());
                    }
                    if ("1".equals(((ElsBarCodeParamConfig)((Object)paramConfigs.get(0))).getEncryptionArithmetic())) {
                        barcode.append(((ElsBarCodeParamConfig)((Object)paramConfigs.get(0))).getEncryptionArithmetic());
                    }
                    detail.setBarcode(barcode.toString());
                }
                detail.setOriginalBarcode(newOriginalAttrList.get(k));
                detail.setPrintNumber(purchaseBarcodeInfoHeadVO.getPrintNumber());
                list.add(detail);
                ++k;
            }
        }
        return list;
    }

    private List<String[]> replaceCode(PurchaseBarcodeInfoHeadVO purchaseBarcodeInfoHeadVO, List<String[]> originalAttrList) throws Exception {
        TreeList attrList = new TreeList();
        for (PurchaseBarcodeInfoItem item : purchaseBarcodeInfoHeadVO.getPurchaseBarcodeInfoItemList()) {
            if (StringUtils.isBlank((CharSequence)item.getAttribute())) {
                Assert.isNotBlank((String)item.getAttribute(), (String)I18nUtil.translate((String)"i18n_alert_ToWcCcxOLV_882ff66d", (String)"\u5c5e\u6027\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"));
                continue;
            }
            Object[] attrArr = item.getAttribute().split(",");
            Object[] newAttrArr = new String[attrArr.length];
            Object[] numberArr = new String[]{};
            Object[] newNumberArr = new String[]{};
            Object[] tempAttrArr = attrArr;
            if (BarcodeAttrEnum.THREE.getValue().equals(item.getAttributeType()) || BarcodeAttrEnum.SIX.getValue().equals(item.getAttributeType()) || BarcodeAttrEnum.SEVEN.getValue().equals(item.getAttributeType()) || BarcodeAttrEnum.EIGHT.getValue().equals(item.getAttributeType())) {
                ArrayList tempData = Lists.newArrayList();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                for (String string : attrArr) {
                    DateTime dateTime = DateUtil.parse((CharSequence)string);
                    Date date = new Date(dateTime.getTime());
                    tempData.add(simpleDateFormat.format(date));
                }
                attrArr = tempData.toArray(new String[tempData.size()]);
            }
            for (int i = 0; i < attrArr.length; ++i) {
                if ("1".equals(item.getUsedCode())) {
                    String shortCodeValue = this.elsBarCodeShortCodeMapper.getShortCodeValue((String)attrArr[i], item.getCodeType(), TenantContext.getTenant());
                    if (StringUtils.isEmpty((CharSequence)shortCodeValue)) {
                        Assert.msgThrow((String)I18nUtil.translate((String)"i18n_alert_mxuIdjIoVH_7d3abf30", (String)"\u67e5\u4e0d\u5230\u5bf9\u5e94\u7684\u7b80\u7801\u4fe1\u606f"));
                    } else {
                        newAttrArr[i] = shortCodeValue;
                    }
                } else {
                    newAttrArr[i] = attrArr[i];
                }
                if (BarcodeAttrEnum.SIX.getValue().equals(item.getAttributeType()) || BarcodeAttrEnum.SEVEN.getValue().equals(item.getAttributeType()) || BarcodeAttrEnum.EIGHT.getValue().equals(item.getAttributeType()) || BarcodeAttrEnum.NINE.getValue().equals(item.getAttributeType())) {
                    if (purchaseBarcodeInfoHeadVO.getGenerateNumber() == null) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ToWcsxQfyWcKWbLTWxOLV_31a44a84", (String)"\u6761\u7801\u5c5e\u6027\u5305\u542b\u6d41\u6c34\u53f7\u5c5e\u6027\u65f6\uff0c\u751f\u6210\u6761\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
                    }
                    if (purchaseBarcodeInfoHeadVO.getStep() == null) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ToWcsxQfyWcKWQfyxHxOLV_fce014da", (String)"\u6761\u7801\u5c5e\u6027\u5305\u542b\u6d41\u6c34\u53f7\u5c5e\u6027\u65f6\uff0c\u6d41\u6c34\u53f7\u6b65\u957f\u4e0d\u80fd\u4e3a\u7a7a"));
                    }
                    Object[] tempNumberArr = new String[purchaseBarcodeInfoHeadVO.getGenerateNumber() - 1];
                    Object[] tempNewNumberArr = new String[purchaseBarcodeInfoHeadVO.getGenerateNumber() - 1];
                    Integer count = 0;
                    try {
                        count = Integer.parseInt((String)attrArr[i]);
                    }
                    catch (Exception e) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QfyROLWJ_421877aa", (String)"\u6d41\u6c34\u53f7\u53ea\u80fd\u4e3a\u6570\u5b57"));
                    }
                    for (int j = 1; j < purchaseBarcodeInfoHeadVO.getGenerateNumber(); ++j) {
                        count = count + purchaseBarcodeInfoHeadVO.getStep();
                        tempNumberArr[j - 1] = count.toString();
                        tempNewNumberArr[j - 1] = this.generateNewAttr(item, count.toString());
                    }
                    numberArr = (String[])ArrayUtils.addAll((Object[])tempNumberArr, (Object[])numberArr);
                    newNumberArr = (String[])ArrayUtils.addAll((Object[])tempNewNumberArr, (Object[])newNumberArr);
                }
                newAttrArr[i] = this.generateNewAttr(item, (String)newAttrArr[i]);
            }
            attrArr = (String[])ArrayUtils.addAll((Object[])tempAttrArr, (Object[])numberArr);
            newAttrArr = (String[])ArrayUtils.addAll((Object[])newAttrArr, (Object[])newNumberArr);
            originalAttrList.add((String[])attrArr);
            attrList.add(newAttrArr);
        }
        return attrList;
    }

    private String generateNewAttr(PurchaseBarcodeInfoItem item, String attr) throws Exception {
        if (item.getLength() > ((String)attr).length()) {
            String part = String.format("%0" + (item.getLength() - ((String)attr).length()) + "d", Integer.parseInt(item.getCoverCode())).replaceAll("0", item.getCoverCode());
            attr = "1".equals(item.getAlignment()) ? (String)attr + part : part + (String)attr;
        } else if (item.getLength() < ((String)attr).length()) {
            attr = "1".equals(item.getAlignment()) ? ((String)attr).substring(0, item.getLength()) : ((String)attr).substring(((String)attr).length() - item.getLength());
        }
        return attr;
    }

    private List<String> joinAttr(List<String> oldAttrList, String[] currentArr) throws Exception {
        ArrayList<String> newAttrList = new ArrayList<String>();
        for (String oldAttr : oldAttrList) {
            for (int i = 0; i < currentArr.length; ++i) {
                newAttrList.add(oldAttr + currentArr[i]);
            }
        }
        return newAttrList;
    }

    public static void main(String[] args) {
        Object[] aa = new String[]{};
        for (int i = 0; i < 4; ++i) {
            Object[] bb = new String[]{"" + i};
            aa = (String[])ArrayUtils.addAll((Object[])aa, (Object[])bb);
        }
    }
}

