/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.log.socket;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/socket/logWebSocket")
public class LogWebSocketServer {
    private static final Logger log = LoggerFactory.getLogger(LogWebSocketServer.class);
    private Session session;
    private static final Map<String, Session> clientMap = new ConcurrentHashMap<String, Session>();

    @OnOpen
    public void onOpen(Session session) {
        log.info("LogWebSocket\u8fde\u63a5\u6210\u529f:" + session.getId());
        this.session = session;
        clientMap.put(session.getId(), session);
    }

    @OnClose
    public void onClose() {
        clientMap.remove(this.session.getId());
        log.info("\u5ba2\u6237\u7aef" + this.session.getId() + "\u5931\u53bb\u8fde\u63a5");
    }

    @OnError
    public void onError(Session session, Throwable error) {
        log.error("\u8fde\u63a5:" + session.getId() + "\u53d1\u751f\u9519\u8bef", error);
    }

    @OnMessage
    public void onMessage(String text) {
        log.info("\u63a5\u6536\u5230\u5ba2\u6237\u7aef" + this.session.getId() + "\u4f20\u6765\u7684\u6d88\u606f:" + text);
    }

    public static void sendLog(JSONObject messageVO) {
        for (Map.Entry<String, Session> entry : clientMap.entrySet()) {
            Session value = entry.getValue();
            if (value == null || !value.isOpen()) continue;
            value.getAsyncRemote().sendText(messageVO.toJSONString());
        }
    }
}

