/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.exception.ELSExcelBootException;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SqlInjectionUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.entity.ExcelHeader;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.mapper.ExcelDetailMapper;
import com.els.modules.system.mapper.ExcelHeaderMapper;
import com.els.modules.system.rpc.service.BaseInvokeExcelItemExecuteService;
import com.els.modules.system.service.ExcelItemExcelService;
import com.els.modules.system.util.ExcelCellStyleStrategy;
import com.els.modules.system.util.ExcelDataListener;
import com.els.modules.system.util.ExcelDictWriteHandler;
import com.els.modules.system.util.ExcelEnquiryCellStrategy;
import com.els.modules.system.util.ExcelEnquiryCellWriteCellStyle;
import com.els.modules.system.util.ExcelHeaderUtil;
import com.els.modules.system.util.ExcelSaleEnquiryDataListener;
import com.els.modules.system.vo.SaleEnquiryCostQuotePriceGroupVO;
import com.els.modules.system.vo.SaleEnquiryQuotePriceVO;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.service.TemplateConfigHeadService;
import com.els.modules.template.service.TemplateConfigItemService;
import com.els.modules.template.service.TemplateGroupService;
import com.els.modules.template.service.TemplateHeadService;
import com.els.modules.template.vo.TemplateHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ExcelItemExcelServiceImpl
implements ExcelItemExcelService {
    private static final Logger log = LoggerFactory.getLogger(ExcelItemExcelServiceImpl.class);
    @Resource
    private BaseInvokeExcelItemExecuteService baseInvokeExcelItemExecuteService;
    @Resource
    private TemplateHeadService templateHeadService;
    @Resource
    private TemplateConfigHeadService templateConfigHeadService;
    @Resource
    private TemplateConfigItemService templateConfigItemService;
    @Resource
    private TemplateGroupService templateGroupService;
    @Resource
    private ExcelHeaderMapper excelHeaderMapper;
    @Resource
    private ExcelDetailMapper excelDetailMapper;
    @Resource
    @Lazy
    private InvokeBaseRpcService invokeBaseRpcService;
    public static final ThreadLocal<Integer> SHEET_NUMBER = new ThreadLocal();

    private List<TemplateConfigItem> getTemplate(ExcelByConfigDTO excelByConfigDTO, ExcelItemByConfigRpcService excelItemByConfigRpcService) {
        List itemList = excelItemByConfigRpcService.getTemplate(excelByConfigDTO).getTemplateConfigItemList();
        List<Object> listNew = SysUtil.copyProperties((List)itemList, TemplateConfigItem.class);
        if (StringUtils.isBlank((CharSequence)excelByConfigDTO.getGroupCode())) {
            return listNew;
        }
        listNew = listNew.stream().filter(item -> excelByConfigDTO.getGroupCode().equals(item.getGroupCode())).collect(Collectors.toList());
        return listNew;
    }

    private List<ExcelDetail> getExcelDetail(ExcelByConfigDTO excelByConfigDTO, ExcelItemByConfigRpcService excelItemByConfigRpcService) {
        ArrayList<ExcelDetail> detailList = new ArrayList<ExcelDetail>();
        List<TemplateConfigItem> itemList = this.getTemplate(excelByConfigDTO, excelItemByConfigRpcService);
        if (CollectionUtil.isNotEmpty(itemList)) {
            String SALE = "sale";
            int index = 1;
            for (TemplateConfigItem item : itemList) {
                boolean editFlag;
                boolean showFlag = SALE.equals(excelByConfigDTO.getRoleCode()) ? "1".equals(item.getSaleShow()) : "1".equals(item.getPurchaseShow());
                if (!showFlag) continue;
                ExcelDetail detail = new ExcelDetail();
                detail.setElsAccount(item.getElsAccount());
                detail.setColumnCode(item.getFieldName());
                detail.setColumnName(item.getFieldLabel());
                detail.setColumnIndex(index++);
                boolean bl = editFlag = SALE.equals(excelByConfigDTO.getRoleCode()) ? "1".equals(item.getSaleEdit()) : "1".equals(item.getPurchaseEdit());
                if (editFlag && "1".equals(item.getRequired())) {
                    detail.setRequired(CommonConstant.STATUS_YES);
                }
                detail.setPrimaryKey(CommonConstant.STATUS_NO);
                detail.setDataType(ExcelDataTypeEnum.STRING.getCode());
                if (!(!StringUtils.isNotBlank((CharSequence)item.getDictCode()) || item.getDictCode().contains(",") && item.getDictCode().contains("#"))) {
                    detail.setDataType(ExcelDataTypeEnum.DICT.getCode());
                    detail.setDataFormat(item.getDictCode());
                } else if ("number".equals(item.getFieldType()) || "float".equals(item.getFieldType()) || "computed".equals(item.getFieldType())) {
                    detail.setDataType(ExcelDataTypeEnum.NUMBER.getCode());
                } else if ("date".equals(item.getFieldType())) {
                    detail.setDataType(ExcelDataTypeEnum.DATE.getCode());
                    detail.setDataFormat(item.getDataFormat() == null || item.getDataFormat().length() < 11 ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss");
                }
                detailList.add(detail);
            }
        }
        log.info("detailList:{}", (Object)JSON.toJSON(detailList).toString());
        return detailList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO, List<ExcelDetail> detailList, ExcelItemByConfigRpcService excelItemByConfigRpcService) {
        String elsAccount = StringUtils.isBlank((CharSequence)excelByConfigDTO.getBusAccount()) ? TenantContext.getTenant() : excelByConfigDTO.getBusAccount();
        List result = excelItemByConfigRpcService.getExportData(excelByConfigDTO);
        if (CollectionUtil.isNotEmpty((Collection)result)) {
            Map<String, String> dictMap = detailList.stream().filter(detail -> ExcelDataTypeEnum.DICT.getCode().equals(detail.getDataType())).collect(Collectors.toMap(ExcelDetail::getColumnCode, ExcelDetail::getDataFormat));
            HashMap<String, List> listMap = new HashMap<String, List>();
            for (String string : dictMap.values()) {
                List dictList;
                if (listMap.containsKey(string)) continue;
                log.info("ExcelItemExcelServiceImpl getExportData:{}", (Object)string);
                if (string.contains("#") || string.contains(",")) {
                    String[] params = string.contains("#") ? string.split("#") : string.split(",");
                    if (params.length < 3) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JCWWWWmKxiR_bc91c337", (String)"\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e"));
                    }
                    String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
                    SqlInjectionUtil.filterContent((String[])sqlInjCheck);
                    if (params.length != 4) throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JCxzE_2d5d1760", (String)"\u5b57\u5178\u4e0d\u5339\u914d"));
                    String string2 = params[3];
                    SqlInjectionUtil.filterContent((String)string2);
                    log.info("ExcelItemExcelServiceImpl queryTableDictListByFilterSql");
                    dictList = this.invokeBaseRpcService.queryTableDictListByFilterSql(elsAccount, params[0], params[1], params[2], string2);
                } else {
                    log.info("ExcelItemExcelServiceImpl queryDictItemsByCode");
                    dictList = "permissionScope".equals(string) ? this.invokeBaseRpcService.findOpenbusinessType() : this.invokeBaseRpcService.queryDictItemsByCode(string, elsAccount);
                }
                listMap.put(string, dictList);
            }
            Object data = result.get(0);
            if (data instanceof Map) {
                for (Object object : result) {
                    Map map = (Map)object;
                    for (Map.Entry entry : map.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!dictMap.containsKey(key)) continue;
                        List dictList = (List)listMap.get(dictMap.get(key));
                        this.translation((List<DictDTO>)dictList, map, key);
                    }
                }
            } else {
                Field[] fieldArray = ConvertUtils.getAllFields(data);
                for (Object object : result) {
                    for (Field field : fieldArray) {
                        if (!dictMap.containsKey(field.getName())) continue;
                        List dictList = (List)listMap.get(dictMap.get(field.getName()));
                        this.translation((List<DictDTO>)dictList, object, field);
                    }
                }
            }
        }
        log.info("getExportData:{}", (Object)JSON.toJSON((Object)result).toString());
        return result;
    }

    private void translation(List<DictDTO> dictList, Object object, Field field) {
        try {
            field.setAccessible(true);
            String value = StrUtil.toString((Object)field.get(object));
            for (DictDTO model : dictList) {
                if (!model.getValue().equals(value)) continue;
                field.set(object, model.getText());
                return;
            }
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_vGIH_277d478d", (String)"\u53cd\u5c04\u5f02\u5e38"), (Throwable)e, new String[0]);
        }
    }

    private void translation(List<DictDTO> dictList, Map map, String key) {
        for (DictDTO model : dictList) {
            if (!model.getValue().equals(map.get(key))) continue;
            map.put(key, model.getText());
            return;
        }
    }

    private List<String> includeColumn(List<ExcelDetail> detailList) {
        return detailList.stream().map(ExcelDetail::getColumnCode).collect(Collectors.toList());
    }

    @Override
    public void download(HttpServletResponse response, ExcelByConfigDTO excelByConfigDTO) {
        ExcelItemByConfigRpcService excelItemByConfigRpcService = this.baseInvokeExcelItemExecuteService.getExcelItemByConfigRpcService(excelByConfigDTO.getHandlerName());
        List<ExcelDetail> detailList = this.getExcelDetail(excelByConfigDTO, excelItemByConfigRpcService);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            response.setContentType("application/force-download");
            response.addHeader("Content-Disposition", "attachment;fileName=" + new String("\u5bfc\u5165\u6a21\u677f.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            List<Map<String, Object>> dataList = this.buildEmptyData(detailList, 100);
            EasyExcel.write((OutputStream)outputStream).registerWriteHandler((WriteHandler)new ExcelCellStyleStrategy(detailList)).registerWriteHandler((WriteHandler)new ExcelDictWriteHandler(detailList, this.invokeBaseRpcService)).head(ExcelHeaderUtil.getHeaderList(detailList)).sheet("data").doWrite(dataList);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    private List<Map<String, Object>> buildEmptyData(List<ExcelDetail> detailList, int length) {
        ArrayList objects = Lists.newArrayList();
        HashMap<String, String> data = new HashMap<String, String>();
        for (ExcelDetail detail : detailList) {
            if (!ExcelDataTypeEnum.STRING.getCode().equals(detail.getDataType()) && !ExcelDataTypeEnum.NUMBER.getCode().equals(detail.getDataType())) continue;
            data.put(detail.getColumnCode(), "");
        }
        if (data.size() == 0) {
            return objects;
        }
        for (int i = 0; i < length; ++i) {
            objects.add(data);
        }
        return objects;
    }

    @Override
    public void exportExcel(HttpServletResponse response, ExcelByConfigDTO excelByConfigDTO) {
        List<ExcelDetail> detailList;
        ExcelItemByConfigRpcService excelItemByConfigRpcService = this.baseInvokeExcelItemExecuteService.getExcelItemByConfigRpcService(excelByConfigDTO.getHandlerName());
        if ("excel".equals(excelByConfigDTO.getExcelTemplateType())) {
            ExcelHeader excelHeader = this.excelHeaderMapper.selectByExcelCode(excelByConfigDTO.getExcelCode(), TenantContext.getTenant());
            if (excelHeader == null) {
                excelHeader = this.excelHeaderMapper.selectByExcelCode(excelByConfigDTO.getExcelCode(), SysUtil.getPurchaseAccount());
            }
            if (excelHeader == null) {
                excelHeader = this.excelHeaderMapper.selectByExcelCode(excelByConfigDTO.getExcelCode(), "100000");
            }
            detailList = this.excelDetailMapper.selectByMainId(excelHeader.getId());
        } else {
            detailList = this.getExcelDetail(excelByConfigDTO, excelItemByConfigRpcService);
        }
        List<Object> data = this.getExportData(excelByConfigDTO, detailList, excelItemByConfigRpcService);
        List<String> includeColumnSet = this.includeColumn(detailList);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            response.setContentType("application/force-download");
            response.addHeader("Content-Disposition", "attachment;fileName=" + new String("\u5bfc\u51fa\u6570\u636e.xls".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            ExcelWriter excelWriter = EasyExcel.write((OutputStream)outputStream).build();
            WriteSheet sheet1 = EasyExcel.writerSheet((Integer)0, (String)"data").registerWriteHandler((WriteHandler)new ExcelCellStyleStrategy(detailList)).registerWriteHandler(ExcelCellStyleStrategy.TEMPLATE_WRITE_HANDLER).registerWriteHandler((WriteHandler)new ExcelDictWriteHandler(detailList, this.invokeBaseRpcService, this, excelByConfigDTO.getBusAccount())).includeColumnFiledNames(includeColumnSet).head(ExcelHeaderUtil.getHeaderList(detailList)).build();
            excelWriter.write(data, sheet1);
            log.info("exportExcel-sheet1:{}", (Object)JSON.toJSON((Object)sheet1).toString());
            if ("saleEnquiryItemExcelRpcServiceImpl".equals(excelByConfigDTO.getHandlerName())) {
                Integer sheetNum = SHEET_NUMBER.get();
                if (null == sheetNum) {
                    log.error(":::sheetNum ExcelItemExcelServiceImpl Builder Error...");
                }
                this.buildSaleEnquiryQuoteType(excelWriter, data, sheetNum);
            }
            log.info("exportExcel-excelWriter:{}", (Object)JSON.toJSON((Object)excelWriter).toString());
            excelWriter.finish();
            ExcelDictWriteHandler.CellStyleContext.STYLE.remove();
        }
        catch (Exception e) {
            ExcelDictWriteHandler.CellStyleContext.STYLE.remove();
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    @Override
    public Map<String, Object> importExcel(ExcelByConfigDTO excelByConfigDTO, MultipartFile file) {
        HashMap<String, Object> hashMap;
        block16: {
            List<ExcelDetail> detailList;
            ExcelItemByConfigRpcService excelItemByConfigRpcService = this.baseInvokeExcelItemExecuteService.getExcelItemByConfigRpcService(excelByConfigDTO.getHandlerName());
            ExcelHeader excelHeader = null;
            if ("excel".equals(excelByConfigDTO.getExcelTemplateType())) {
                excelHeader = this.excelHeaderMapper.selectByExcelCode(excelByConfigDTO.getExcelCode(), TenantContext.getTenant());
                if (excelHeader == null) {
                    excelHeader = this.excelHeaderMapper.selectByExcelCode(excelByConfigDTO.getExcelCode(), SysUtil.getPurchaseAccount());
                }
                if (excelHeader == null) {
                    excelHeader = this.excelHeaderMapper.selectByExcelCode(excelByConfigDTO.getExcelCode(), "100000");
                }
                detailList = this.excelDetailMapper.selectByMainId(excelHeader.getId());
            } else {
                detailList = this.getExcelDetail(excelByConfigDTO, excelItemByConfigRpcService);
            }
            if (CollectionUtil.isEmpty(detailList)) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5bfc\u5165\u6a21\u677f\u52a0\u8f7d\u9519\u8bef"));
            }
            InputStream inputStream = file.getInputStream();
            try {
                List<Map<String, Object>> otherSheetList = null;
                if ("saleEnquiryItemExcelRpcServiceImpl".equals(excelByConfigDTO.getHandlerName())) {
                    otherSheetList = this.readSaleEnquiryQuoteType(file);
                }
                ExcelDataListener listener = new ExcelDataListener((ExcelImportRpcService)excelItemByConfigRpcService, detailList, null, this.invokeBaseRpcService, otherSheetList, null == excelHeader ? excelByConfigDTO.getHandlerName() : excelHeader.getExcelCode(), null == excelHeader ? excelByConfigDTO.getExcelName() : excelHeader.getExcelName(), TenantContext.getTenant(), excelByConfigDTO, null);
                EasyExcel.read((InputStream)inputStream, (ReadListener)listener).sheet().headRowNumber(Integer.valueOf(0)).doRead();
                List<Map<String, Object>> importDataList = listener.getImportDataList();
                HashMap<String, Object> errorMap = new HashMap<String, Object>();
                errorMap.put("successCount", listener.getSuccessCount());
                errorMap.put("failCount", listener.getFailCount());
                if (CollectionUtil.isEmpty(importDataList) || CharSequenceUtil.isNotBlank((CharSequence)listener.getErrorExcelKey())) {
                    errorMap.put("errorId", listener.getErrorExcelKey());
                    throw new ELSExcelBootException(I18nUtil.translate((String)"i18n_alert_uNIrjWFxqjWVImSKuN_65704043", (String)"\u5bfc\u5165\u6a21\u677f\u7684\u6570\u636e\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u5bfc\u5165"), errorMap);
                }
                errorMap.put("dataList", importDataList);
                hashMap = errorMap;
                if (inputStream == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("\u5bfc\u5165\u9884\u89c8\u6570\u636e\u5f02\u5e38:{}", (Object)e.getMessage());
                    if (e instanceof ELSExcelBootException) {
                        throw (ELSExcelBootException)e;
                    }
                    throw new ELSBootException(e.getMessage());
                }
            }
            inputStream.close();
        }
        return hashMap;
    }

    private void buildSaleEnquiryQuoteType(ExcelWriter excelWriter, List<Object> data, Integer sheetNum) {
        List costQuoteList;
        JSONObject item;
        List ladderQuoteList = data.stream().filter(object -> {
            JSONObject item = JSONObject.parseObject((String)JSONObject.toJSONString((Object)object));
            return "1".equals(item.getString("quotePriceWay")) || "\u9636\u68af\u62a5\u4ef7".equals(item.getString("quotePriceWay"));
        }).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(ladderQuoteList)) {
            ArrayList<SaleEnquiryQuotePriceVO> dataList = new ArrayList<SaleEnquiryQuotePriceVO>();
            for (Object object2 : ladderQuoteList) {
                item = JSONObject.parseObject((String)JSONObject.toJSONString(object2));
                List ladderPriceList = JSONArray.parseArray((String)item.getString("ladderPriceJson"), JSONObject.class);
                for (JSONObject ladder : ladderPriceList) {
                    SaleEnquiryQuotePriceVO vo = new SaleEnquiryQuotePriceVO();
                    vo.setItemNumber(item.getString("itemNumber"));
                    vo.setMaterialNumber(item.getString("materialNumber"));
                    vo.setLadder(ladder.getString("ladder"));
                    vo.setLadderQuantity(ladder.getString("ladderQuantity"));
                    dataList.add(vo);
                }
            }
            Iterator iterator = sheetNum;
            sheetNum = sheetNum + 1;
            WriteSheet sheet2 = EasyExcel.writerSheet((Integer)sheetNum, (String)"\u9636\u68af\u62a5\u4ef7").head(SaleEnquiryQuotePriceVO.class).needHead(Boolean.valueOf(true)).build();
            excelWriter.write(dataList, sheet2);
        }
        if (CollectionUtil.isNotEmpty(costQuoteList = data.stream().filter(object -> {
            JSONObject item = JSONObject.parseObject((String)JSONObject.toJSONString((Object)object));
            return "2".equals(item.getString("quotePriceWay")) || "\u6210\u672c\u62a5\u4ef7".equals(item.getString("quotePriceWay"));
        }).collect(Collectors.toList()))) {
            for (Object object2 : costQuoteList) {
                item = JSONObject.parseObject((String)JSONObject.toJSONString(object2));
                JSONObject costJSon = JSONObject.parseObject((String)item.getString("costFormJson"));
                TemplateHeadVO headVO = this.templateHeadService.getAllConfig(costJSon.getString("templateAccount"), costJSon.getString("templateNumber"), costJSon.getString("templateVersion"));
                List<TemplateConfigHead> headList = headVO.getTemplateConfigHeadList();
                List<TemplateConfigItem> itemList = headVO.getTemplateConfigItemList();
                Integer n = sheetNum;
                sheetNum = sheetNum + 1;
                WriteSheet sheet2 = EasyExcel.writerSheet((Integer)sheetNum, (String)("\u6210\u672c\u62a5\u4ef7-" + item.getString("materialNumber"))).needHead(Boolean.valueOf(true)).registerWriteHandler((WriteHandler)new ExcelEnquiryCellStrategy()).registerWriteHandler((WriteHandler)new ExcelEnquiryCellWriteCellStyle()).build();
                List groups = JSONArray.parseArray((String)costJSon.getString("groups"), SaleEnquiryCostQuotePriceGroupVO.class);
                ArrayList excelHeadList = new ArrayList();
                if (null != groups) {
                    for (SaleEnquiryCostQuotePriceGroupVO group : groups) {
                        ArrayList<String> excelItemCodeList = new ArrayList<String>();
                        ArrayList<String> excelItemNameList = new ArrayList<String>();
                        excelItemCodeList.add(group.getGroupCode());
                        excelItemCodeList.add(group.getGroupName());
                        excelItemNameList.add(group.getGroupCode());
                        excelItemNameList.add(group.getGroupName());
                        List groupList = itemList.stream().filter(info -> group.getGroupCode().equals(info.getGroupCode())).collect(Collectors.toList());
                        if (!groupList.isEmpty()) {
                            for (TemplateConfigItem configItem : groupList) {
                                excelItemCodeList.add(configItem.getFieldName());
                                excelItemNameList.add(configItem.getFieldLabel());
                            }
                        } else {
                            List headGroupList = headList.stream().filter(info -> group.getGroupCode().equals(info.getGroupCode())).collect(Collectors.toList());
                            for (TemplateConfigHead configHead : headGroupList) {
                                excelItemCodeList.add(configHead.getFieldName());
                                excelItemNameList.add(configHead.getFieldLabel());
                            }
                        }
                        excelHeadList.add(excelItemCodeList);
                        excelHeadList.add(excelItemNameList);
                        ArrayList<String> excelItemCodeList2 = new ArrayList<String>();
                        excelItemCodeList2.add(group.getGroupCode());
                        excelItemCodeList2.add(group.getGroupName());
                        excelHeadList.add(excelItemCodeList2);
                        excelHeadList.add(excelItemCodeList2);
                        excelHeadList.add(excelItemCodeList2);
                    }
                }
                excelWriter.write(excelHeadList, sheet2);
            }
            if (excelWriter != null) {
                excelWriter.finish();
            }
            SHEET_NUMBER.remove();
        }
    }

    private List<Map<String, Object>> readSaleEnquiryQuoteType(MultipartFile file) {
        try {
            HashMap<String, List<Map<String, Object>>> costDataList = new HashMap<String, List<Map<String, Object>>>();
            InputStream inputStream = file.getInputStream();
            ExcelSaleEnquiryDataListener listener = new ExcelSaleEnquiryDataListener();
            ExcelReader excelReader = EasyExcel.read((InputStream)inputStream, (ReadListener)listener).headRowNumber(Integer.valueOf(0)).build();
            List sheets = excelReader.excelExecutor().sheetList();
            if (CollectionUtils.isEmpty((Collection)sheets)) {
                return null;
            }
            for (ReadSheet sheet : sheets) {
                if (!sheet.getSheetName().contains("\u9636\u68af\u62a5\u4ef7") && !sheet.getSheetName().contains("\u6210\u672c\u62a5\u4ef7")) continue;
                listener.setRow(0);
                listener.setTempCostDataMap(new HashMap<String, List<String>>());
                listener.setSheetCostDataMap(new ArrayList<Map<String, Object>>());
                excelReader.read(new ReadSheet[]{sheet});
                if (!sheet.getSheetName().contains("\u6210\u672c\u62a5\u4ef7")) continue;
                String materialNumber = sheet.getSheetName().replaceAll("\u6210\u672c\u62a5\u4ef7-", "");
                costDataList.put(materialNumber, listener.getSheetCostDataMap());
            }
            List<Map<String, Object>> list = listener.getDataList();
            HashMap<String, HashMap<String, List<Map<String, Object>>>> costMap = new HashMap<String, HashMap<String, List<Map<String, Object>>>>();
            costMap.put("costPrice", costDataList);
            list.add(costMap);
            return list;
        }
        catch (IOException e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }
}

