/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.template.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.modules.template.entity.TemplateConfigHeadHis;
import com.els.modules.template.entity.TemplateConfigItemHis;
import com.els.modules.template.entity.TemplateGroupHis;
import com.els.modules.template.entity.TemplateHeadHis;
import com.els.modules.template.mapper.TemplateConfigHeadHisMapper;
import com.els.modules.template.mapper.TemplateConfigItemHisMapper;
import com.els.modules.template.mapper.TemplateGroupHisMapper;
import com.els.modules.template.mapper.TemplateHeadHisMapper;
import com.els.modules.template.service.TemplateHeadHisService;
import com.els.modules.template.vo.TemplateHeadHisVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateHeadHisServiceImpl
extends ServiceImpl<TemplateHeadHisMapper, TemplateHeadHis>
implements TemplateHeadHisService {
    @Autowired
    private TemplateHeadHisMapper templateHeadHisMapper;
    @Autowired
    private TemplateGroupHisMapper templateGroupHisMapper;
    @Autowired
    private TemplateConfigHeadHisMapper templateConfigHeadHisMapper;
    @Autowired
    private TemplateConfigItemHisMapper templateConfigItemHisMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(TemplateHeadHis templateHeadHis, List<TemplateGroupHis> templateGroupHisList, List<TemplateConfigHeadHis> templateConfigHeadHisList, List<TemplateConfigItemHis> templateConfigItemHisList) {
        this.templateHeadHisMapper.insert((Object)templateHeadHis);
        for (TemplateGroupHis templateGroupHis : templateGroupHisList) {
            templateGroupHis.setHeadId(templateHeadHis.getId());
            this.templateGroupHisMapper.insert((Object)templateGroupHis);
        }
        for (TemplateConfigHeadHis templateConfigHeadHis : templateConfigHeadHisList) {
            templateConfigHeadHis.setHeadId(templateHeadHis.getId());
            this.templateConfigHeadHisMapper.insert((Object)templateConfigHeadHis);
        }
        for (TemplateConfigItemHis templateConfigItemHis : templateConfigItemHisList) {
            templateConfigItemHis.setHeadId(templateHeadHis.getId());
            this.templateConfigItemHisMapper.insert((Object)templateConfigItemHis);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(TemplateHeadHis templateHeadHis, List<TemplateGroupHis> templateGroupHisList, List<TemplateConfigHeadHis> templateConfigHeadHisList, List<TemplateConfigItemHis> templateConfigItemHisList) {
        this.templateHeadHisMapper.updateById((Object)templateHeadHis);
        this.templateGroupHisMapper.deleteByMainId(templateHeadHis.getId());
        this.templateConfigHeadHisMapper.deleteByMainId(templateHeadHis.getId());
        this.templateConfigItemHisMapper.deleteByMainId(templateHeadHis.getId());
        for (TemplateGroupHis templateGroupHis : templateGroupHisList) {
            templateGroupHis.setHeadId(templateHeadHis.getId());
            this.templateGroupHisMapper.insert((Object)templateGroupHis);
        }
        for (TemplateConfigHeadHis templateConfigHeadHis : templateConfigHeadHisList) {
            templateConfigHeadHis.setHeadId(templateHeadHis.getId());
            this.templateConfigHeadHisMapper.insert((Object)templateConfigHeadHis);
        }
        for (TemplateConfigItemHis templateConfigItemHis : templateConfigItemHisList) {
            templateConfigItemHis.setHeadId(templateHeadHis.getId());
            this.templateConfigItemHisMapper.insert((Object)templateConfigItemHis);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.templateGroupHisMapper.deleteByMainId(id);
        this.templateConfigHeadHisMapper.deleteByMainId(id);
        this.templateConfigItemHisMapper.deleteByMainId(id);
        this.templateHeadHisMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.templateGroupHisMapper.deleteByMainId(serializable.toString());
            this.templateConfigHeadHisMapper.deleteByMainId(serializable.toString());
            this.templateConfigItemHisMapper.deleteByMainId(serializable.toString());
            this.templateHeadHisMapper.deleteById(serializable);
        }
    }

    @Override
    public TemplateHeadHisVO getAllConfig(String busAccount, String templateNumber, String templateVersion) {
        TemplateHeadHisVO headHisVO = new TemplateHeadHisVO();
        TemplateHeadHis headHis = (TemplateHeadHis)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)busAccount)).eq(TemplateHeadHis::getTemplateNumber, (Object)templateNumber)).eq(TemplateHeadHis::getTemplateVersion, (Object)templateVersion)).last("limit 1")));
        if (headHis != null) {
            BeanUtils.copyProperties((Object)((Object)headHis), (Object)((Object)headHisVO));
            String headId = headHis.getId();
            List<TemplateConfigHeadHis> headHisList = this.templateConfigHeadHisMapper.selectByMainId(headId);
            headHisVO.setTemplateConfigHeadHisList(headHisList);
            List<TemplateConfigItemHis> itemHisList = this.templateConfigItemHisMapper.selectByMainId(headId);
            headHisVO.setTemplateConfigItemHisList(itemHisList);
        } else {
            headHisVO.setTemplateConfigHeadHisList(new ArrayList<TemplateConfigHeadHis>());
            headHisVO.setTemplateConfigItemHisList(new ArrayList<TemplateConfigItemHis>());
        }
        return headHisVO;
    }
}

